/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.gui.widget.imp;

import com.cleanroommc.multiblocked.api.gui.ingredient.IGhostIngredientTarget;
import com.cleanroommc.multiblocked.api.gui.widget.Widget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.SlotWidget;
import com.google.common.collect.Lists;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.IGhostIngredientHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class PhantomSlotWidget
extends SlotWidget
implements IGhostIngredientTarget {
    private boolean clearSlotOnRightClick;

    public PhantomSlotWidget(IItemHandlerModifiable itemHandler, int slotIndex, int xPosition, int yPosition) {
        super((IItemHandler)itemHandler, slotIndex, xPosition, yPosition, true, true);
    }

    public PhantomSlotWidget setClearSlotOnRightClick(boolean clearSlotOnRightClick) {
        this.clearSlotOnRightClick = clearSlotOnRightClick;
        return this;
    }

    @Override
    public Widget mouseClicked(int mouseX, int mouseY, int button) {
        if (this.isMouseOverElement(mouseX, mouseY) && this.gui != null) {
            if (this.isClientSideWidget && !this.gui.entityPlayer.field_71071_by.func_70445_o().func_190926_b()) {
                this.slotReference.func_75215_d(this.gui.entityPlayer.field_71071_by.func_70445_o());
            } else if (button == 1 && this.clearSlotOnRightClick && !this.slotReference.func_75211_c().func_190926_b()) {
                this.slotReference.func_75215_d(ItemStack.field_190927_a);
                this.writeClientAction(2, buf -> {});
            } else {
                this.gui.getModularUIGui().superMouseClicked(mouseX, mouseY, button);
            }
            return this;
        }
        return null;
    }

    @Override
    public ItemStack slotClick(int dragType, ClickType clickTypeIn, EntityPlayer player) {
        ItemStack stackHeld = player.field_71071_by.func_70445_o();
        return PhantomSlotWidget.slotClickPhantom(this.slotReference, dragType, clickTypeIn, stackHeld);
    }

    @Override
    public boolean canMergeSlot(ItemStack stack) {
        return false;
    }

    @Override
    public List<IGhostIngredientHandler.Target<?>> getPhantomTargets(Object ingredient) {
        if (!(ingredient instanceof ItemStack)) {
            return Collections.emptyList();
        }
        final Rectangle rectangle = this.toRectangleBox();
        return Lists.newArrayList((Object[])new IGhostIngredientHandler.Target[]{new IGhostIngredientHandler.Target<Object>(){

            @Nonnull
            public Rectangle getArea() {
                return rectangle;
            }

            public void accept(@Nonnull Object ingredient) {
                if (ingredient instanceof ItemStack) {
                    int mouseButton = Mouse.getEventButton();
                    boolean shiftDown = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
                    ClickType clickType = shiftDown ? ClickType.QUICK_MOVE : ClickType.PICKUP;
                    PhantomSlotWidget.slotClickPhantom(PhantomSlotWidget.this.slotReference, mouseButton, clickType, (ItemStack)ingredient);
                    PhantomSlotWidget.this.writeClientAction(1, buffer -> {
                        buffer.func_150788_a((ItemStack)ingredient);
                        buffer.func_150787_b(mouseButton);
                        buffer.writeBoolean(shiftDown);
                    });
                }
            }
        }});
    }

    @Override
    public void handleClientAction(int id, PacketBuffer buffer) {
        if (id == 1) {
            ItemStack stackHeld;
            try {
                stackHeld = buffer.func_150791_c();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            int mouseButton = buffer.func_150792_a();
            boolean shiftKeyDown = buffer.readBoolean();
            ClickType clickType = shiftKeyDown ? ClickType.QUICK_MOVE : ClickType.PICKUP;
            PhantomSlotWidget.slotClickPhantom(this.slotReference, mouseButton, clickType, stackHeld);
        } else if (id == 2) {
            this.slotReference.func_75215_d(ItemStack.field_190927_a);
        }
    }

    public static ItemStack slotClickPhantom(Slot slot, int mouseButton, ClickType clickTypeIn, ItemStack stackHeld) {
        ItemStack stack = ItemStack.field_190927_a;
        ItemStack stackSlot = slot.func_75211_c();
        if (!stackSlot.func_190926_b()) {
            stack = stackSlot.func_77946_l();
        }
        if (mouseButton == 2) {
            PhantomSlotWidget.fillPhantomSlot(slot, ItemStack.field_190927_a, mouseButton);
        } else if (mouseButton == 0 || mouseButton == 1) {
            if (stackSlot.func_190926_b()) {
                if (!stackHeld.func_190926_b()) {
                    PhantomSlotWidget.fillPhantomSlot(slot, stackHeld, mouseButton);
                }
            } else if (stackHeld.func_190926_b()) {
                PhantomSlotWidget.adjustPhantomSlot(slot, mouseButton, clickTypeIn);
            } else {
                if (PhantomSlotWidget.areItemsEqual(stackSlot, stackHeld)) {
                    PhantomSlotWidget.adjustPhantomSlot(slot, mouseButton, clickTypeIn);
                }
                PhantomSlotWidget.fillPhantomSlot(slot, stackHeld, mouseButton);
            }
        } else if (mouseButton == 5 && !slot.func_75216_d()) {
            PhantomSlotWidget.fillPhantomSlot(slot, stackHeld, mouseButton);
        }
        return stack;
    }

    private static void adjustPhantomSlot(Slot slot, int mouseButton, ClickType clickTypeIn) {
        int stackSize;
        ItemStack stackSlot = slot.func_75211_c();
        if (clickTypeIn == ClickType.QUICK_MOVE) {
            stackSize = mouseButton == 0 ? (stackSlot.func_190916_E() + 1) / 2 : stackSlot.func_190916_E() * 2;
        } else {
            int n = stackSize = mouseButton == 0 ? stackSlot.func_190916_E() - 1 : stackSlot.func_190916_E() + 1;
        }
        if (stackSize > slot.func_75219_a()) {
            stackSize = slot.func_75219_a();
        }
        stackSlot.func_190920_e(stackSize);
        slot.func_75215_d(stackSlot);
    }

    private static void fillPhantomSlot(Slot slot, ItemStack stackHeld, int mouseButton) {
        int stackSize;
        if (stackHeld.func_190926_b()) {
            slot.func_75215_d(ItemStack.field_190927_a);
            return;
        }
        int n = stackSize = mouseButton == 0 ? stackHeld.func_190916_E() : 1;
        if (stackSize > slot.func_75219_a()) {
            stackSize = slot.func_75219_a();
        }
        ItemStack phantomStack = stackHeld.func_77946_l();
        phantomStack.func_190920_e(stackSize);
        slot.func_75215_d(phantomStack);
    }

    public static boolean areItemsEqual(ItemStack itemStack1, ItemStack itemStack2) {
        return !ItemStack.func_179545_c((ItemStack)itemStack1, (ItemStack)itemStack2) || !ItemStack.func_77970_a((ItemStack)itemStack1, (ItemStack)itemStack2);
    }
}

