/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.gui.widget.imp;

import com.cleanroommc.multiblocked.api.gui.ingredient.IGhostIngredientTarget;
import com.cleanroommc.multiblocked.api.gui.widget.Widget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.TankWidget;
import com.google.common.collect.Lists;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.IGhostIngredientHandler;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class PhantomFluidWidget
extends TankWidget
implements IGhostIngredientTarget {
    private Consumer<FluidStack> fluidStackUpdater;

    public PhantomFluidWidget(IFluidTank fluidTank, int x, int y) {
        super(fluidTank, x, y, false, false);
    }

    public PhantomFluidWidget setFluidStackUpdater(Consumer<FluidStack> fluidStackUpdater) {
        this.fluidStackUpdater = fluidStackUpdater;
        return this;
    }

    public static FluidStack drainFrom(Object ingredient) {
        ItemStack itemStack;
        IFluidHandlerItem fluidHandler;
        if (ingredient instanceof ItemStack && (fluidHandler = (IFluidHandlerItem)(itemStack = (ItemStack)ingredient).getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) != null) {
            return fluidHandler.drain(Integer.MAX_VALUE, false);
        }
        return null;
    }

    @Override
    public List<IGhostIngredientHandler.Target<?>> getPhantomTargets(Object ingredient) {
        if (!(ingredient instanceof FluidStack) && PhantomFluidWidget.drainFrom(ingredient) == null) {
            return Collections.emptyList();
        }
        final Rectangle rectangle = this.toRectangleBox();
        return Lists.newArrayList((Object[])new IGhostIngredientHandler.Target[]{new IGhostIngredientHandler.Target<Object>(){

            @Nonnull
            public Rectangle getArea() {
                return rectangle;
            }

            public void accept(@Nonnull Object ingredient) {
                FluidStack ingredientStack = ingredient instanceof FluidStack ? (FluidStack)ingredient : PhantomFluidWidget.drainFrom(ingredient);
                if (ingredientStack != null) {
                    NBTTagCompound tagCompound = ingredientStack.writeToNBT(new NBTTagCompound());
                    PhantomFluidWidget.this.writeClientAction(2, buffer -> buffer.func_150786_a(tagCompound));
                }
                if (PhantomFluidWidget.this.isClientSideWidget && PhantomFluidWidget.this.fluidStackUpdater != null) {
                    PhantomFluidWidget.this.fluidStackUpdater.accept(ingredientStack);
                }
            }
        }});
    }

    @Override
    public void handleClientAction(int id, PacketBuffer buffer) {
        if (id == 1) {
            ItemStack itemStack = this.gui.entityPlayer.field_71071_by.func_70445_o().func_77946_l();
            if (!itemStack.func_190926_b()) {
                itemStack.func_190920_e(1);
                IFluidHandlerItem fluidHandler = (IFluidHandlerItem)itemStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
                if (fluidHandler != null) {
                    FluidStack resultFluid = fluidHandler.drain(Integer.MAX_VALUE, false);
                    this.fluidStackUpdater.accept(resultFluid);
                }
            } else {
                this.fluidStackUpdater.accept(null);
            }
        } else if (id == 2) {
            FluidStack fluidStack;
            try {
                fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)buffer.func_150793_b());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.fluidStackUpdater.accept(fluidStack);
        }
    }

    @Override
    public Widget mouseClicked(int mouseX, int mouseY, int button) {
        if (this.isMouseOverElement(mouseX, mouseY)) {
            this.writeClientAction(1, buffer -> {});
            if (this.isClientSideWidget && this.fluidStackUpdater != null) {
                this.fluidStackUpdater.accept(null);
            }
            return this;
        }
        return null;
    }
}

