/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.gui.widget.imp;

import com.cleanroommc.multiblocked.api.gui.widget.Widget;
import com.cleanroommc.multiblocked.util.Position;
import com.cleanroommc.multiblocked.util.Size;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LabelWidget
extends Widget {
    protected final Supplier<String> textSupplier;
    private String lastTextValue = "";
    private int color;
    private boolean drop;

    public LabelWidget(int xPosition, int yPosition, String text) {
        this(xPosition, yPosition, () -> text);
        this.setDrop(true);
        this.setTextColor(-1);
    }

    public LabelWidget(int xPosition, int yPosition, Supplier<String> text) {
        super(new Position(xPosition, yPosition), Size.ZERO);
        this.textSupplier = text;
    }

    public LabelWidget setTextColor(int color) {
        this.color = color;
        return this;
    }

    public LabelWidget setDrop(boolean drop) {
        this.drop = drop;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    private void updateSize() {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        String resultText = this.lastTextValue;
        this.setSize(new Size(fontRenderer.func_78256_a(resultText), fontRenderer.field_78288_b));
        if (this.uiAccess != null) {
            this.uiAccess.notifySizeChange();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawInBackground(int mouseX, int mouseY, float particleTicks) {
        String suppliedText = I18n.func_135052_a((String)this.textSupplier.get(), (Object[])new Object[0]);
        if (!suppliedText.equals(this.lastTextValue)) {
            this.lastTextValue = suppliedText;
            this.updateSize();
        }
        String[] split = suppliedText.split("\n");
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        Position position = this.getPosition();
        for (int i = 0; i < split.length; ++i) {
            fontRenderer.func_175065_a(split[i], (float)position.x, (float)(position.y + i * (fontRenderer.field_78288_b + 2)), this.color, this.drop);
        }
    }
}

