/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.gui.widget.imp;

import com.cleanroommc.multiblocked.api.gui.texture.ColorBorderTexture;
import com.cleanroommc.multiblocked.api.gui.texture.ResourceBorderTexture;
import com.cleanroommc.multiblocked.api.gui.texture.TextTexture;
import com.cleanroommc.multiblocked.api.gui.widget.WidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.ButtonWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.DialogWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.PhantomSlotWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.TextFieldWidget;
import java.util.function.Consumer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class ItemStackSelectorWidget
extends WidgetGroup {
    private Consumer<ItemStack> onItemStackUpdate;
    private final IItemHandlerModifiable handler;
    private final TextFieldWidget itemField;
    private ItemStack item = ItemStack.field_190927_a;

    public ItemStackSelectorWidget(WidgetGroup parent, int x, int y, int width) {
        super(x, y, width, 20);
        this.setClientSideWidget();
        this.itemField = (TextFieldWidget)new TextFieldWidget(22, 0, width - 46, 20, null, s -> {
            if (s != null && !s.isEmpty()) {
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(s));
                if (item == null) {
                    item = ItemStack.field_190927_a.func_77973_b();
                }
                if (!ItemStack.func_179545_c((ItemStack)item.func_190903_i(), (ItemStack)this.item) || !ItemStack.func_77970_a((ItemStack)item.func_190903_i(), (ItemStack)this.item)) {
                    this.item = item.func_190903_i();
                    this.onUpdate();
                }
            }
        }).setHoverTooltip("multiblocked.gui.tips.item_selector");
        this.handler = new ItemStackHandler(1);
        this.addWidget(new PhantomSlotWidget(this.handler, 0, 1, 1).setClearSlotOnRightClick(true).setChangeListener(() -> {
            this.setItemStack(this.handler.getStackInSlot(0));
            this.onUpdate();
        }).setBackgroundTexture(new ColorBorderTexture(1, -1)));
        this.addWidget(this.itemField);
        this.addWidget(new ButtonWidget(width - 21, 0, 20, 20, null, cd -> {
            if (this.item.func_190926_b()) {
                return;
            }
            TextFieldWidget nbtField = new TextFieldWidget(10, 10, parent.getSize().width - 50, 20, null, s -> {
                try {
                    this.item.func_77982_d(JsonToNBT.func_180713_a((String)s));
                    this.onUpdate();
                }
                catch (NBTException nBTException) {
                    // empty catch block
                }
            });
            new DialogWidget(parent, this.isClientSideWidget).setOnClosed(this::onUpdate).addWidget(nbtField);
            if (this.item.func_77942_o()) {
                nbtField.setCurrentString(this.item.func_77978_p().toString());
            }
        }).setButtonTexture(ResourceBorderTexture.BUTTON_COMMON, new TextTexture("NBT", -1).setDropShadow(true)).setHoverBorderTexture(1, -1).setHoverTooltip("multiblocked.gui.tips.item_tag"));
    }

    public ItemStack getItemStack() {
        return this.item;
    }

    public ItemStackSelectorWidget setItemStack(ItemStack itemStack) {
        this.item = itemStack == null ? ItemStack.field_190927_a : itemStack;
        this.item = this.item.func_77946_l();
        this.handler.setStackInSlot(0, this.item);
        this.itemField.setCurrentString(this.item.func_77973_b().getRegistryName().toString());
        return this;
    }

    public ItemStackSelectorWidget setOnItemStackUpdate(Consumer<ItemStack> onItemStackUpdate) {
        this.onItemStackUpdate = onItemStackUpdate;
        return this;
    }

    private void onUpdate() {
        this.handler.setStackInSlot(0, this.item);
        if (this.onItemStackUpdate != null) {
            this.onItemStackUpdate.accept(this.item);
        }
    }
}

