/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.gui.widget.imp;

import com.cleanroommc.multiblocked.api.gui.texture.IGuiTexture;
import com.cleanroommc.multiblocked.api.gui.util.DrawerHelper;
import com.cleanroommc.multiblocked.api.gui.widget.Widget;
import com.cleanroommc.multiblocked.util.Position;
import com.cleanroommc.multiblocked.util.Size;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ImageWidget
extends Widget {
    protected IGuiTexture area;
    private int border;
    private int borderColor;

    public ImageWidget(int xPosition, int yPosition, int width, int height) {
        super(xPosition, yPosition, width, height);
    }

    public ImageWidget(int xPosition, int yPosition, int width, int height, IGuiTexture area) {
        this(xPosition, yPosition, width, height);
        this.area = area;
    }

    public ImageWidget setImage(IGuiTexture area) {
        this.area = area;
        return this;
    }

    public IGuiTexture getImage() {
        return this.area;
    }

    public ImageWidget setBorder(int border, int color) {
        this.border = border;
        this.borderColor = color;
        return this;
    }

    @Override
    public void updateScreen() {
        if (this.area != null) {
            this.area.updateTick();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawInBackground(int mouseX, int mouseY, float partialTicks) {
        if (this.area == null) {
            return;
        }
        Position position = this.getPosition();
        Size size = this.getSize();
        this.area.draw(mouseX, mouseY, position.x, position.y, size.width, size.height);
        if (this.border > 0) {
            DrawerHelper.drawBorder(position.x, position.y, size.width, size.height, this.borderColor, this.border);
        }
    }
}

