/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.gui.widget.imp;

import com.cleanroommc.multiblocked.api.gui.texture.ColorBorderTexture;
import com.cleanroommc.multiblocked.api.gui.texture.ResourceBorderTexture;
import com.cleanroommc.multiblocked.api.gui.texture.TextTexture;
import com.cleanroommc.multiblocked.api.gui.widget.WidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.ButtonWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.DialogWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.PhantomFluidWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.TextFieldWidget;
import java.util.function.Consumer;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;

public class FluidStackSelectorWidget
extends WidgetGroup {
    private Consumer<FluidStack> onFluidStackUpdate;
    private final FluidTank handler;
    private final TextFieldWidget fluidField;
    private FluidStack fluid = new FluidStack(FluidRegistry.WATER, 0);

    public FluidStackSelectorWidget(WidgetGroup parent, int x, int y, int width) {
        super(x, y, width, 20);
        this.setClientSideWidget();
        this.fluidField = (TextFieldWidget)new TextFieldWidget(22, 0, width - 46, 20, null, s -> {
            if (s != null && !s.isEmpty()) {
                Fluid fluid = FluidRegistry.getFluid((String)s);
                if (fluid == null) {
                    this.fluid = new FluidStack(FluidRegistry.WATER, 0);
                    this.onUpdate();
                } else if (!this.fluid.isFluidEqual(new FluidStack(fluid, 1000))) {
                    this.fluid = new FluidStack(fluid, 1000);
                    this.onUpdate();
                }
            }
        }).setHoverTooltip("multiblocked.gui.tips.fluid_selector");
        this.handler = new FluidTank(1000);
        this.addWidget(new PhantomFluidWidget((IFluidTank)this.handler, 1, 1).setFluidStackUpdater(fluidStack -> {
            this.setFluidStack((FluidStack)fluidStack);
            this.onUpdate();
        }).setBackground(new ColorBorderTexture(1, -1)));
        this.addWidget(this.fluidField);
        this.addWidget(new ButtonWidget(width - 21, 0, 20, 20, null, cd -> {
            if (this.fluid.amount == 0) {
                return;
            }
            TextFieldWidget nbtField = new TextFieldWidget(10, 10, parent.getSize().width - 50, 20, null, s -> {
                try {
                    this.fluid.tag = JsonToNBT.func_180713_a((String)s);
                    this.onUpdate();
                }
                catch (NBTException nBTException) {
                    // empty catch block
                }
            });
            new DialogWidget(parent, this.isClientSideWidget).setOnClosed(this::onUpdate).addWidget(nbtField);
            if (this.fluid.tag != null) {
                nbtField.setCurrentString(this.fluid.tag.toString());
            }
        }).setButtonTexture(ResourceBorderTexture.BUTTON_COMMON, new TextTexture("NBT", -1).setDropShadow(true)).setHoverBorderTexture(1, -1).setHoverTooltip("multiblocked.gui.tips.fluid_tag"));
    }

    public FluidStack getFluidStack() {
        return this.fluid;
    }

    public FluidStackSelectorWidget setFluidStack(FluidStack fluidStack) {
        this.fluid = fluidStack == null ? new FluidStack(FluidRegistry.WATER, 0) : fluidStack;
        this.fluid = this.fluid.copy();
        this.fluid.amount = fluidStack == null ? 0 : 1000;
        this.handler.setFluid(this.fluid);
        this.fluidField.setCurrentString(this.fluid.getFluid().getName());
        return this;
    }

    public FluidStackSelectorWidget setOnFluidStackUpdate(Consumer<FluidStack> onFluidStackUpdate) {
        this.onFluidStackUpdate = onFluidStackUpdate;
        return this;
    }

    private void onUpdate() {
        this.handler.setFluid(this.fluid);
        if (this.onFluidStackUpdate != null) {
            this.onFluidStackUpdate.accept(this.fluid);
        }
    }
}

