/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.gui.widget.imp;

import com.cleanroommc.multiblocked.api.gui.texture.ColorBorderTexture;
import com.cleanroommc.multiblocked.api.gui.texture.ColorRectTexture;
import com.cleanroommc.multiblocked.api.gui.texture.GuiTextureGroup;
import com.cleanroommc.multiblocked.api.gui.texture.ResourceBorderTexture;
import com.cleanroommc.multiblocked.api.gui.texture.ResourceTexture;
import com.cleanroommc.multiblocked.api.gui.texture.TextTexture;
import com.cleanroommc.multiblocked.api.gui.util.FileNode;
import com.cleanroommc.multiblocked.api.gui.util.TreeNode;
import com.cleanroommc.multiblocked.api.gui.widget.Widget;
import com.cleanroommc.multiblocked.api.gui.widget.WidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.ButtonWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.ImageWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.TextFieldWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.TreeListWidget;
import com.cleanroommc.multiblocked.util.Size;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.renderer.GlStateManager;

public class DialogWidget
extends WidgetGroup {
    private static final int HEIGHT = 128;
    private static final int WIDTH = 184;
    public final WidgetGroup parent;
    protected boolean isParentInVisible;
    protected Runnable onClosed;

    public DialogWidget(WidgetGroup parent, boolean isClient) {
        super(0, 0, parent.getSize().width, parent.getSize().height);
        this.parent = parent;
        if (isClient) {
            this.setClientSideWidget();
        }
        parent.addWidget(this);
    }

    public DialogWidget setOnClosed(Runnable onClosed) {
        this.onClosed = onClosed;
        return this;
    }

    public DialogWidget setParentInVisible() {
        this.isParentInVisible = true;
        for (Widget widget : this.parent.widgets) {
            if (widget == this) continue;
            widget.setVisible(false);
            widget.setActive(false);
        }
        return this;
    }

    public void close() {
        this.parent.waitToRemoved(this);
        if (this.isParentInVisible) {
            for (Widget widget : this.parent.widgets) {
                widget.setVisible(true);
                widget.setActive(true);
            }
        }
        if (this.onClosed != null) {
            this.onClosed.run();
        }
    }

    @Override
    public void drawInBackground(int mouseX, int mouseY, float partialTicks) {
        GlStateManager.func_179097_i();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)200.0f);
        super.drawInBackground(mouseX, mouseY, partialTicks);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-200.0f);
        GlStateManager.func_179126_j();
    }

    @Override
    public Widget mouseClicked(int mouseX, int mouseY, int button) {
        if (!this.isMouseOverElement(mouseX, mouseY)) {
            return null;
        }
        Widget widget = super.mouseClicked(mouseX, mouseY, button);
        return widget == null ? this : widget;
    }

    @Override
    public Widget keyTyped(char charTyped, int keyCode) {
        Widget widget = super.keyTyped(charTyped, keyCode);
        if (widget == null && keyCode == 1) {
            this.close();
        }
        return widget == null ? this : widget;
    }

    public static Predicate<TreeNode<File, File>> suffixFilter(String suffix) {
        return node -> !node.isLeaf() || !((File)node.getContent()).isFile() || ((File)node.getContent()).getName().toLowerCase().endsWith(suffix.toLowerCase());
    }

    public static DialogWidget showFileDialog(WidgetGroup parent, String title, File dir, boolean isSelector, Predicate<TreeNode<File, File>> valid, Consumer<File> result) {
        Size size = parent.getSize();
        DialogWidget dialog = new DialogWidget(parent, true);
        if (!dir.isDirectory() && !dir.mkdirs()) {
            return dialog;
        }
        dialog.addWidget(new ImageWidget(0, 0, parent.getSize().width, parent.getSize().height, new ColorRectTexture(0x4F000000)));
        AtomicReference<File> selected = new AtomicReference<File>();
        selected.set(dir);
        dialog.addWidget(new TreeListWidget(0, 0, 130, size.height, new FileNode(dir).setValid(valid), node -> selected.set((File)node.getKey())).setNodeTexture(ResourceBorderTexture.BORDERED_BACKGROUND).canSelectNode(true).setLeafTexture(new ResourceTexture("multiblocked:textures/gui/darkened_slot.png")));
        int x = 130 + (size.width - 133 - 184) / 2;
        int y = (size.height - 128) / 2;
        dialog.addWidget(new ImageWidget(x, y, 184, 128, ResourceBorderTexture.BORDERED_BACKGROUND));
        dialog.addWidget(new ButtonWidget(x + 92 - 30 - 20, y + 128 - 32, 40, 20, cd -> {
            dialog.close();
            if (result != null) {
                result.accept((File)selected.get());
            }
        }).setButtonTexture(new ResourceTexture("multiblocked:textures/gui/darkened_slot.png"), new TextTexture("multiblocked.gui.tips.confirm", -1).setDropShadow(true)).setHoverBorderTexture(1, -16777216));
        dialog.addWidget(new ButtonWidget(x + 92 + 30 - 20, y + 128 - 32, 40, 20, cd -> {
            dialog.close();
            if (result != null) {
                result.accept(null);
            }
        }).setButtonTexture(new ResourceTexture("multiblocked:textures/gui/darkened_slot.png"), new TextTexture("multiblocked.gui.tips.cancel", -65536).setDropShadow(true)).setHoverBorderTexture(1, -16777216));
        if (isSelector) {
            dialog.addWidget(new ImageWidget(x + 8, y + 64 - 5, 168, 20, new GuiTextureGroup(new ColorBorderTexture(1, -1), new ColorRectTexture(-16777216))));
            dialog.addWidget(new ImageWidget(x + 8, y + 64 - 5, 168, 20, new TextTexture("", -1).setWidth(168).setType(TextTexture.TextType.ROLL).setSupplier(() -> {
                if (selected.get() != null) {
                    return ((File)selected.get()).toString();
                }
                return "no file selected";
            })));
        } else {
            dialog.addWidget(new TextFieldWidget(x + 92 - 38, y + 64 - 10, 76, 20, true, () -> {
                File file = (File)selected.get();
                if (file != null && !file.isDirectory()) {
                    return ((File)selected.get()).getName();
                }
                return "";
            }, res -> {
                File file = (File)selected.get();
                if (file == null) {
                    return;
                }
                if (file.isDirectory()) {
                    selected.set(new File(file, (String)res));
                } else {
                    selected.set(new File(file.getParent(), (String)res));
                }
            }));
        }
        dialog.addWidget(new ButtonWidget(x + 15, y + 15, 20, 20, cd -> {
            File file = (File)selected.get();
            if (file != null) {
                try {
                    Desktop.getDesktop().open(file.isDirectory() ? file : file.getParentFile());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }).setButtonTexture(new ResourceTexture("multiblocked:textures/gui/darkened_slot.png"), new TextTexture("F", -1).setDropShadow(true)).setHoverBorderTexture(1, -16777216).setHoverTooltip("multiblocked.gui.tips.open_folder"));
        dialog.addWidget(new ImageWidget(x + 15, y + 20, 154, 10, new TextTexture(title, -1).setWidth(154).setDropShadow(true)));
        return dialog;
    }
}

