/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.gui.widget.imp;

import com.cleanroommc.multiblocked.api.gui.texture.ColorBorderTexture;
import com.cleanroommc.multiblocked.api.gui.texture.IGuiTexture;
import com.cleanroommc.multiblocked.api.gui.util.ClickData;
import com.cleanroommc.multiblocked.api.gui.widget.Widget;
import com.cleanroommc.multiblocked.util.Position;
import com.cleanroommc.multiblocked.util.Size;
import java.util.function.Consumer;
import net.minecraft.network.PacketBuffer;
import org.apache.commons.lang3.ArrayUtils;

public class ButtonWidget
extends Widget {
    protected IGuiTexture[] buttonTexture;
    protected IGuiTexture[] hoverTexture;
    protected Consumer<ClickData> onPressCallback;

    public ButtonWidget(int xPosition, int yPosition, int width, int height, IGuiTexture buttonTexture, Consumer<ClickData> onPressed) {
        super(xPosition, yPosition, width, height);
        IGuiTexture[] iGuiTextureArray;
        this.onPressCallback = onPressed;
        if (buttonTexture == null) {
            iGuiTextureArray = null;
        } else {
            IGuiTexture[] iGuiTextureArray2 = new IGuiTexture[1];
            iGuiTextureArray = iGuiTextureArray2;
            iGuiTextureArray2[0] = buttonTexture;
        }
        this.buttonTexture = iGuiTextureArray;
    }

    public ButtonWidget(int xPosition, int yPosition, int width, int height, Consumer<ClickData> onPressed) {
        super(xPosition, yPosition, width, height);
        this.onPressCallback = onPressed;
    }

    public ButtonWidget setOnPressCallback(Consumer<ClickData> onPressCallback) {
        this.onPressCallback = onPressCallback;
        return this;
    }

    public ButtonWidget setButtonTexture(IGuiTexture ... buttonTexture) {
        this.buttonTexture = buttonTexture;
        return this;
    }

    public ButtonWidget setHoverTexture(IGuiTexture ... hoverTexture) {
        this.hoverTexture = hoverTexture;
        return this;
    }

    public ButtonWidget setHoverBorderTexture(int border, int color) {
        this.hoverTexture = (IGuiTexture[])ArrayUtils.add((Object[])this.buttonTexture, (Object)new ColorBorderTexture(border, color));
        return this;
    }

    @Override
    public void updateScreen() {
        if (this.buttonTexture != null) {
            for (IGuiTexture texture : this.buttonTexture) {
                texture.updateTick();
            }
        }
        if (this.hoverTexture != null) {
            for (IGuiTexture texture : this.hoverTexture) {
                texture.updateTick();
            }
        }
    }

    @Override
    public void drawInBackground(int mouseX, int mouseY, float partialTicks) {
        block3: {
            Size size;
            Position position;
            block2: {
                position = this.getPosition();
                size = this.getSize();
                if (!this.isMouseOverElement(mouseX, mouseY) || this.hoverTexture == null) break block2;
                for (IGuiTexture texture : this.hoverTexture) {
                    texture.draw(mouseX, mouseY, position.x, position.y, size.width, size.height);
                }
                break block3;
            }
            if (this.buttonTexture == null) break block3;
            for (IGuiTexture texture : this.buttonTexture) {
                texture.draw(mouseX, mouseY, position.x, position.y, size.width, size.height);
            }
        }
    }

    @Override
    public Widget mouseClicked(int mouseX, int mouseY, int button) {
        if (this.isMouseOverElement(mouseX, mouseY)) {
            ClickData clickData = new ClickData();
            this.writeClientAction(1, clickData::writeToBuf);
            if (this.onPressCallback != null) {
                this.onPressCallback.accept(clickData);
            }
            ButtonWidget.playButtonClickSound();
            return this;
        }
        return null;
    }

    @Override
    public void handleClientAction(int id, PacketBuffer buffer) {
        super.handleClientAction(id, buffer);
        if (id == 1) {
            ClickData clickData = ClickData.readFromBuf(buffer);
            if (this.onPressCallback != null) {
                this.onPressCallback.accept(clickData);
            }
        }
    }
}

