/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.gui.widget.imp;

import com.cleanroommc.multiblocked.api.gui.texture.ColorBorderTexture;
import com.cleanroommc.multiblocked.api.gui.widget.WidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.PhantomSlotWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.TextFieldWidget;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class BlockSelectorWidget
extends WidgetGroup {
    private Consumer<IBlockState> onBlockStateUpdate;
    private Block block;
    private int meta;
    private final IItemHandlerModifiable handler;
    private final TextFieldWidget blockField;
    private final TextFieldWidget metaField;

    public BlockSelectorWidget(int x, int y, boolean isState) {
        super(x, y, 180, 20);
        this.setClientSideWidget();
        this.blockField = (TextFieldWidget)new TextFieldWidget(22, 0, isState ? 119 : 139, 20, true, null, s -> {
            Block block;
            if (s != null && !s.isEmpty() && this.block != (block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(s)))) {
                this.block = block;
                this.onUpdate();
            }
        }).setHoverTooltip("multiblocked.gui.tips.block_register");
        this.metaField = (TextFieldWidget)new TextFieldWidget(142, 0, 20, 20, true, null, s -> {
            this.meta = Integer.parseInt(s);
            this.onUpdate();
        }).setNumbersOnly(0, 15).setHoverTooltip("multiblocked.gui.tips.block_meta");
        this.handler = new ItemStackHandler(1);
        this.addWidget(new PhantomSlotWidget(this.handler, 0, 1, 1).setClearSlotOnRightClick(true).setChangeListener(() -> {
            ItemStack stack = this.handler.getStackInSlot(0);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemBlock)) {
                IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)stack);
                if (handler != null && handler.getTankProperties().length > 0 && handler.getTankProperties()[0].getContents() != null) {
                    Fluid fluid = handler.getTankProperties()[0].getContents().getFluid();
                    this.setBlock(fluid.getBlock().func_176223_P());
                    this.onUpdate();
                    return;
                }
                if (this.block != null) {
                    this.block = null;
                    this.meta = 0;
                    this.blockField.setCurrentString("");
                    this.metaField.setCurrentString("0");
                    this.onUpdate();
                }
            } else {
                ItemBlock itemBlock = (ItemBlock)stack.func_77973_b();
                this.block = itemBlock.func_179223_d();
                this.meta = itemBlock.func_77647_b(stack.func_77960_j());
                this.blockField.setCurrentString(this.block.getRegistryName() == null ? "" : this.block.getRegistryName().toString());
                this.metaField.setCurrentString(this.meta + "");
                this.onUpdate();
            }
        }).setBackgroundTexture(new ColorBorderTexture(1, -1)));
        this.addWidget(this.blockField);
        if (isState) {
            this.addWidget(this.metaField);
        }
    }

    public IBlockState getBlock() {
        try {
            return this.block == null ? null : this.block.func_176203_a(this.meta);
        }
        catch (Exception e) {
            return this.block == null ? null : this.block.func_176223_P();
        }
    }

    public BlockSelectorWidget setBlock(IBlockState blockState) {
        if (blockState == null) {
            this.block = null;
            this.meta = 0;
            this.handler.setStackInSlot(0, ItemStack.field_190927_a);
            this.blockField.setCurrentString("");
            this.metaField.setCurrentString("0");
        } else {
            this.block = blockState.func_177230_c();
            this.meta = this.block.func_176201_c(blockState);
            this.handler.setStackInSlot(0, this.block == null ? ItemStack.field_190927_a : new ItemStack(Item.func_150898_a((Block)this.block), 1, this.block.func_180651_a(this.getBlock())));
            this.blockField.setCurrentString(this.block.getRegistryName() == null ? "" : this.block.getRegistryName().toString());
            this.metaField.setCurrentString(this.meta + "");
        }
        return this;
    }

    public BlockSelectorWidget setOnBlockStateUpdate(Consumer<IBlockState> onBlockStateUpdate) {
        this.onBlockStateUpdate = onBlockStateUpdate;
        return this;
    }

    private void onUpdate() {
        this.handler.setStackInSlot(0, this.block == null ? ItemStack.field_190927_a : new ItemStack(Item.func_150898_a((Block)this.block), 1, this.block.func_180651_a(this.getBlock())));
        if (this.onBlockStateUpdate != null) {
            this.onBlockStateUpdate.accept(this.getBlock());
        }
    }
}

