/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.gui.widget;

import com.cleanroommc.multiblocked.Multiblocked;
import com.cleanroommc.multiblocked.api.gui.ingredient.IGhostIngredientTarget;
import com.cleanroommc.multiblocked.api.gui.ingredient.IIngredientSlot;
import com.cleanroommc.multiblocked.api.gui.modular.WidgetUIAccess;
import com.cleanroommc.multiblocked.api.gui.widget.Widget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.SlotWidget;
import com.cleanroommc.multiblocked.util.Position;
import com.cleanroommc.multiblocked.util.Size;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import mezz.jei.api.gui.IGhostIngredientHandler;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;

public class WidgetGroup
extends Widget
implements IGhostIngredientTarget,
IIngredientSlot {
    public final transient List<Widget> widgets = new ArrayList<Widget>();
    private final transient WidgetGroupUIAccess groupUIAccess = new WidgetGroupUIAccess();
    private final transient boolean isDynamicSized;
    private transient boolean initialized = false;
    protected final transient List<Widget> waitToRemoved;
    protected final transient List<Widget> waitToAdded;

    public WidgetGroup(int x, int y, int width, int height) {
        super(x, y, width, height);
        this.isDynamicSized = false;
        this.waitToRemoved = new ArrayList<Widget>();
        this.waitToAdded = new ArrayList<Widget>();
    }

    public WidgetGroup(Position position) {
        super(position, Size.ZERO);
        this.isDynamicSized = true;
        this.waitToRemoved = new ArrayList<Widget>();
        this.waitToAdded = new ArrayList<Widget>();
    }

    public WidgetGroup(Position position, Size size) {
        super(position, size);
        this.isDynamicSized = false;
        this.waitToRemoved = new ArrayList<Widget>();
        this.waitToAdded = new ArrayList<Widget>();
    }

    @Override
    public void writeInitialData(PacketBuffer buffer) {
        for (Widget widget : this.widgets) {
            if (widget.isClientSideWidget) continue;
            widget.writeInitialData(buffer);
        }
    }

    @Override
    public void readInitialData(PacketBuffer buffer) {
        for (Widget widget : this.widgets) {
            if (widget.isClientSideWidget) continue;
            widget.readInitialData(buffer);
        }
    }

    @Override
    public WidgetGroup setClientSideWidget() {
        super.setClientSideWidget();
        for (Widget widget : this.widgets) {
            widget.setClientSideWidget();
        }
        return this;
    }

    public List<Widget> getContainedWidgets(boolean includeHidden) {
        ArrayList<Widget> containedWidgets = new ArrayList<Widget>(this.widgets.size());
        for (Widget widget : this.widgets) {
            if (!widget.isVisible() && !includeHidden) continue;
            containedWidgets.add(widget);
            if (!(widget instanceof WidgetGroup)) continue;
            containedWidgets.addAll(((WidgetGroup)widget).getContainedWidgets(includeHidden));
        }
        return containedWidgets;
    }

    @Override
    protected void onPositionUpdate() {
        Position selfPosition = this.getPosition();
        for (Widget widget : this.widgets) {
            widget.setParentPosition(selfPosition);
        }
        this.recomputeSize();
    }

    protected boolean recomputeSize() {
        Size dynamicSize;
        Size currentSize;
        if (this.isDynamicSized && !(currentSize = this.getSize()).equals(dynamicSize = this.computeDynamicSize())) {
            this.setSize(dynamicSize);
            if (this.uiAccess != null) {
                this.uiAccess.notifySizeChange();
            }
            return true;
        }
        return false;
    }

    protected Size computeDynamicSize() {
        Position selfPosition = this.getPosition();
        Size currentSize = this.getSize();
        for (Widget widget : this.widgets) {
            Position size = widget.getPosition().add(widget.getSize()).subtract(selfPosition);
            if (size.x > currentSize.width) {
                currentSize = new Size(size.x, currentSize.height);
            }
            if (size.y <= currentSize.height) continue;
            currentSize = new Size(currentSize.width, size.y);
        }
        return currentSize;
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.isVisible() == visible) {
            return;
        }
        super.setVisible(visible);
    }

    public WidgetGroup addWidget(Widget widget) {
        if (widget == this) {
            throw new IllegalArgumentException("Cannot add self");
        }
        if (this.widgets.contains(widget)) {
            throw new IllegalArgumentException("Already added");
        }
        this.widgets.add(widget);
        widget.setUiAccess(this.groupUIAccess);
        widget.setGui(this.gui);
        widget.setParentPosition(this.getPosition());
        if (this.isClientSideWidget) {
            widget.setClientSideWidget();
        }
        if (this.initialized) {
            widget.initWidget();
        }
        this.recomputeSize();
        if (this.uiAccess != null && !this.isClientSideWidget) {
            this.uiAccess.notifyWidgetChange();
        }
        return this;
    }

    public WidgetGroup addWidget(int index, Widget widget) {
        if (widget == this) {
            throw new IllegalArgumentException("Cannot add self");
        }
        if (this.widgets.contains(widget)) {
            throw new IllegalArgumentException("Already added");
        }
        this.widgets.add(index, widget);
        widget.setUiAccess(this.groupUIAccess);
        widget.setGui(this.gui);
        widget.setParentPosition(this.getPosition());
        if (this.isClientSideWidget) {
            widget.setClientSideWidget();
        }
        if (this.initialized) {
            widget.initWidget();
        }
        this.recomputeSize();
        if (this.uiAccess != null) {
            this.uiAccess.notifyWidgetChange();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitToRemoved(Widget widget) {
        List<Widget> list = this.waitToRemoved;
        synchronized (list) {
            this.waitToRemoved.add(widget);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitToAdded(Widget widget) {
        List<Widget> list = this.waitToAdded;
        synchronized (list) {
            this.waitToAdded.add(widget);
        }
    }

    public int getAllWidgetSize() {
        return this.widgets.size() - this.waitToRemoved.size() + this.waitToAdded.size();
    }

    public void removeWidget(Widget widget) {
        if (!this.widgets.contains(widget)) {
            return;
        }
        this.widgets.remove(widget);
        widget.setUiAccess(null);
        widget.setGui(null);
        widget.setParentPosition(Position.ORIGIN);
        this.recomputeSize();
        if (this.uiAccess != null && !this.isClientSideWidget) {
            this.uiAccess.notifyWidgetChange();
        }
    }

    public void clearAllWidgets() {
        this.widgets.forEach(it -> {
            it.setUiAccess(null);
            it.setGui(null);
            it.setParentPosition(Position.ORIGIN);
        });
        this.widgets.clear();
        this.recomputeSize();
        if (this.uiAccess != null) {
            this.uiAccess.notifyWidgetChange();
        }
    }

    @Override
    public void initWidget() {
        this.initialized = true;
        for (Widget widget : this.widgets) {
            widget.setGui(this.gui);
            widget.initWidget();
        }
    }

    @Override
    public List<SlotWidget> getNativeWidgets() {
        ArrayList<SlotWidget> nativeWidgets = new ArrayList<SlotWidget>();
        for (Widget widget : this.widgets) {
            nativeWidgets.addAll(widget.getNativeWidgets());
        }
        return nativeWidgets;
    }

    @Override
    public List<IGhostIngredientHandler.Target<?>> getPhantomTargets(Object ingredient) {
        if (!this.isVisible()) {
            return Collections.emptyList();
        }
        ArrayList targets = new ArrayList();
        for (Widget widget : this.widgets) {
            if (!widget.isVisible() || !(widget instanceof IGhostIngredientTarget)) continue;
            targets.addAll(((IGhostIngredientTarget)((Object)widget)).getPhantomTargets(ingredient));
        }
        return targets;
    }

    @Override
    public Object getIngredientOverMouse(int mouseX, int mouseY) {
        if (!this.isVisible()) {
            return Collections.emptyList();
        }
        for (Widget widget : this.widgets) {
            IIngredientSlot ingredientSlot;
            Object result;
            if (!widget.isVisible() || !(widget instanceof IIngredientSlot) || (result = (ingredientSlot = (IIngredientSlot)((Object)widget)).getIngredientOverMouse(mouseX, mouseY)) == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public void detectAndSendChanges() {
        for (Widget widget : this.widgets) {
            if (!widget.isActive()) continue;
            widget.detectAndSendChanges();
        }
        this.handleSyncWidget();
    }

    @Override
    public void updateScreen() {
        for (Widget widget : this.widgets) {
            if (!widget.isActive()) continue;
            widget.updateScreen();
        }
        this.handleSyncWidget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSyncWidget() {
        List<Widget> list;
        if (!this.waitToRemoved.isEmpty()) {
            list = this.waitToRemoved;
            synchronized (list) {
                this.waitToRemoved.forEach(this::removeWidget);
                this.waitToRemoved.clear();
            }
        }
        if (!this.waitToAdded.isEmpty()) {
            list = this.waitToAdded;
            synchronized (list) {
                this.waitToAdded.forEach(this::addWidget);
                this.waitToAdded.clear();
            }
        }
    }

    @Override
    public void drawInForeground(int mouseX, int mouseY, float partialTicks) {
        super.drawInForeground(mouseX, mouseY, partialTicks);
        for (Widget widget : this.widgets) {
            if (!widget.isVisible()) continue;
            widget.drawInForeground(mouseX, mouseY, partialTicks);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    @Override
    public void drawInBackground(int mouseX, int mouseY, float partialTicks) {
        for (Widget widget : this.widgets) {
            if (!widget.isVisible()) continue;
            widget.drawInBackground(mouseX, mouseY, partialTicks);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    @Override
    public Widget mouseWheelMove(int mouseX, int mouseY, int wheelDelta) {
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            Widget widget = this.widgets.get(i);
            if (!widget.isVisible() || !widget.isActive() || (widget = widget.mouseWheelMove(mouseX, mouseY, wheelDelta)) == null) continue;
            return widget;
        }
        return null;
    }

    @Override
    public Widget mouseClicked(int mouseX, int mouseY, int button) {
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            Widget widget = this.widgets.get(i);
            if (!widget.isVisible() || !widget.isActive() || (widget = widget.mouseClicked(mouseX, mouseY, button)) == null) continue;
            return widget;
        }
        return null;
    }

    @Override
    public Widget mouseDragged(int mouseX, int mouseY, int button, long timeDragged) {
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            Widget widget = this.widgets.get(i);
            if (!widget.isVisible() || !widget.isActive() || (widget = widget.mouseDragged(mouseX, mouseY, button, timeDragged)) == null) continue;
            return widget;
        }
        return null;
    }

    @Override
    public Widget mouseReleased(int mouseX, int mouseY, int button) {
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            Widget widget = this.widgets.get(i);
            if (!widget.isVisible() || !widget.isActive() || (widget = widget.mouseReleased(mouseX, mouseY, button)) == null) continue;
            return widget;
        }
        return null;
    }

    @Override
    public Widget keyTyped(char charTyped, int keyCode) {
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            Widget widget = this.widgets.get(i);
            if (!widget.isVisible() || !widget.isActive() || (widget = widget.keyTyped(charTyped, keyCode)) == null) continue;
            return widget;
        }
        return null;
    }

    @Override
    public void readUpdateInfo(int id, PacketBuffer buffer) {
        if (id == 1) {
            int widgetIndex = buffer.func_150792_a();
            int widgetUpdateId = buffer.func_150792_a();
            Widget widget = this.widgets.get(widgetIndex);
            widget.readUpdateInfo(widgetUpdateId, buffer);
        }
    }

    @Override
    public void handleClientAction(int id, PacketBuffer buffer) {
        if (id == 1) {
            int widgetIndex = buffer.func_150792_a();
            int widgetUpdateId = buffer.func_150792_a();
            if (widgetIndex < this.widgets.size()) {
                Widget widget = this.widgets.get(widgetIndex);
                widget.handleClientAction(widgetUpdateId, buffer);
            } else {
                Multiblocked.LOGGER.error("xxx");
            }
        }
    }

    private class WidgetGroupUIAccess
    implements WidgetUIAccess {
        private WidgetGroupUIAccess() {
        }

        @Override
        public void notifySizeChange() {
            WidgetUIAccess uiAccess = WidgetGroup.this.uiAccess;
            WidgetGroup.this.recomputeSize();
            if (uiAccess != null) {
                uiAccess.notifySizeChange();
            }
        }

        @Override
        public boolean attemptMergeStack(ItemStack itemStack, boolean fromContainer, boolean simulate) {
            WidgetUIAccess uiAccess = WidgetGroup.this.uiAccess;
            if (uiAccess != null) {
                return uiAccess.attemptMergeStack(itemStack, fromContainer, simulate);
            }
            return false;
        }

        @Override
        public void sendSlotUpdate(SlotWidget slot) {
            WidgetUIAccess uiAccess = WidgetGroup.this.uiAccess;
            if (uiAccess != null) {
                uiAccess.sendSlotUpdate(slot);
            }
        }

        @Override
        public void sendHeldItemUpdate() {
            WidgetUIAccess uiAccess = WidgetGroup.this.uiAccess;
            if (uiAccess != null) {
                uiAccess.sendHeldItemUpdate();
            }
        }

        @Override
        public void notifyWidgetChange() {
            WidgetUIAccess uiAccess = WidgetGroup.this.uiAccess;
            if (uiAccess != null) {
                uiAccess.notifyWidgetChange();
            }
            WidgetGroup.this.recomputeSize();
        }

        @Override
        public void writeClientAction(Widget widget, int updateId, Consumer<PacketBuffer> dataWriter) {
            WidgetGroup.this.writeClientAction(1, buffer -> {
                buffer.func_150787_b(WidgetGroup.this.widgets.indexOf(widget));
                buffer.func_150787_b(updateId);
                dataWriter.accept((PacketBuffer)buffer);
            });
        }

        @Override
        public void writeUpdateInfo(Widget widget, int updateId, Consumer<PacketBuffer> dataWriter) {
            WidgetGroup.this.writeUpdateInfo(1, buffer -> {
                buffer.func_150787_b(WidgetGroup.this.widgets.indexOf(widget));
                buffer.func_150787_b(updateId);
                dataWriter.accept((PacketBuffer)buffer);
            });
        }
    }
}

