/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.gui.widget;

import com.cleanroommc.multiblocked.Multiblocked;
import com.cleanroommc.multiblocked.api.gui.modular.ModularUI;
import com.cleanroommc.multiblocked.api.gui.modular.WidgetUIAccess;
import com.cleanroommc.multiblocked.api.gui.util.DrawerHelper;
import com.cleanroommc.multiblocked.api.gui.widget.imp.SlotWidget;
import com.cleanroommc.multiblocked.util.Position;
import com.cleanroommc.multiblocked.util.Size;
import com.google.common.base.Preconditions;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class Widget {
    protected ModularUI gui;
    protected WidgetUIAccess uiAccess;
    private Position parentPosition = Position.ORIGIN;
    private Position selfPosition;
    private Position position;
    private Size size;
    private boolean isVisible;
    private boolean isActive;
    private boolean isFocus;
    protected boolean isClientSideWidget;
    protected String tooltipText;

    public Widget(Position selfPosition, Size size) {
        Preconditions.checkNotNull((Object)selfPosition, (Object)"selfPosition");
        Preconditions.checkNotNull((Object)size, (Object)"size");
        this.selfPosition = selfPosition;
        this.size = size;
        this.position = this.parentPosition.add(selfPosition);
        this.isVisible = true;
        this.isActive = true;
    }

    public Widget(int x, int y, int width, int height) {
        this(new Position(x, y), new Size(width, height));
    }

    public Widget setClientSideWidget() {
        this.isClientSideWidget = true;
        return this;
    }

    public Widget setHoverTooltip(String tooltipText) {
        this.tooltipText = tooltipText == null || tooltipText.isEmpty() ? null : tooltipText;
        return this;
    }

    public void setGui(ModularUI gui) {
        this.gui = gui;
    }

    public ModularUI getGui() {
        return this.gui;
    }

    public void setUiAccess(WidgetUIAccess uiAccess) {
        this.uiAccess = uiAccess;
    }

    public void setParentPosition(Position parentPosition) {
        Preconditions.checkNotNull((Object)parentPosition, (Object)"parentPosition");
        this.parentPosition = parentPosition;
        this.recomputePosition();
    }

    public void setSelfPosition(Position selfPosition) {
        Preconditions.checkNotNull((Object)selfPosition, (Object)"selfPosition");
        this.selfPosition = selfPosition;
        this.recomputePosition();
    }

    public Position addSelfPosition(int addX, int addY) {
        this.selfPosition = new Position(this.selfPosition.x + addX, this.selfPosition.y + addY);
        this.recomputePosition();
        return this.selfPosition;
    }

    public Position getSelfPosition() {
        return this.selfPosition;
    }

    public void setSize(Size size) {
        Preconditions.checkNotNull((Object)size, (Object)"size");
        this.size = size;
        this.onSizeUpdate();
    }

    public final Position getPosition() {
        return this.position;
    }

    public final Size getSize() {
        return this.size;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisible(boolean visible) {
        this.isVisible = visible;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean active) {
        this.isActive = active;
    }

    public Rectangle toRectangleBox() {
        Position pos = this.getPosition();
        Size size = this.getSize();
        return new Rectangle(pos.x, pos.y, size.width, size.height);
    }

    protected void recomputePosition() {
        this.position = this.parentPosition.add(this.selfPosition);
        this.onPositionUpdate();
    }

    protected void onPositionUpdate() {
    }

    protected void onSizeUpdate() {
    }

    public boolean isMouseOverElement(int mouseX, int mouseY) {
        Position position = this.getPosition();
        Size size = this.getSize();
        return Widget.isMouseOver(position.x, position.y, size.width, size.height, mouseX, mouseY);
    }

    public static boolean isMouseOver(int x, int y, int width, int height, int mouseX, int mouseY) {
        return mouseX >= x && mouseY >= y && x + width > mouseX && y + height > mouseY;
    }

    public void initWidget() {
    }

    public void writeInitialData(PacketBuffer buffer) {
    }

    public void readInitialData(PacketBuffer buffer) {
    }

    public void detectAndSendChanges() {
    }

    public void updateScreen() {
    }

    @SideOnly(value=Side.CLIENT)
    public void drawInForeground(int mouseX, int mouseY, float partialTicks) {
        if (this.tooltipText != null && !this.tooltipText.isEmpty() && this.gui != null && this.isMouseOverElement(mouseX, mouseY)) {
            GlStateManager.func_179126_j();
            List<String> hoverList = Arrays.asList(I18n.func_135052_a((String)this.tooltipText, (Object[])new Object[0]).split("\n"));
            DrawerHelper.drawHoveringText(ItemStack.field_190927_a, hoverList, 300, mouseX, mouseY, this.gui.getScreenWidth(), this.gui.getScreenHeight());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void drawInBackground(int mouseX, int mouseY, float partialTicks) {
    }

    @SideOnly(value=Side.CLIENT)
    public Widget mouseWheelMove(int mouseX, int mouseY, int wheelDelta) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public Widget mouseClicked(int mouseX, int mouseY, int button) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public Widget mouseDragged(int mouseX, int mouseY, int button, long timeDragged) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public Widget mouseReleased(int mouseX, int mouseY, int button) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public Widget keyTyped(char charTyped, int keyCode) {
        return null;
    }

    public void setFocus(boolean focus) {
        this.isFocus = focus;
    }

    public boolean isFocus() {
        return this.isFocus;
    }

    @SideOnly(value=Side.CLIENT)
    public void readUpdateInfo(int id, PacketBuffer buffer) {
    }

    public void handleClientAction(int id, PacketBuffer buffer) {
    }

    public List<SlotWidget> getNativeWidgets() {
        if (this instanceof SlotWidget) {
            return Collections.singletonList((SlotWidget)this);
        }
        return Collections.emptyList();
    }

    protected final void writeUpdateInfo(int id, Consumer<PacketBuffer> packetBufferWriter) {
        if (this.uiAccess != null && this.gui != null) {
            this.uiAccess.writeUpdateInfo(this, id, packetBufferWriter);
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected final void writeClientAction(int id, Consumer<PacketBuffer> packetBufferWriter) {
        if (this.uiAccess != null && !this.isClientSideWidget) {
            this.uiAccess.writeClientAction(this, id, packetBufferWriter);
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected static void playButtonClickSound() {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
    }

    @SideOnly(value=Side.CLIENT)
    protected static boolean isShiftDown() {
        return Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
    }

    @SideOnly(value=Side.CLIENT)
    protected static boolean isCtrlDown() {
        return Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157);
    }

    public boolean isRemote() {
        return this.gui != null && this.gui.holder != null ? this.gui.holder.isRemote() : Multiblocked.isClient();
    }
}

