/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.gui.util;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class TreeNode<T, K> {
    public final int dimension;
    protected final T key;
    protected K content;
    protected List<TreeNode<T, K>> children;
    protected Predicate<TreeNode<T, K>> valid;

    public TreeNode(int dimension, T key) {
        this.dimension = dimension;
        this.key = key;
    }

    public TreeNode<T, K> setValid(Predicate<TreeNode<T, K>> valid) {
        this.valid = valid;
        return this;
    }

    public boolean isLeaf() {
        return this.getChildren() == null || this.getChildren().isEmpty();
    }

    public TreeNode<T, K> getOrCreateChild(T childKey) {
        TreeNode<T, K> result;
        if (this.getChildren() != null) {
            result = this.getChildren().stream().filter(child -> child.key.equals(childKey)).findFirst().orElseGet(() -> {
                TreeNode<Object, K> newNode = new TreeNode<Object, K>(this.dimension + 1, childKey).setValid(this.valid);
                this.getChildren().add(newNode);
                return newNode;
            });
        } else {
            this.children = new ArrayList<TreeNode<T, K>>();
            result = new TreeNode<T, K>(this.dimension + 1, childKey).setValid(this.valid);
            this.getChildren().add(result);
        }
        return result;
    }

    public TreeNode<T, K> getChild(T key) {
        if (this.getChildren() != null) {
            for (TreeNode<T, K> child : this.getChildren()) {
                if (!child.key.equals(key)) continue;
                return child;
            }
        }
        return null;
    }

    public void addContent(T key, K content) {
        this.getOrCreateChild(key).content = content;
    }

    public T getKey() {
        return this.key;
    }

    public K getContent() {
        return this.content;
    }

    public List<TreeNode<T, K>> getChildren() {
        if (this.valid == null) {
            return this.children;
        }
        return this.children.stream().filter(this.valid).collect(Collectors.toList());
    }

    public String toString() {
        return this.key.toString();
    }
}

