/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.gui.util;

import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;

public class TextFormattingUtil {
    private static final NavigableMap<Long, String> suffixes = new TreeMap<Long, String>();
    private static final NavigableMap<Long, String> suffixesBucket = new TreeMap<Long, String>();

    public static String formatLongToCompactString(long value, int precision) {
        if (value == Long.MIN_VALUE) {
            return TextFormattingUtil.formatLongToCompactString(-9223372036854775807L, precision);
        }
        if (value < 0L) {
            return "-" + TextFormattingUtil.formatLongToCompactString(-value, precision);
        }
        if ((double)value < Math.pow(10.0, precision)) {
            return Long.toString(value);
        }
        Map.Entry<Long, String> e = suffixes.floorEntry(value);
        Long divideBy = e.getKey();
        String suffix = e.getValue();
        long truncated = value / (divideBy / 10L);
        boolean hasDecimal = truncated < 100L && (double)truncated / 10.0 != (double)truncated / 10.0;
        return hasDecimal ? (double)truncated / 10.0 + suffix : truncated / 10L + suffix;
    }

    public static String formatLongToCompactStringBuckets(long value, int precision) {
        if (value == Long.MIN_VALUE) {
            return TextFormattingUtil.formatLongToCompactStringBuckets(-9223372036854775807L, precision);
        }
        if (value < 0L) {
            return "-" + TextFormattingUtil.formatLongToCompactStringBuckets(-value, precision);
        }
        if ((double)value < Math.pow(10.0, precision)) {
            return value + suffixesBucket.floorEntry(value).getValue();
        }
        Map.Entry<Long, String> e = suffixesBucket.floorEntry(value);
        Long divideBy = e.getKey();
        String suffix = e.getValue();
        long truncated = value / (divideBy / 10L);
        boolean hasDecimal = truncated < 100L && (double)truncated / 10.0 != (double)truncated / 10.0;
        return hasDecimal ? (double)truncated / 10.0 + suffix : truncated / 10L + suffix;
    }

    static {
        suffixes.put(1000L, "k");
        suffixes.put(1000000L, "M");
        suffixes.put(1000000000L, "G");
        suffixes.put(1000000000000L, "T");
        suffixes.put(1000000000000000L, "P");
        suffixes.put(1000000000000000000L, "E");
        suffixesBucket.put(1L, "m");
        suffixesBucket.put(1000L, "");
        suffixesBucket.put(1000000L, "k");
        suffixesBucket.put(1000000000L, "M");
        suffixesBucket.put(1000000000000L, "G");
        suffixesBucket.put(1000000000000000L, "T");
        suffixesBucket.put(1000000000000000000L, "P");
    }
}

