/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.gui.util;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DrawerHelper {
    @SideOnly(value=Side.CLIENT)
    public static void drawFluidTexture(double xCoord, double yCoord, TextureAtlasSprite textureSprite, int maskTop, int maskRight, double zLevel) {
        double uMin = textureSprite.func_94209_e();
        double uMax = textureSprite.func_94212_f();
        double vMin = textureSprite.func_94206_g();
        double vMax = textureSprite.func_94210_h();
        uMax -= (double)maskRight / 16.0 * (uMax - uMin);
        vMax -= (double)maskTop / 16.0 * (vMax - vMin);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b(xCoord, yCoord + 16.0, zLevel).func_187315_a(uMin, vMax).func_181675_d();
        buffer.func_181662_b(xCoord + 16.0 - (double)maskRight, yCoord + 16.0, zLevel).func_187315_a(uMax, vMax).func_181675_d();
        buffer.func_181662_b(xCoord + 16.0 - (double)maskRight, yCoord + (double)maskTop, zLevel).func_187315_a(uMax, vMin).func_181675_d();
        buffer.func_181662_b(xCoord, yCoord + (double)maskTop, zLevel).func_187315_a(uMin, vMin).func_181675_d();
        tessellator.func_78381_a();
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawFluidForGui(FluidStack contents, int tankCapacity, int startX, int startY, int widthT, int heightT) {
        Fluid fluid = contents.getFluid();
        ResourceLocation fluidStill = fluid.getStill();
        TextureAtlasSprite fluidStillSprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(fluidStill.toString());
        int fluidColor = fluid.getColor(contents);
        int scaledAmount = contents.amount * heightT / tankCapacity;
        if (contents.amount > 0 && scaledAmount < 1) {
            scaledAmount = 1;
        }
        if (scaledAmount > heightT || contents.amount == tankCapacity) {
            scaledAmount = heightT;
        }
        GlStateManager.func_179147_l();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        int i = (fluidColor & 0xFF0000) >> 16;
        int j = (fluidColor & 0xFF00) >> 8;
        int k = fluidColor & 0xFF;
        GlStateManager.func_179131_c((float)((float)i / 255.0f), (float)((float)j / 255.0f), (float)((float)k / 255.0f), (float)1.0f);
        int xTileCount = widthT / 16;
        int xRemainder = widthT - xTileCount * 16;
        int yTileCount = scaledAmount / 16;
        int yRemainder = scaledAmount - yTileCount * 16;
        int yStart = startY + heightT;
        for (int xTile = 0; xTile <= xTileCount; ++xTile) {
            for (int yTile = 0; yTile <= yTileCount; ++yTile) {
                int width = xTile == xTileCount ? xRemainder : 16;
                int height = yTile == yTileCount ? yRemainder : 16;
                int x = startX + xTile * 16;
                int y = yStart - (yTile + 1) * 16;
                if (width <= 0 || height <= 0) continue;
                int maskTop = 16 - height;
                int maskRight = 16 - width;
                DrawerHelper.drawFluidTexture(x, y, fluidStillSprite, maskTop, maskRight, 0.0);
            }
        }
        GlStateManager.func_179084_k();
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawHoveringText(ItemStack itemStack, List<String> tooltip, int maxTextWidth, int mouseX, int mouseY, int screenWidth, int screenHeight) {
        Minecraft mc = Minecraft.func_71410_x();
        FontRenderer fontRenderer = itemStack.func_77973_b().getFontRenderer(itemStack);
        GuiUtils.drawHoveringText((ItemStack)itemStack, tooltip, (int)mouseX, (int)mouseY, (int)screenWidth, (int)screenHeight, (int)maxTextWidth, (FontRenderer)(fontRenderer == null ? mc.field_71466_p : fontRenderer));
        GlStateManager.func_179140_f();
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawBorder(int x, int y, int width, int height, int color, int border) {
        DrawerHelper.drawSolidRect(x - border, y - border, width + 2 * border, border, color);
        DrawerHelper.drawSolidRect(x - border, y + height, width + 2 * border, border, color);
        DrawerHelper.drawSolidRect(x - border, y, border, height, color);
        DrawerHelper.drawSolidRect(x + width, y, border, height, color);
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawStringSized(String text, double x, double y, int color, boolean dropShadow, float scale, boolean center) {
        GlStateManager.func_179094_E();
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        double scaledTextWidth = center ? (double)((float)fontRenderer.func_78256_a(text) * scale) : 0.0;
        GlStateManager.func_179137_b((double)(x - scaledTextWidth / 2.0), (double)y, (double)0.0);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        fontRenderer.func_175065_a(text, 0.0f, 0.0f, color, dropShadow);
        GlStateManager.func_179121_F();
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawStringFixedCorner(String text, double x, double y, int color, boolean dropShadow, float scale) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        double scaledWidth = (float)fontRenderer.func_78256_a(text) * scale;
        double scaledHeight = (float)fontRenderer.field_78288_b * scale;
        DrawerHelper.drawStringSized(text, x - scaledWidth, y - scaledHeight, color, dropShadow, scale, false);
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawText(String text, float x, float y, float scale, int color) {
        DrawerHelper.drawText(text, x, y, scale, color, false);
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawText(String text, float x, float y, float scale, int color, boolean shadow) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        GlStateManager.func_179084_k();
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)0.0f);
        float sf = 1.0f / scale;
        fontRenderer.func_175065_a(text, x * sf, y * sf, color, shadow);
        GlStateManager.func_179121_F();
        GlStateManager.func_179147_l();
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawItemStack(ItemStack itemStack, int x, int y, @Nullable String altTxt) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)32.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179091_B();
        GlStateManager.func_179145_e();
        RenderHelper.func_74520_c();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        Minecraft mc = Minecraft.func_71410_x();
        RenderItem itemRender = mc.func_175599_af();
        itemRender.func_180450_b(itemStack, x, y);
        itemRender.func_180453_a(mc.field_71466_p, itemStack, x, y, altTxt);
        GlStateManager.func_179101_C();
        GlStateManager.func_179140_f();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
        GlStateManager.func_179147_l();
        GlStateManager.func_179097_i();
    }

    @SideOnly(value=Side.CLIENT)
    public static List<String> getItemToolTip(ItemStack itemStack) {
        Minecraft mc = Minecraft.func_71410_x();
        ITooltipFlag.TooltipFlags flag = mc.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL;
        List tooltip = itemStack.func_82840_a((EntityPlayer)mc.field_71439_g, (ITooltipFlag)flag);
        for (int i = 0; i < tooltip.size(); ++i) {
            if (i == 0) {
                tooltip.set(i, itemStack.func_77973_b().getForgeRarity(itemStack).getColor() + (String)tooltip.get(i));
                continue;
            }
            tooltip.set(i, TextFormatting.GRAY + (String)tooltip.get(i));
        }
        return tooltip;
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawSelectionOverlay(int x, int y, int width, int height) {
        GlStateManager.func_179097_i();
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        DrawerHelper.drawGradientRect(x, y, width, height, -2130706433, -2130706433);
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GlStateManager.func_179126_j();
        GlStateManager.func_179147_l();
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawSolidRect(int x, int y, int width, int height, int color) {
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
        Gui.func_73734_a((int)x, (int)y, (int)(x + width), (int)(y + height), (int)color);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawRectShadow(int x, int y, int width, int height, int distance) {
        DrawerHelper.drawGradientRect(x + distance, y + height, width - distance, distance, 0x4F000000, 0, false);
        DrawerHelper.drawGradientRect(x + width, y + distance, distance, height - distance, 0x4F000000, 0, true);
        float startAlpha = 0.30980393f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(4, DefaultVertexFormats.field_181706_f);
        buffer.func_181662_b((double)(x += width), (double)(y += height), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, startAlpha).func_181675_d();
        buffer.func_181662_b((double)x, (double)(y + distance), 0.0).func_181669_b(0, 0, 0, 0).func_181675_d();
        buffer.func_181662_b((double)(x + distance), (double)(y + distance), 0.0).func_181669_b(0, 0, 0, 0).func_181675_d();
        buffer.func_181662_b((double)x, (double)y, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, startAlpha).func_181675_d();
        buffer.func_181662_b((double)(x + distance), (double)(y + distance), 0.0).func_181669_b(0, 0, 0, 0).func_181675_d();
        buffer.func_181662_b((double)(x + distance), (double)y, 0.0).func_181669_b(0, 0, 0, 0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawGradientRect(int x, int y, int width, int height, int startColor, int endColor) {
        DrawerHelper.drawGradientRect(x, y, width, height, startColor, endColor, false);
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawGradientRect(float x, float y, float width, float height, int startColor, int endColor, boolean horizontal) {
        float startAlpha = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float startRed = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float startGreen = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float startBlue = (float)(startColor & 0xFF) / 255.0f;
        float endAlpha = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float endRed = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float endGreen = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float endBlue = (float)(endColor & 0xFF) / 255.0f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        if (horizontal) {
            buffer.func_181662_b((double)(x + width), (double)y, 0.0).func_181666_a(endRed, endGreen, endBlue, endAlpha).func_181675_d();
            buffer.func_181662_b((double)x, (double)y, 0.0).func_181666_a(startRed, startGreen, startBlue, startAlpha).func_181675_d();
            buffer.func_181662_b((double)x, (double)(y + height), 0.0).func_181666_a(startRed, startGreen, startBlue, startAlpha).func_181675_d();
            buffer.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_181666_a(endRed, endGreen, endBlue, endAlpha).func_181675_d();
            tessellator.func_78381_a();
        } else {
            buffer.func_181662_b((double)(x + width), (double)y, 0.0).func_181666_a(startRed, startGreen, startBlue, startAlpha).func_181675_d();
            buffer.func_181662_b((double)x, (double)y, 0.0).func_181666_a(startRed, startGreen, startBlue, startAlpha).func_181675_d();
            buffer.func_181662_b((double)x, (double)(y + height), 0.0).func_181666_a(endRed, endGreen, endBlue, endAlpha).func_181675_d();
            buffer.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_181666_a(endRed, endGreen, endBlue, endAlpha).func_181675_d();
            tessellator.func_78381_a();
        }
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    @SideOnly(value=Side.CLIENT)
    public static void setColor(int color) {
        GlStateManager.func_179131_c((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)((float)(color >> 24 & 0xFF) / 255.0f));
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawCircle(float x, float y, float r, int color, int segments) {
        if (color == 0) {
            return;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        DrawerHelper.setColor(color);
        bufferbuilder.func_181668_a(9, DefaultVertexFormats.field_181705_e);
        for (int i = 0; i < segments; ++i) {
            bufferbuilder.func_181662_b((double)x + (double)r * Math.cos(Math.PI * -2 * (double)i / (double)segments), (double)y + (double)r * Math.sin(Math.PI * -2 * (double)i / (double)segments), 0.0).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawSector(float x, float y, float r, int color, int segments, int from, int to) {
        if (from > to || from < 0 || color == 0) {
            return;
        }
        if (to > segments) {
            to = segments;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        DrawerHelper.setColor(color);
        bufferbuilder.func_181668_a(4, DefaultVertexFormats.field_181705_e);
        for (int i = from; i < to; ++i) {
            bufferbuilder.func_181662_b((double)x + (double)r * Math.cos(Math.PI * -2 * (double)i / (double)segments), (double)y + (double)r * Math.sin(Math.PI * -2 * (double)i / (double)segments), 0.0).func_181675_d();
            bufferbuilder.func_181662_b((double)x + (double)r * Math.cos(Math.PI * -2 * (double)(i + 1) / (double)segments), (double)y + (double)r * Math.sin(Math.PI * -2 * (double)(i + 1) / (double)segments), 0.0).func_181675_d();
            bufferbuilder.func_181662_b((double)x, (double)y, 0.0).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawTorus(float x, float y, float outer, float inner, int color, int segments, int from, int to) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        DrawerHelper.setColor(color);
        bufferbuilder.func_181668_a(8, DefaultVertexFormats.field_181705_e);
        for (int i = from; i <= to; ++i) {
            float angle = (float)i / (float)segments * 3.14159f * 2.0f;
            bufferbuilder.func_181662_b((double)x + (double)inner * Math.cos(-angle), (double)y + (double)inner * Math.sin(-angle), 0.0).func_181675_d();
            bufferbuilder.func_181662_b((double)x + (double)outer * Math.cos(-angle), (double)y + (double)outer * Math.sin(-angle), 0.0).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawLines(List<Vec2f> points, int startColor, int endColor, float width) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_187441_d((float)width);
        if (startColor == endColor) {
            DrawerHelper.setColor(startColor);
            bufferbuilder.func_181668_a(3, DefaultVertexFormats.field_181705_e);
            for (Vec2f point : points) {
                bufferbuilder.func_181662_b((double)point.field_189982_i, (double)point.field_189983_j, 0.0).func_181675_d();
            }
        } else {
            float startAlpha = (float)(startColor >> 24 & 0xFF) / 255.0f;
            float startRed = (float)(startColor >> 16 & 0xFF) / 255.0f;
            float startGreen = (float)(startColor >> 8 & 0xFF) / 255.0f;
            float startBlue = (float)(startColor & 0xFF) / 255.0f;
            float endAlpha = (float)(endColor >> 24 & 0xFF) / 255.0f;
            float endRed = (float)(endColor >> 16 & 0xFF) / 255.0f;
            float endGreen = (float)(endColor >> 8 & 0xFF) / 255.0f;
            float endBlue = (float)(endColor & 0xFF) / 255.0f;
            bufferbuilder.func_181668_a(3, DefaultVertexFormats.field_181706_f);
            int size = points.size();
            for (int i = 0; i < size; ++i) {
                float p = (float)i * 1.0f / (float)size;
                bufferbuilder.func_181662_b((double)points.get((int)i).field_189982_i, (double)points.get((int)i).field_189983_j, 0.0).func_181666_a(startRed + (endRed - startRed) * p, startGreen + (endGreen - startGreen) * p, startBlue + (endBlue - startBlue) * p, startAlpha + (endAlpha - startAlpha) * p).func_181675_d();
            }
        }
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawTextureRect(double x, double y, double width, double height) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b(x, y + height, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        buffer.func_181662_b(x + width, y + height, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        buffer.func_181662_b(x + width, y, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        buffer.func_181662_b(x, y, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        tessellator.func_78381_a();
    }
}

