/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.gui.texture;

import com.cleanroommc.multiblocked.Multiblocked;
import com.cleanroommc.multiblocked.api.gui.texture.IGuiTexture;
import com.cleanroommc.multiblocked.api.gui.util.DrawerHelper;
import com.cleanroommc.multiblocked.client.shader.Shaders;
import com.cleanroommc.multiblocked.client.shader.management.Shader;
import com.cleanroommc.multiblocked.client.shader.management.ShaderManager;
import com.cleanroommc.multiblocked.client.shader.management.ShaderProgram;
import com.cleanroommc.multiblocked.client.shader.uniform.UniformCache;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ShaderTexture
implements IGuiTexture {
    @SideOnly(value=Side.CLIENT)
    private ShaderProgram program;
    @SideOnly(value=Side.CLIENT)
    private Shader shader;
    private float resolution = 2.0f;
    private Consumer<UniformCache> uniformCache;
    private final boolean isRaw;

    private ShaderTexture(boolean isRaw) {
        this.isRaw = isRaw;
    }

    public void dispose() {
        if (this.isRaw && this.shader != null) {
            this.shader.deleteShader();
        }
        if (this.program != null) {
            this.program.delete();
        }
        this.shader = null;
        this.program = null;
    }

    public void updateRawShader(String rawShader) {
        if (Multiblocked.isClient() && ShaderManager.allowedShader()) {
            this.dispose();
            this.shader = new Shader(Shader.ShaderType.FRAGMENT, rawShader).compileShader();
            this.program = new ShaderProgram();
            this.program.attach(this.shader);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private ShaderTexture(Shader shader, boolean isRaw) {
        this.isRaw = isRaw;
        if (shader == null) {
            return;
        }
        this.program = new ShaderProgram();
        this.shader = shader;
        this.program.attach(shader);
    }

    public static ShaderTexture createShader(ResourceLocation location) {
        if (Multiblocked.isClient() && ShaderManager.allowedShader()) {
            Shader shader = Shaders.load(Shader.ShaderType.FRAGMENT, location);
            return new ShaderTexture(shader, false);
        }
        return new ShaderTexture(false);
    }

    public static ShaderTexture createRawShader(String rawShader) {
        if (Multiblocked.isClient() && ShaderManager.allowedShader()) {
            Shader shader = new Shader(Shader.ShaderType.FRAGMENT, rawShader).compileShader();
            return new ShaderTexture(shader, true);
        }
        return new ShaderTexture(true);
    }

    public ShaderTexture setUniformCache(Consumer<UniformCache> uniformCache) {
        this.uniformCache = uniformCache;
        return this;
    }

    public ShaderTexture setResolution(float resolution) {
        this.resolution = resolution;
        return this;
    }

    public float getResolution() {
        return this.resolution;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(int mouseX, int mouseY, double x, double y, int width, int height) {
        if (this.program != null) {
            this.program.use(cache -> {
                Minecraft mc = Minecraft.func_71410_x();
                float time = mc.field_71439_g != null ? ((float)mc.field_71439_g.field_70173_aa + mc.func_184121_ak()) / 20.0f : (float)System.currentTimeMillis() / 1000.0f;
                float mX = (float)MathHelper.func_151237_a((double)((double)mouseX - x), (double)0.0, (double)width);
                float mY = (float)MathHelper.func_151237_a((double)((double)mouseY - y), (double)0.0, (double)height);
                cache.glUniform2F("iResolution", (float)width * this.resolution, (float)height * this.resolution);
                cache.glUniform2F("iMouse", mX * this.resolution, mY * this.resolution);
                cache.glUniform1F("iTime", time);
                if (this.uniformCache != null) {
                    this.uniformCache.accept(cache);
                }
            });
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            buffer.func_181662_b(x, y + (double)height, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
            buffer.func_181662_b(x + (double)width, y + (double)height, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
            buffer.func_181662_b(x + (double)width, y, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
            buffer.func_181662_b(x, y, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
            tessellator.func_78381_a();
            this.program.release();
        } else {
            DrawerHelper.drawText("Error compiling shader", (float)x + 2.0f, (float)y + 2.0f, 1.0f, -65536);
        }
    }
}

