/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.gui.texture;

import com.cleanroommc.multiblocked.api.gui.texture.IGuiTexture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ResourceTexture
implements IGuiTexture {
    public final ResourceLocation imageLocation;
    public final double offsetX;
    public final double offsetY;
    public final double imageWidth;
    public final double imageHeight;

    public ResourceTexture(ResourceLocation imageLocation, double offsetX, double offsetY, double width, double height) {
        this.imageLocation = imageLocation;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.imageWidth = width;
        this.imageHeight = height;
    }

    public ResourceTexture(String imageLocation) {
        this(new ResourceLocation(imageLocation), 0.0, 0.0, 1.0, 1.0);
    }

    public ResourceTexture getSubTexture(double offsetX, double offsetY, double width, double height) {
        return new ResourceTexture(this.imageLocation, this.offsetX + this.imageWidth * offsetX, this.offsetY + this.imageHeight * offsetY, this.imageWidth * width, this.imageHeight * height);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(int mouseX, int mouseY, double x, double y, int width, int height) {
        this.drawSubArea(x, y, width, height, 0.0, 0.0, 1.0, 1.0);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawSubArea(double x, double y, int width, int height, double drawnU, double drawnV, double drawnWidth, double drawnHeight) {
        double imageU = this.offsetX + this.imageWidth * drawnU;
        double imageV = this.offsetY + this.imageHeight * drawnV;
        double imageWidth = this.imageWidth * drawnWidth;
        double imageHeight = this.imageHeight * drawnHeight;
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.imageLocation);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b(x, y + (double)height, 0.0).func_187315_a(imageU, imageV + imageHeight).func_181675_d();
        bufferbuilder.func_181662_b(x + (double)width, y + (double)height, 0.0).func_187315_a(imageU + imageWidth, imageV + imageHeight).func_181675_d();
        bufferbuilder.func_181662_b(x + (double)width, y, 0.0).func_187315_a(imageU + imageWidth, imageV).func_181675_d();
        bufferbuilder.func_181662_b(x, y, 0.0).func_187315_a(imageU, imageV).func_181675_d();
        tessellator.func_78381_a();
    }
}

