/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.gui.texture;

import com.cleanroommc.multiblocked.api.gui.texture.ResourceTexture;

public class ResourceBorderTexture
extends ResourceTexture {
    public static final ResourceBorderTexture BORDERED_BACKGROUND = new ResourceBorderTexture("multiblocked:textures/gui/bordered_background.png", 195, 136, 4, 4);
    public static final ResourceBorderTexture BORDERED_BACKGROUND_BLUE = new ResourceBorderTexture("multiblocked:textures/gui/bordered_background_blue.png", 195, 136, 4, 4);
    public static final ResourceBorderTexture BUTTON_COMMON = new ResourceBorderTexture("multiblocked:textures/gui/button_common.png", 198, 18, 1, 1);
    public static final ResourceBorderTexture BAR = new ResourceBorderTexture("multiblocked:textures/gui/button_common.png", 180, 20, 1, 1);
    public final int pixelCornerWidth;
    public final int pixelCornerHeight;
    public final int pixelImageWidth;
    public final int pixelImageHeight;

    public ResourceBorderTexture(String imageLocation, int imageWidth, int imageHeight, int cornerWidth, int cornerHeight) {
        super(imageLocation);
        this.pixelImageWidth = imageWidth;
        this.pixelImageHeight = imageHeight;
        this.pixelCornerWidth = cornerWidth;
        this.pixelCornerHeight = cornerHeight;
    }

    @Override
    public void drawSubArea(double x, double y, int width, int height, double drawnU, double drawnV, double drawnWidth, double drawnHeight) {
        double cornerWidth = (double)this.pixelCornerWidth * 1.0 / (double)this.pixelImageWidth;
        double cornerHeight = (double)this.pixelCornerHeight * 1.0 / (double)this.pixelImageHeight;
        super.drawSubArea(x, y, this.pixelCornerWidth, this.pixelCornerHeight, 0.0, 0.0, cornerWidth, cornerHeight);
        super.drawSubArea(x + (double)width - (double)this.pixelCornerWidth, y, this.pixelCornerWidth, this.pixelCornerHeight, 1.0 - cornerWidth, 0.0, cornerWidth, cornerHeight);
        super.drawSubArea(x, y + (double)height - (double)this.pixelCornerHeight, this.pixelCornerWidth, this.pixelCornerHeight, 0.0, 1.0 - cornerHeight, cornerWidth, cornerHeight);
        super.drawSubArea(x + (double)width - (double)this.pixelCornerWidth, y + (double)height - (double)this.pixelCornerHeight, this.pixelCornerWidth, this.pixelCornerHeight, 1.0 - cornerWidth, 1.0 - cornerHeight, cornerWidth, cornerHeight);
        super.drawSubArea(x + (double)this.pixelCornerWidth, y, width - 2 * this.pixelCornerWidth, this.pixelCornerHeight, cornerWidth, 0.0, 1.0 - 2.0 * cornerWidth, cornerHeight);
        super.drawSubArea(x + (double)this.pixelCornerWidth, y + (double)height - (double)this.pixelCornerHeight, width - 2 * this.pixelCornerWidth, this.pixelCornerHeight, cornerWidth, 1.0 - cornerHeight, 1.0 - 2.0 * cornerWidth, cornerHeight);
        super.drawSubArea(x, y + (double)this.pixelCornerHeight, this.pixelCornerWidth, height - 2 * this.pixelCornerHeight, 0.0, cornerHeight, cornerWidth, 1.0 - 2.0 * cornerHeight);
        super.drawSubArea(x + (double)width - (double)this.pixelCornerWidth, y + (double)this.pixelCornerHeight, this.pixelCornerWidth, height - 2 * this.pixelCornerHeight, 1.0 - cornerWidth, cornerHeight, cornerWidth, 1.0 - 2.0 * cornerHeight);
        super.drawSubArea(x + (double)this.pixelCornerWidth, y + (double)this.pixelCornerHeight, width - 2 * this.pixelCornerWidth, height - 2 * this.pixelCornerHeight, cornerWidth, cornerHeight, 1.0 - 2.0 * cornerWidth, 1.0 - 2.0 * cornerHeight);
    }
}

