/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.gui.texture;

import com.cleanroommc.multiblocked.api.gui.texture.IGuiTexture;
import net.minecraft.util.math.MathHelper;

public class ProgressTexture
implements IGuiTexture {
    protected final IGuiTexture emptyBarArea;
    protected final IGuiTexture filledBarArea;
    protected double progress;
    protected FillDirection fillDirection = FillDirection.LEFT_TO_RIGHT;

    public ProgressTexture(IGuiTexture emptyBarArea, IGuiTexture filledBarArea) {
        this.emptyBarArea = emptyBarArea;
        this.filledBarArea = filledBarArea;
    }

    public void setProgress(double progress) {
        this.progress = MathHelper.func_151237_a((double)0.0, (double)progress, (double)1.0);
    }

    public void setFillDirection(FillDirection fillDirection) {
        this.fillDirection = fillDirection;
    }

    @Override
    public void draw(int mouseX, int mouseY, double x, double y, int width, int height) {
        if (this.emptyBarArea != null) {
            this.emptyBarArea.draw(mouseX, mouseY, x, y, width, height);
        }
        if (this.filledBarArea != null) {
            double drawnU = this.fillDirection.getDrawnU(this.progress);
            double drawnV = this.fillDirection.getDrawnV(this.progress);
            double drawnWidth = this.fillDirection.getDrawnWidth(this.progress);
            double drawnHeight = this.fillDirection.getDrawnHeight(this.progress);
            this.filledBarArea.drawSubArea(x + drawnU * (double)width, y + drawnV * (double)height, (int)((double)width * drawnWidth), (int)((double)height * drawnHeight), drawnU, drawnV, (double)((int)(drawnWidth * (double)width)) / ((double)width * 1.0), (double)((int)(drawnHeight * (double)height)) / ((double)height * 1.0));
        }
    }

    public static enum FillDirection {
        LEFT_TO_RIGHT{

            @Override
            public double getDrawnHeight(double progress) {
                return 1.0;
            }
        }
        ,
        RIGHT_TO_LEFT{

            @Override
            public double getDrawnU(double progress) {
                return 1.0 - progress;
            }

            @Override
            public double getDrawnHeight(double progress) {
                return 1.0;
            }
        }
        ,
        UP_TO_DOWN{

            @Override
            public double getDrawnWidth(double progress) {
                return 1.0;
            }
        }
        ,
        DOWN_TO_UP{

            @Override
            public double getDrawnV(double progress) {
                return 1.0 - progress;
            }

            @Override
            public double getDrawnWidth(double progress) {
                return 1.0;
            }
        }
        ,
        ALWAYS_FULL{

            @Override
            public double getDrawnHeight(double progress) {
                return 1.0;
            }

            @Override
            public double getDrawnWidth(double progress) {
                return 1.0;
            }
        };

        public static final FillDirection[] VALUES;

        public double getDrawnU(double progress) {
            return 0.0;
        }

        public double getDrawnV(double progress) {
            return 0.0;
        }

        public double getDrawnWidth(double progress) {
            return progress;
        }

        public double getDrawnHeight(double progress) {
            return progress;
        }

        static {
            VALUES = FillDirection.values();
        }
    }

    public static class Auto
    extends ProgressTexture {
        public Auto(IGuiTexture emptyBarArea, IGuiTexture filledBarArea) {
            super(emptyBarArea, filledBarArea);
        }

        @Override
        public void updateTick() {
            this.progress = (double)Math.abs(System.currentTimeMillis() % 2000L) / 2000.0;
        }
    }
}

