/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.gui.modular;

import com.cleanroommc.multiblocked.api.gui.ingredient.IGhostIngredientTarget;
import com.cleanroommc.multiblocked.api.gui.ingredient.IIngredientSlot;
import com.cleanroommc.multiblocked.api.gui.ingredient.IRecipeTransferHandlerWidget;
import com.cleanroommc.multiblocked.api.gui.modular.ModularUIContainer;
import com.cleanroommc.multiblocked.api.gui.modular.ModularUIGuiContainer;
import com.cleanroommc.multiblocked.api.gui.widget.Widget;
import com.google.common.collect.ImmutableSet;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.gui.IAdvancedGuiHandler;
import mezz.jei.api.gui.IGhostIngredientHandler;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import net.minecraft.entity.player.EntityPlayer;

public class ModularUIGuiHandler
implements IAdvancedGuiHandler<ModularUIGuiContainer>,
IGhostIngredientHandler<ModularUIGuiContainer>,
IRecipeTransferHandler<ModularUIContainer> {
    private final IRecipeTransferHandlerHelper transferHelper;

    public ModularUIGuiHandler(IRecipeTransferHandlerHelper transferHelper) {
        this.transferHelper = transferHelper;
    }

    @Nonnull
    public Class<ModularUIGuiContainer> getGuiContainerClass() {
        return ModularUIGuiContainer.class;
    }

    @Nonnull
    public Class<ModularUIContainer> getContainerClass() {
        return ModularUIContainer.class;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(ModularUIContainer container, @Nonnull IRecipeLayout recipeLayout, @Nonnull EntityPlayer player, boolean maxTransfer, boolean doTransfer) {
        Optional<IRecipeTransferHandlerWidget> transferHandler = container.getModularUI().getFlatVisibleWidgetCollection().stream().filter(it -> it instanceof IRecipeTransferHandlerWidget).map(it -> (IRecipeTransferHandlerWidget)((Object)it)).findFirst();
        if (!transferHandler.isPresent()) {
            return this.transferHelper.createInternalError();
        }
        String errorTooltip = transferHandler.get().transferRecipe(container, recipeLayout, player, maxTransfer, doTransfer);
        if (errorTooltip == null) {
            return null;
        }
        return this.transferHelper.createUserErrorWithTooltip(errorTooltip);
    }

    @Nullable
    public Object getIngredientUnderMouse(ModularUIGuiContainer gui, int mouseX, int mouseY) {
        for (Widget widget : gui.modularUI.guiWidgets.values()) {
            Object result;
            if (!(widget instanceof IIngredientSlot) || !widget.isVisible() || (result = ((IIngredientSlot)((Object)widget)).getIngredientOverMouse(mouseX, mouseY)) == null) continue;
            return result;
        }
        return null;
    }

    @Nonnull
    public <I> List<IGhostIngredientHandler.Target<I>> getTargets(ModularUIGuiContainer gui, @Nonnull I ingredient, boolean doStart) {
        ImmutableSet widgets = gui.modularUI.guiWidgets.values();
        ArrayList<IGhostIngredientHandler.Target<I>> targets = new ArrayList<IGhostIngredientHandler.Target<I>>();
        for (Widget widget : widgets) {
            if (!(widget instanceof IGhostIngredientTarget)) continue;
            IGhostIngredientTarget ghostTarget = (IGhostIngredientTarget)((Object)widget);
            List<IGhostIngredientHandler.Target<?>> widgetTargets = ghostTarget.getPhantomTargets(ingredient);
            targets.addAll(widgetTargets);
        }
        return targets;
    }

    @Nullable
    public List<Rectangle> getGuiExtraAreas(@Nonnull ModularUIGuiContainer guiContainer) {
        return Collections.emptyList();
    }

    public void onComplete() {
    }
}

