/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.gui.modular;

import com.cleanroommc.multiblocked.api.gui.modular.ModularUI;
import com.cleanroommc.multiblocked.api.gui.modular.WidgetUIAccess;
import com.cleanroommc.multiblocked.api.gui.util.PerTickIntCounter;
import com.cleanroommc.multiblocked.api.gui.widget.Widget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.SlotWidget;
import com.cleanroommc.multiblocked.network.MultiblockedNetworking;
import com.cleanroommc.multiblocked.network.c2s.CPacketUIClientAction;
import com.cleanroommc.multiblocked.network.s2c.SPacketUIWidgetUpdate;
import io.netty.buffer.Unpooled;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SPacketSetSlot;

public class ModularUIContainer
extends Container
implements WidgetUIAccess {
    protected final HashMap<Slot, SlotWidget> slotMap = new HashMap();
    private final ModularUI modularUI;
    private final PerTickIntCounter transferredPerTick = new PerTickIntCounter(0);

    public ModularUIContainer(ModularUI modularUI) {
        this.modularUI = modularUI;
        this.modularUI.setModularUIContainer(this);
        modularUI.guiWidgets.values().forEach(widget -> widget.setUiAccess(this));
        modularUI.guiWidgets.values().stream().flatMap(widget -> widget.getNativeWidgets().stream()).forEach(nativeWidget -> {
            Slot slot = nativeWidget.getHandle();
            this.slotMap.put(slot, (SlotWidget)nativeWidget);
            this.func_75146_a(slot);
        });
    }

    @Override
    public void notifySizeChange() {
    }

    @Override
    public void notifyWidgetChange() {
        List nativeWidgets = this.modularUI.guiWidgets.values().stream().flatMap(widget -> widget.getNativeWidgets().stream()).collect(Collectors.toList());
        HashSet<SlotWidget> removedWidgets = new HashSet<SlotWidget>(this.slotMap.values());
        removedWidgets.removeAll(nativeWidgets);
        if (!removedWidgets.isEmpty()) {
            for (SlotWidget removedWidget : removedWidgets) {
                Slot slotHandle = removedWidget.getHandle();
                this.slotMap.remove(slotHandle);
                EmptySlotPlaceholder emptySlotPlaceholder = new EmptySlotPlaceholder();
                emptySlotPlaceholder.field_75222_d = slotHandle.field_75222_d;
                this.field_75151_b.set(slotHandle.field_75222_d, emptySlotPlaceholder);
                this.field_75153_a.set(slotHandle.field_75222_d, (Object)ItemStack.field_190927_a);
            }
        }
        HashSet addedWidgets = new HashSet(nativeWidgets);
        addedWidgets.removeAll(this.slotMap.values());
        if (!addedWidgets.isEmpty()) {
            int[] emptySlotIndexes = this.field_75151_b.stream().filter(it -> it instanceof EmptySlotPlaceholder).mapToInt(slot -> slot.field_75222_d).toArray();
            int currentIndex = 0;
            for (SlotWidget addedWidget : addedWidgets) {
                Slot slotHandle = addedWidget.getHandle();
                this.slotMap.put(slotHandle, addedWidget);
                if (currentIndex < emptySlotIndexes.length) {
                    int slotIndex;
                    slotHandle.field_75222_d = slotIndex = emptySlotIndexes[currentIndex++];
                    this.field_75151_b.set(slotIndex, slotHandle);
                    this.field_75153_a.set(slotIndex, (Object)ItemStack.field_190927_a);
                    continue;
                }
                slotHandle.field_75222_d = this.field_75151_b.size();
                this.field_75151_b.add(slotHandle);
                this.field_75153_a.add((Object)ItemStack.field_190927_a);
            }
        }
    }

    public ModularUI getModularUI() {
        return this.modularUI;
    }

    public void func_75134_a(@Nonnull EntityPlayer playerIn) {
        super.func_75134_a(playerIn);
        this.modularUI.triggerCloseListeners();
    }

    public void func_75132_a(@Nonnull IContainerListener listener) {
        super.func_75132_a(listener);
        this.modularUI.guiWidgets.values().forEach(Widget::detectAndSendChanges);
    }

    @Override
    public void sendSlotUpdate(SlotWidget slot) {
        Slot slotHandle = slot.getHandle();
        for (IContainerListener listener : this.field_75149_d) {
            listener.func_71111_a((Container)this, slotHandle.field_75222_d, slotHandle.func_75211_c());
        }
    }

    @Override
    public void sendHeldItemUpdate() {
        for (IContainerListener listener : this.field_75149_d) {
            if (!(listener instanceof EntityPlayerMP)) continue;
            EntityPlayerMP player = (EntityPlayerMP)listener;
            player.field_71135_a.func_147359_a((Packet)new SPacketSetSlot(-1, -1, player.field_71071_by.func_70445_o()));
        }
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (this.field_75149_d.size() > 0) {
            this.modularUI.guiWidgets.values().forEach(Widget::detectAndSendChanges);
        }
    }

    @Nonnull
    public ItemStack func_184996_a(int slotId, int dragType, @Nonnull ClickType clickTypeIn, @Nonnull EntityPlayer player) {
        if (slotId >= 0 && slotId < this.field_75151_b.size()) {
            Slot slot = this.func_75139_a(slotId);
            ItemStack result = this.slotMap.get(slot).slotClick(dragType, clickTypeIn, player);
            if (result == null) {
                return super.func_184996_a(slotId, dragType, clickTypeIn, player);
            }
            return result;
        }
        if (slotId == -999) {
            super.func_184996_a(slotId, dragType, clickTypeIn, player);
        }
        return ItemStack.field_190927_a;
    }

    private List<SlotWidget> getShiftClickSlots(ItemStack itemStack, boolean fromContainer) {
        return this.slotMap.values().stream().filter(it -> it.canMergeSlot(itemStack)).filter(it -> it.isPlayerInventory == fromContainer).sorted(Comparator.comparing(s -> (fromContainer ? -1 : 1) * s.getHandle().field_75222_d)).collect(Collectors.toList());
    }

    @Override
    public boolean attemptMergeStack(ItemStack itemStack, boolean fromContainer, boolean simulate) {
        List<Slot> inventorySlots = this.getShiftClickSlots(itemStack, fromContainer).stream().map(SlotWidget::getHandle).collect(Collectors.toList());
        return ModularUIContainer.mergeItemStack(itemStack, inventorySlots, simulate);
    }

    public static boolean mergeItemStack(ItemStack itemStack, List<Slot> slots, boolean simulate) {
        if (itemStack.func_190926_b()) {
            return false;
        }
        boolean merged = false;
        for (Slot slot : slots) {
            ItemStack stackInSlot;
            if (!slot.func_75214_a(itemStack) || !ItemStack.func_179545_c((ItemStack)itemStack, (ItemStack)(stackInSlot = slot.func_75211_c())) || !ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)stackInSlot)) continue;
            int slotMaxStackSize = Math.min(stackInSlot.func_77976_d(), slot.func_178170_b(stackInSlot));
            int amountToInsert = Math.min(itemStack.func_190916_E(), slotMaxStackSize - stackInSlot.func_190916_E());
            if (amountToInsert == 0) continue;
            if (!simulate) {
                stackInSlot.func_190917_f(amountToInsert);
            }
            itemStack.func_190918_g(amountToInsert);
            slot.func_75218_e();
            merged = true;
            if (!itemStack.func_190926_b()) continue;
            return true;
        }
        for (Slot slot : slots) {
            int amountToInsert;
            if (!slot.func_75214_a(itemStack) || slot.func_75216_d() || (amountToInsert = Math.min(itemStack.func_190916_E(), slot.func_178170_b(itemStack))) == 0) continue;
            ItemStack stackInSlot = itemStack.func_77979_a(amountToInsert);
            if (!simulate) {
                slot.func_75215_d(stackInSlot);
            }
            merged = true;
            if (!itemStack.func_190926_b()) continue;
            return true;
        }
        return merged;
    }

    @Nonnull
    public ItemStack func_82846_b(@Nonnull EntityPlayer player, int index) {
        boolean fromContainer;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (!slot.func_82869_a(player)) {
            return ItemStack.field_190927_a;
        }
        if (!slot.func_75216_d()) {
            return ItemStack.field_190927_a;
        }
        ItemStack stackInSlot = slot.func_75211_c();
        ItemStack stackToMerge = this.slotMap.get(slot).onItemTake(player, stackInSlot.func_77946_l(), true);
        boolean bl = fromContainer = !this.slotMap.get((Object)slot).isPlayerInventory;
        if (!this.attemptMergeStack(stackToMerge, fromContainer, true)) {
            return ItemStack.field_190927_a;
        }
        int itemsMerged = stackToMerge.func_190926_b() || this.slotMap.get(slot).canMergeSlot(stackToMerge) ? stackInSlot.func_190916_E() - stackToMerge.func_190916_E() : stackInSlot.func_190916_E();
        int itemsToExtract = itemsMerged;
        if ((itemsMerged += this.transferredPerTick.get(player.field_70170_p)) > stackInSlot.func_77976_d()) {
            return ItemStack.field_190927_a;
        }
        this.transferredPerTick.increment(player.field_70170_p, itemsToExtract);
        ItemStack extractedStack = stackInSlot.func_77979_a(itemsToExtract);
        if (stackInSlot.func_190926_b()) {
            slot.func_75215_d(ItemStack.field_190927_a);
        } else {
            slot.func_75218_e();
        }
        extractedStack = this.slotMap.get(slot).onItemTake(player, extractedStack, false);
        ItemStack resultStack = extractedStack.func_77946_l();
        if (!this.attemptMergeStack(extractedStack, fromContainer, false)) {
            resultStack = ItemStack.field_190927_a;
        }
        if (!extractedStack.func_190926_b()) {
            player.func_146097_a(extractedStack, false, false);
            resultStack = ItemStack.field_190927_a;
        }
        return resultStack;
    }

    public boolean func_94530_a(@Nonnull ItemStack stack, @Nonnull Slot slotIn) {
        return this.slotMap.get(slotIn).canMergeSlot(stack);
    }

    public boolean func_75145_c(@Nonnull EntityPlayer playerIn) {
        return true;
    }

    @Override
    public void writeClientAction(Widget widget, int updateId, Consumer<PacketBuffer> payloadWriter) {
        int widgetId = (Integer)this.modularUI.guiWidgets.inverse().get((Object)widget);
        PacketBuffer packetBuffer = new PacketBuffer(Unpooled.buffer());
        packetBuffer.func_150787_b(updateId);
        payloadWriter.accept(packetBuffer);
        if (this.modularUI.entityPlayer instanceof EntityPlayerSP) {
            MultiblockedNetworking.sendToServer(new CPacketUIClientAction(this.field_75152_c, widgetId, packetBuffer));
        }
    }

    @Override
    public void writeUpdateInfo(Widget widget, int updateId, Consumer<PacketBuffer> payloadWriter) {
        int widgetId = (Integer)this.modularUI.guiWidgets.inverse().get((Object)widget);
        PacketBuffer packetBuffer = new PacketBuffer(Unpooled.buffer());
        packetBuffer.func_150787_b(updateId);
        payloadWriter.accept(packetBuffer);
        if (this.modularUI.entityPlayer instanceof EntityPlayerMP) {
            SPacketUIWidgetUpdate widgetUpdate = new SPacketUIWidgetUpdate(this.field_75152_c, widgetId, packetBuffer);
            MultiblockedNetworking.sendToPlayer(widgetUpdate, (EntityPlayerMP)this.modularUI.entityPlayer);
        }
    }

    private static class EmptySlotPlaceholder
    extends Slot {
        private static final IInventory EMPTY_INVENTORY = new InventoryBasic("Empty Inventory", false, 0);

        public EmptySlotPlaceholder() {
            super(EMPTY_INVENTORY, 0, -100000, -100000);
        }

        @Nonnull
        public ItemStack func_75211_c() {
            return ItemStack.field_190927_a;
        }

        public void func_75215_d(@Nonnull ItemStack stack) {
        }

        public boolean func_75214_a(@Nonnull ItemStack stack) {
            return false;
        }

        public boolean func_82869_a(@Nonnull EntityPlayer playerIn) {
            return false;
        }

        public boolean func_111238_b() {
            return false;
        }
    }
}

