/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.gui.modular;

import com.cleanroommc.multiblocked.api.gui.modular.IUIHolder;
import com.cleanroommc.multiblocked.api.gui.modular.ModularUIContainer;
import com.cleanroommc.multiblocked.api.gui.modular.ModularUIGuiContainer;
import com.cleanroommc.multiblocked.api.gui.texture.IGuiTexture;
import com.cleanroommc.multiblocked.api.gui.widget.Widget;
import com.cleanroommc.multiblocked.api.gui.widget.WidgetGroup;
import com.cleanroommc.multiblocked.util.Position;
import com.google.common.collect.ImmutableBiMap;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class ModularUI {
    public final ImmutableBiMap<Integer, Widget> guiWidgets;
    public final IGuiTexture backgroundPath;
    private int screenWidth;
    private int screenHeight;
    private int width;
    private int height;
    @SideOnly(value=Side.CLIENT)
    private ModularUIGuiContainer guiContainer;
    private ModularUIContainer container;
    private final List<Runnable> uiCloseCallback;
    public final IUIHolder holder;
    public final EntityPlayer entityPlayer;

    public ModularUI(ImmutableBiMap<Integer, Widget> guiWidgets, IGuiTexture backgroundPath, int width, int height, IUIHolder holder, EntityPlayer entityPlayer) {
        this.guiWidgets = guiWidgets;
        this.backgroundPath = backgroundPath == null ? IGuiTexture.EMPTY : backgroundPath;
        this.width = width;
        this.height = height;
        this.holder = holder;
        this.entityPlayer = entityPlayer;
        this.uiCloseCallback = new ArrayList<Runnable>();
    }

    public ModularUIContainer getModularUIContainer() {
        return this.container;
    }

    public void setModularUIContainer(ModularUIContainer container) {
        this.container = container;
    }

    public void registerCloseListener(Runnable runnable) {
        this.uiCloseCallback.add(runnable);
    }

    public void triggerCloseListeners() {
        this.uiCloseCallback.forEach(Runnable::run);
    }

    @SideOnly(value=Side.CLIENT)
    public ModularUIGuiContainer getModularUIGui() {
        return this.guiContainer;
    }

    @SideOnly(value=Side.CLIENT)
    public void setModularUIGui(ModularUIGuiContainer modularUIGuiContainer) {
        this.guiContainer = modularUIGuiContainer;
        if (this.guiContainer.field_147002_h instanceof ModularUIContainer) {
            this.setModularUIContainer((ModularUIContainer)this.guiContainer.field_147002_h);
        }
    }

    public List<Widget> getFlatVisibleWidgetCollection() {
        ArrayList<Widget> widgetList = new ArrayList<Widget>(this.guiWidgets.size());
        for (Widget widget : this.guiWidgets.values()) {
            if (!widget.isVisible()) continue;
            widgetList.add(widget);
            if (!(widget instanceof WidgetGroup)) continue;
            widgetList.addAll(((WidgetGroup)widget).getContainedWidgets(false));
        }
        return widgetList;
    }

    @SideOnly(value=Side.CLIENT)
    public void setSize(int width, int height) {
        if (this.width != width || this.height != height) {
            this.width = width;
            this.height = height;
            this.getModularUIGui().func_73866_w_();
        }
    }

    public void updateScreenSize(int screenWidth, int screenHeight) {
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
        Position displayOffset = new Position(this.getGuiLeft(), this.getGuiTop());
        this.guiWidgets.values().forEach(widget -> widget.setParentPosition(displayOffset));
    }

    public void initWidgets() {
        this.guiWidgets.values().forEach(widget -> {
            widget.setGui(this);
            widget.initWidget();
        });
    }

    public int getScreenWidth() {
        return this.screenWidth;
    }

    public int getScreenHeight() {
        return this.screenHeight;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getGuiLeft() {
        return (this.getScreenWidth() - this.getWidth()) / 2;
    }

    public int getGuiTop() {
        return (this.getScreenHeight() - this.getHeight()) / 2;
    }

    public Rectangle toScreenCoords(Rectangle widgetRect) {
        return new Rectangle(this.getGuiLeft() + widgetRect.x, this.getGuiTop() + widgetRect.y, widgetRect.width, widgetRect.height);
    }
}

