/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.gui.factory;

import com.cleanroommc.multiblocked.api.gui.modular.ModularUI;
import com.cleanroommc.multiblocked.api.gui.modular.ModularUIContainer;
import com.cleanroommc.multiblocked.api.gui.modular.ModularUIGuiContainer;
import com.cleanroommc.multiblocked.network.MultiblockedNetworking;
import com.cleanroommc.multiblocked.network.s2c.SPacketUIOpen;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class UIFactory<T> {
    public final int uiFactoryId = FACTORIES.size();
    public static final Int2ObjectMap<UIFactory<?>> FACTORIES = new Int2ObjectOpenHashMap();

    public static void register(UIFactory<?> factory) {
        FACTORIES.put(factory.uiFactoryId, factory);
    }

    public final boolean openUI(T holder, EntityPlayerMP player) {
        if (player instanceof FakePlayer) {
            return false;
        }
        ModularUI uiTemplate = this.createUITemplate(holder, (EntityPlayer)player);
        if (uiTemplate == null) {
            return false;
        }
        uiTemplate.initWidgets();
        player.func_71117_bO();
        player.func_71128_l();
        int currentWindowId = player.field_71139_cq;
        PacketBuffer serializedHolder = new PacketBuffer(Unpooled.buffer());
        this.writeHolderToSyncData(serializedHolder, holder);
        ModularUIContainer container = new ModularUIContainer(uiTemplate);
        container.field_75152_c = currentWindowId;
        uiTemplate.guiWidgets.values().forEach(w -> w.writeInitialData(serializedHolder));
        MultiblockedNetworking.sendToPlayer(new SPacketUIOpen(this.uiFactoryId, serializedHolder, currentWindowId), player);
        container.func_75132_a((IContainerListener)player);
        player.field_71070_bA = container;
        MinecraftForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Open((EntityPlayer)player, (Container)container));
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public final void initClientUI(PacketBuffer serializedHolder, int windowId) {
        T holder = this.readHolderFromSyncData(serializedHolder);
        Minecraft minecraft = Minecraft.func_71410_x();
        EntityPlayerSP entityPlayer = minecraft.field_71439_g;
        ModularUI uiTemplate = this.createUITemplate(holder, (EntityPlayer)entityPlayer);
        if (uiTemplate == null) {
            return;
        }
        uiTemplate.initWidgets();
        ModularUIGuiContainer ModularUIGuiContainer2 = new ModularUIGuiContainer(uiTemplate);
        ModularUIGuiContainer2.field_147002_h.field_75152_c = windowId;
        uiTemplate.guiWidgets.values().forEach(w -> w.readInitialData(serializedHolder));
        minecraft.func_152344_a(() -> {
            minecraft.func_147108_a((GuiScreen)ModularUIGuiContainer2);
            minecraft.field_71439_g.field_71070_bA.field_75152_c = windowId;
        });
    }

    protected abstract ModularUI createUITemplate(T var1, EntityPlayer var2);

    @SideOnly(value=Side.CLIENT)
    protected abstract T readHolderFromSyncData(PacketBuffer var1);

    protected abstract void writeHolderToSyncData(PacketBuffer var1, T var2);
}

