/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.definition;

import com.cleanroommc.multiblocked.Multiblocked;
import com.cleanroommc.multiblocked.api.json.IRendererTypeAdapterFactory;
import com.cleanroommc.multiblocked.api.sound.SoundState;
import com.cleanroommc.multiblocked.client.renderer.IRenderer;
import com.cleanroommc.multiblocked.util.ShapeUtils;
import com.google.common.base.Suppliers;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;

public class StatusProperties {
    public static final String UNFORMED = "unformed";
    public static final String IDLE = "idle";
    public static final String WORKING = "working";
    public static final String SUSPEND = "suspend";
    public static final StatusProperties EMPTY = new StatusProperties("unformed");
    public final boolean builtin;
    public String name;
    public StatusProperties parent;
    public Supplier<IRenderer> renderer;
    public Integer lightEmissive;
    public List<AxisAlignedBB> shape;
    public SoundState sound;
    private Map<EnumFacing, List<AxisAlignedBB>> cache;

    public StatusProperties(String name) {
        this(name, null, false);
    }

    public StatusProperties(String name, StatusProperties parent) {
        this(name, parent, false);
    }

    public StatusProperties(String name, StatusProperties parent, boolean builtin) {
        this.name = name;
        this.parent = parent;
        this.builtin = builtin;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setParent(StatusProperties parent) {
        this.parent = parent;
    }

    public StatusProperties getParent() {
        return this.parent;
    }

    public IRenderer getRenderer() {
        return this.renderer == null ? (this.parent == null ? null : this.parent.getRenderer()) : this.renderer.get();
    }

    public int getLightEmissive() {
        return this.lightEmissive == null ? (this.parent == null ? 0 : this.parent.getLightEmissive()) : this.lightEmissive;
    }

    public void setLightEmissive(Integer lightEmissive) {
        this.lightEmissive = lightEmissive;
    }

    public List<AxisAlignedBB> getShape() {
        return this.shape == null ? (this.parent == null ? Collections.singletonList(Block.field_185505_j) : this.parent.getShape()) : this.shape;
    }

    public List<AxisAlignedBB> getShape(EnumFacing direction) {
        List<AxisAlignedBB> shape;
        if (this.cache == null) {
            this.cache = new EnumMap<EnumFacing, List<AxisAlignedBB>>(EnumFacing.class);
        }
        if ((shape = this.getShape()).isEmpty() || shape.contains(Block.field_185505_j)) {
            return shape;
        }
        return this.cache.computeIfAbsent(direction, dir -> ShapeUtils.rotate(shape, dir));
    }

    public SoundState getSound() {
        return this.sound == null ? (this.parent == null ? SoundState.EMPTY : this.parent.getSound()) : this.sound;
    }

    public void setRenderer(Supplier<IRenderer> renderer) {
        this.renderer = renderer;
    }

    public void setLightEmissive(int lightEmissive) {
        this.lightEmissive = lightEmissive;
    }

    public void setShape(List<AxisAlignedBB> shape) {
        this.shape = shape;
        this.cache = null;
    }

    public void setSound(SoundState sound) {
        this.sound = sound;
    }

    public void setRenderer(IRenderer renderer) {
        this.renderer = () -> renderer;
    }

    public void fromJson(JsonObject json) {
        if (json.has("renderer")) {
            JsonElement jsonElement = json.get("renderer");
            if (IRendererTypeAdapterFactory.INSTANCE.isPostRenderer(jsonElement)) {
                this.setRenderer((Supplier<IRenderer>)Suppliers.memoize(() -> (IRenderer)Multiblocked.GSON.fromJson(jsonElement, IRenderer.class)));
            } else {
                this.setRenderer((IRenderer)Multiblocked.GSON.fromJson(jsonElement, IRenderer.class));
            }
        }
        if (json.has("lightEmissive")) {
            this.lightEmissive = json.get("lightEmissive").getAsInt();
        }
        if (json.has("shape")) {
            this.shape = new ArrayList<AxisAlignedBB>();
            JsonArray array = json.get("shape").getAsJsonArray();
            for (JsonElement element : array) {
                JsonArray a = element.getAsJsonArray();
                this.shape.add(new AxisAlignedBB((double)a.get(0).getAsFloat(), (double)a.get(1).getAsFloat(), (double)a.get(2).getAsFloat(), (double)a.get(3).getAsFloat(), (double)a.get(4).getAsFloat(), (double)a.get(5).getAsFloat()));
            }
        }
        if (json.has("sound")) {
            this.sound = (SoundState)Multiblocked.GSON.fromJson(json.get("sound"), SoundState.class);
            if (this.sound.sound.equals((Object)SoundState.EMPTY.sound)) {
                this.sound = SoundState.EMPTY;
            } else {
                this.sound.status = this.name;
            }
        }
    }

    public JsonObject toJson(JsonObject json) {
        if (this.renderer != null) {
            json.add("renderer", Multiblocked.GSON.toJsonTree((Object)this.renderer.get()));
        }
        if (this.lightEmissive != null) {
            json.addProperty("lightEmissive", (Number)this.lightEmissive);
        }
        if (this.shape != null) {
            JsonArray array = new JsonArray();
            for (AxisAlignedBB aabb : this.shape) {
                JsonArray a = new JsonArray();
                a.add((Number)aabb.field_72340_a);
                a.add((Number)aabb.field_72338_b);
                a.add((Number)aabb.field_72339_c);
                a.add((Number)aabb.field_72336_d);
                a.add((Number)aabb.field_72337_e);
                a.add((Number)aabb.field_72334_f);
                array.add((JsonElement)a);
            }
            json.add("shape", (JsonElement)array);
        }
        if (this.parent != null) {
            json.addProperty("parent", this.parent.name);
        }
        if (this.sound != null) {
            json.add("sound", Multiblocked.GSON.toJsonTree((Object)this.sound));
        }
        return json;
    }
}

