/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.definition;

import com.cleanroommc.multiblocked.Multiblocked;
import com.cleanroommc.multiblocked.api.crafttweaker.functions.IApplyContentModifier;
import com.cleanroommc.multiblocked.api.crafttweaker.functions.ICalcRecipeDuration;
import com.cleanroommc.multiblocked.api.crafttweaker.functions.IDynamicPattern;
import com.cleanroommc.multiblocked.api.crafttweaker.functions.IRecipeFinish;
import com.cleanroommc.multiblocked.api.crafttweaker.functions.ISetupRecipe;
import com.cleanroommc.multiblocked.api.crafttweaker.functions.IStructureFormed;
import com.cleanroommc.multiblocked.api.crafttweaker.functions.IStructureInvalid;
import com.cleanroommc.multiblocked.api.crafttweaker.functions.IUpdateFormed;
import com.cleanroommc.multiblocked.api.definition.ComponentDefinition;
import com.cleanroommc.multiblocked.api.pattern.BlockPattern;
import com.cleanroommc.multiblocked.api.pattern.JsonBlockPattern;
import com.cleanroommc.multiblocked.api.pattern.MultiblockShapeInfo;
import com.cleanroommc.multiblocked.api.recipe.RecipeMap;
import com.cleanroommc.multiblocked.api.tile.ControllerTileEntity;
import com.cleanroommc.multiblocked.util.JsonUtil;
import com.google.common.base.Suppliers;
import com.google.gson.JsonObject;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.mc1120.item.MCItemStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenProperty;
import stanhebben.zenscript.annotations.ZenSetter;

@ZenClass(value="mods.multiblocked.definition.ControllerDefinition")
@ZenRegister
public class ControllerDefinition
extends ComponentDefinition {
    protected Supplier<BlockPattern> basePattern;
    protected Supplier<RecipeMap> recipeMap;
    protected Supplier<ItemStack> catalyst;
    @ZenProperty
    public IDynamicPattern dynamicPattern;
    @ZenProperty
    public IStructureFormed structureFormed;
    @ZenProperty
    public IStructureInvalid structureInvalid;
    @ZenProperty
    public IUpdateFormed updateFormed;
    @ZenProperty
    public ISetupRecipe setupRecipe;
    @ZenProperty
    public IRecipeFinish recipeFinish;
    @ZenProperty
    public IApplyContentModifier applyContentModifier;
    @ZenProperty
    public ICalcRecipeDuration calcRecipeDuration;
    @ZenProperty
    public CatalystState consumeCatalyst = CatalystState.NOT_CONSUMED;
    public boolean noNeedController;
    @ZenProperty
    public List<MultiblockShapeInfo> designs;

    public ControllerDefinition() {
        this((ResourceLocation)null, (Class<? extends ControllerTileEntity>)ControllerTileEntity.class);
    }

    public ControllerDefinition(ResourceLocation location) {
        this(location, (Class<? extends ControllerTileEntity>)ControllerTileEntity.class);
    }

    public ControllerDefinition(ResourceLocation location, Class<? extends ControllerTileEntity> clazz) {
        super(location, clazz);
        this.recipeMap = () -> RecipeMap.EMPTY;
    }

    public List<MultiblockShapeInfo> getDesigns() {
        if (this.designs != null) {
            return this.designs;
        }
        if (this.getBasePattern() != null) {
            return this.autoGenDFS(this.getBasePattern(), new ArrayList<MultiblockShapeInfo>(), new Stack<Integer>());
        }
        if (this.dynamicPattern != null) {
            try {
                return this.autoGenDFS(this.dynamicPattern.apply((ControllerTileEntity)this.createNewTileEntity(null)), new ArrayList<MultiblockShapeInfo>(), new Stack<Integer>());
            }
            catch (Exception exception) {
                this.dynamicPattern = null;
                Multiblocked.LOGGER.error("definition {} custom logic {} error", (Object)this.location, (Object)"dynamicPattern", (Object)exception);
            }
        }
        return Collections.emptyList();
    }

    private List<MultiblockShapeInfo> autoGenDFS(BlockPattern structurePattern, List<MultiblockShapeInfo> pages, Stack<Integer> repetitionStack) {
        int[][] aisleRepetitions = structurePattern.aisleRepetitions;
        if (repetitionStack.size() == aisleRepetitions.length) {
            int[] repetition = new int[repetitionStack.size()];
            for (int i = 0; i < repetitionStack.size(); ++i) {
                repetition[i] = (Integer)repetitionStack.get(i);
            }
            pages.add(new MultiblockShapeInfo(structurePattern.getPreview(repetition)));
        } else {
            for (int i = aisleRepetitions[repetitionStack.size()][0]; i <= aisleRepetitions[repetitionStack.size()][1]; ++i) {
                repetitionStack.push(i);
                this.autoGenDFS(structurePattern, pages, repetitionStack);
                repetitionStack.pop();
            }
        }
        return pages;
    }

    @Optional.Method(modid="crafttweaker")
    @ZenGetter(value="catalyst")
    public IItemStack getCatalystCT() {
        return this.catalyst == null ? null : new MCItemStack(this.catalyst.get());
    }

    @Optional.Method(modid="crafttweaker")
    @ZenSetter(value="catalyst")
    public void setCatalystCT(IItemStack catalyst) {
        this.setCatalyst(catalyst == null ? null : CraftTweakerMC.getItemStack((IItemStack)catalyst));
    }

    public String getDescription() {
        return this.location.func_110624_b() + "." + this.location.func_110623_a() + ".description";
    }

    @Override
    public boolean needUpdateTick() {
        return super.needUpdateTick() || this.catalyst == null;
    }

    @ZenGetter(value="basePattern")
    public BlockPattern getBasePattern() {
        return this.basePattern == null ? null : this.basePattern.get();
    }

    @ZenGetter(value="recipeMap")
    public RecipeMap getRecipeMap() {
        return this.recipeMap == null ? null : this.recipeMap.get();
    }

    public ItemStack getCatalyst() {
        return this.catalyst == null ? null : this.catalyst.get();
    }

    @ZenSetter(value="basePattern")
    public void setBasePattern(BlockPattern basePattern) {
        this.basePattern = () -> basePattern;
    }

    public void setBasePattern(Supplier<BlockPattern> basePattern) {
        this.basePattern = basePattern;
    }

    @ZenSetter(value="recipeMap")
    public void setRecipeMap(RecipeMap recipeMap) {
        this.recipeMap = () -> recipeMap;
    }

    public void setRecipeMap(Supplier<RecipeMap> recipeMap) {
        this.recipeMap = recipeMap;
    }

    public void setDesigns(List<MultiblockShapeInfo> designs) {
        this.designs = designs;
    }

    public void setCatalyst(Supplier<ItemStack> catalyst) {
        this.catalyst = catalyst;
    }

    public void setCatalyst(ItemStack catalyst) {
        this.catalyst = () -> catalyst;
    }

    @Override
    public void fromJson(JsonObject json) {
        super.fromJson(json);
        int version = JsonUtils.func_151208_a((JsonObject)json, (String)"version", (int)0);
        if (json.has("basePattern")) {
            this.basePattern = Suppliers.memoize(() -> ((JsonBlockPattern)Multiblocked.GSON.fromJson(json.get("basePattern"), JsonBlockPattern.class)).build());
        }
        if (json.has("recipeMap")) {
            this.recipeMap = Suppliers.memoize(() -> RecipeMap.RECIPE_MAP_REGISTRY.getOrDefault(json.get("recipeMap").getAsString(), RecipeMap.EMPTY));
        } else {
            this.setRecipeMap(RecipeMap.EMPTY);
        }
        if (json.has("catalyst")) {
            this.catalyst = Suppliers.memoize(() -> (ItemStack)Multiblocked.GSON.fromJson(json.get("catalyst"), ItemStack.class));
            this.consumeCatalyst = version > 1 ? JsonUtil.getEnumOr(json, "consumeCatalyst", CatalystState.class, this.consumeCatalyst) : (JsonUtils.func_151209_a((JsonObject)json, (String)"consumeCatalyst", (boolean)false) ? CatalystState.CONSUMED : CatalystState.NOT_CONSUMED);
            this.noNeedController = JsonUtils.func_151209_a((JsonObject)json, (String)"noNeedController", (boolean)this.noNeedController);
        }
    }

    @Override
    public JsonObject toJson(JsonObject json) {
        json = super.toJson(json);
        if (this.getRecipeMap() != null) {
            json.addProperty("recipeMap", this.getRecipeMap().name);
        }
        if (this.getCatalyst() != null) {
            json.add("catalyst", Multiblocked.GSON.toJsonTree((Object)this.getCatalyst()));
            json.addProperty("consumeCatalyst", this.consumeCatalyst.name());
            json.addProperty("noNeedController", Boolean.valueOf(this.noNeedController));
        }
        return json;
    }

    @ZenClass(value="mods.multiblocked.definition.CatalystState")
    @ZenRegister
    public static enum CatalystState implements Predicate<ItemStack>
    {
        NOT_CONSUMED(itemStack -> true),
        CONSUMED(itemStack -> {
            if (itemStack.func_190916_E() > 0) {
                itemStack.func_190918_g(1);
                return true;
            }
            return false;
        }),
        CONSUME_DURABILITY(itemStack -> {
            if (itemStack.func_77984_f() && itemStack.func_77952_i() < itemStack.func_77958_k()) {
                itemStack.func_77964_b(itemStack.func_77952_i() + 1);
                return true;
            }
            return itemStack.func_77952_i() < itemStack.func_77958_k();
        });

        final Function<ItemStack, Boolean> predicate;

        private CatalystState(Function<ItemStack, Boolean> predicate) {
            this.predicate = predicate;
        }

        @Override
        public boolean test(ItemStack itemStack) {
            return this.predicate.apply(itemStack);
        }
    }
}

