/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.definition;

import com.cleanroommc.multiblocked.Multiblocked;
import com.cleanroommc.multiblocked.api.block.CustomProperties;
import com.cleanroommc.multiblocked.api.crafttweaker.functions.IDrops;
import com.cleanroommc.multiblocked.api.crafttweaker.functions.IDynamicRenderer;
import com.cleanroommc.multiblocked.api.crafttweaker.functions.IGetOutputRedstoneSignal;
import com.cleanroommc.multiblocked.api.crafttweaker.functions.ILeftClick;
import com.cleanroommc.multiblocked.api.crafttweaker.functions.INeighborChanged;
import com.cleanroommc.multiblocked.api.crafttweaker.functions.IReadInitialData;
import com.cleanroommc.multiblocked.api.crafttweaker.functions.IReceiveCustomData;
import com.cleanroommc.multiblocked.api.crafttweaker.functions.IRightClick;
import com.cleanroommc.multiblocked.api.crafttweaker.functions.IShouldCheckPattern;
import com.cleanroommc.multiblocked.api.crafttweaker.functions.IStatusChanged;
import com.cleanroommc.multiblocked.api.crafttweaker.functions.IUpdateTick;
import com.cleanroommc.multiblocked.api.crafttweaker.functions.IWriteInitialData;
import com.cleanroommc.multiblocked.api.definition.StatusProperties;
import com.cleanroommc.multiblocked.api.json.IRendererTypeAdapterFactory;
import com.cleanroommc.multiblocked.api.registry.MbdComponents;
import com.cleanroommc.multiblocked.api.tile.ComponentTileEntity;
import com.cleanroommc.multiblocked.client.renderer.IRenderer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.mc1120.item.MCItemStack;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;
import stanhebben.zenscript.annotations.ZenProperty;

@ZenClass(value="mods.multiblocked.definition.ComponentDefinition")
@ZenRegister
public class ComponentDefinition {
    public final ResourceLocation location;
    public Class<? extends ComponentTileEntity<?>> clazz;
    public JsonObject traits;
    public final Map<String, StatusProperties> status;
    @ZenProperty
    public CustomProperties properties;
    @ZenProperty
    public IDynamicRenderer dynamicRenderer;
    @ZenProperty
    public IDrops onDrops;
    @ZenProperty
    public ILeftClick onLeftClick;
    @ZenProperty
    public IRightClick onRightClick;
    @ZenProperty
    public INeighborChanged onNeighborChanged;
    @ZenProperty
    public IGetOutputRedstoneSignal getOutputRedstoneSignal;
    @ZenProperty
    public IUpdateTick updateTick;
    @ZenProperty
    public IStatusChanged statusChanged;
    @ZenProperty
    public IShouldCheckPattern shouldCheckPattern;
    @ZenProperty
    public IReceiveCustomData receiveCustomData;
    @ZenProperty
    public IWriteInitialData writeInitialData;
    @ZenProperty
    public IReadInitialData readInitialData;
    public static final int VERSION = 2;

    public ComponentDefinition(ResourceLocation location, Class<? extends ComponentTileEntity<?>> clazz) {
        this.location = location;
        this.clazz = clazz;
        this.status = new LinkedHashMap<String, StatusProperties>();
        this.status.put("unformed", new StatusProperties("unformed", null, true));
        this.status.put("idle", new StatusProperties("idle", this.getBaseStatus(), true));
        this.status.put("working", new StatusProperties("working", this.getIdleStatus(), true));
        this.status.put("suspend", new StatusProperties("suspend", this.getWorkingStatus(), true));
        this.traits = new JsonObject();
        this.properties = new CustomProperties();
    }

    public ComponentTileEntity<?> createNewTileEntity(World world) {
        try {
            ComponentTileEntity<?> component = this.clazz.newInstance();
            component.func_145834_a(world);
            component.setDefinition(this);
            return component;
        }
        catch (IllegalAccessException | InstantiationException e) {
            Multiblocked.LOGGER.error((Object)e);
            return null;
        }
    }

    public StatusProperties getStatus(String status) {
        return this.status.containsKey(status) ? this.status.get(status) : this.status.getOrDefault("unformed", StatusProperties.EMPTY);
    }

    public StatusProperties getBaseStatus() {
        return this.getStatus("unformed");
    }

    public StatusProperties getIdleStatus() {
        return this.getStatus("idle");
    }

    public StatusProperties getWorkingStatus() {
        return this.getStatus("working");
    }

    public StatusProperties getSuspendStatus() {
        return this.getStatus("suspend");
    }

    public IRenderer getRenderer() {
        return this.getBaseStatus().getRenderer();
    }

    @ZenMethod(value="getLocation")
    @ZenGetter(value="location")
    public String toString() {
        return this.location.toString();
    }

    public ItemStack getStackForm() {
        return new ItemStack((Item)MbdComponents.COMPONENT_ITEMS_REGISTRY.get((Object)this.location), 1);
    }

    @Optional.Method(modid="crafttweaker")
    @ZenMethod(value="getStackForm")
    public IItemStack stackForm() {
        return new MCItemStack(this.getStackForm());
    }

    public boolean needUpdateTick() {
        return this.updateTick != null;
    }

    public void setTileEntityClass(Class<?> clazz) {
        if (ComponentTileEntity.class.isAssignableFrom(clazz)) {
            this.clazz = clazz;
        }
    }

    public void fromJson(JsonObject json) {
        int version = JsonUtils.func_151208_a((JsonObject)json, (String)"version", (int)0);
        if (version > 2) {
            throw new IllegalArgumentException(String.format("using outdated version of mbd. script is {%d}, mbd supports {%d}", version, 2));
        }
        if (json.has("traits")) {
            this.traits = json.get("traits").getAsJsonObject();
        }
        if (json.has("properties")) {
            this.properties = (CustomProperties)Multiblocked.GSON.fromJson(json.get("properties"), CustomProperties.class);
        }
        if (version > 0) {
            JsonObject statusJson = json.get("status").getAsJsonObject();
            this.getBaseStatus().fromJson(statusJson.get("unformed").getAsJsonObject());
            this.getIdleStatus().fromJson(statusJson.get("idle").getAsJsonObject());
            this.getWorkingStatus().fromJson(statusJson.get("working").getAsJsonObject());
            this.getSuspendStatus().fromJson(statusJson.get("suspend").getAsJsonObject());
            for (Map.Entry entry : statusJson.entrySet()) {
                this.parseStatus((String)entry.getKey(), statusJson);
            }
        } else {
            JsonElement renderer;
            this.properties.rotationState = JsonUtils.func_151209_a((JsonObject)json, (String)"allowRotate", (boolean)true) ? CustomProperties.RotationState.ALL : CustomProperties.RotationState.NONE;
            this.properties.showInJei = JsonUtils.func_151209_a((JsonObject)json, (String)"showInJei", (boolean)this.properties.showInJei);
            this.properties.isOpaque = JsonUtils.func_151209_a((JsonObject)json, (String)"isOpaqueCube", (boolean)this.properties.isOpaque);
            if (json.has("baseRenderer")) {
                renderer = json.get("baseRenderer");
                if (IRendererTypeAdapterFactory.INSTANCE.isPostRenderer(renderer)) {
                    this.getBaseStatus().setRenderer(() -> (IRenderer)Multiblocked.GSON.fromJson(renderer, IRenderer.class));
                } else {
                    this.getBaseStatus().setRenderer((IRenderer)Multiblocked.GSON.fromJson(renderer, IRenderer.class));
                }
            }
            if (json.has("formedRenderer")) {
                renderer = json.get("formedRenderer");
                if (IRendererTypeAdapterFactory.INSTANCE.isPostRenderer(renderer)) {
                    this.getIdleStatus().setRenderer(() -> (IRenderer)Multiblocked.GSON.fromJson(renderer, IRenderer.class));
                } else {
                    this.getIdleStatus().setRenderer((IRenderer)Multiblocked.GSON.fromJson(renderer, IRenderer.class));
                }
            }
            if (json.has("workingRenderer")) {
                renderer = json.get("workingRenderer");
                if (IRendererTypeAdapterFactory.INSTANCE.isPostRenderer(renderer)) {
                    this.getWorkingStatus().setRenderer(() -> (IRenderer)Multiblocked.GSON.fromJson(renderer, IRenderer.class));
                } else {
                    this.getWorkingStatus().setRenderer((IRenderer)Multiblocked.GSON.fromJson(renderer, IRenderer.class));
                }
            }
        }
    }

    private StatusProperties parseStatus(String name, JsonObject json) {
        if (this.status.containsKey(name)) {
            return this.status.get(name);
        }
        StatusProperties parent = null;
        JsonObject statusJson = json.get(name).getAsJsonObject();
        if (statusJson.has("parent")) {
            String parentName = statusJson.get("parent").getAsString();
            parent = json.has(parentName) ? this.parseStatus(parentName, json) : null;
        }
        StatusProperties result = new StatusProperties(name, parent);
        result.fromJson(statusJson);
        this.status.put(name, result);
        return result;
    }

    public JsonObject toJson(JsonObject json) {
        json.addProperty("version", (Number)2);
        json.addProperty("location", this.location.toString());
        json.add("traits", (JsonElement)this.traits);
        json.add("properties", Multiblocked.GSON.toJsonTree((Object)this.properties));
        JsonObject statusJson = new JsonObject();
        this.status.forEach((name, status) -> statusJson.add(name, (JsonElement)status.toJson(new JsonObject())));
        json.add("status", (JsonElement)statusJson);
        return json;
    }
}

