/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.crafttweaker.interfaces;

import com.cleanroommc.multiblocked.api.definition.ComponentDefinition;
import com.cleanroommc.multiblocked.api.tile.ComponentTileEntity;
import com.cleanroommc.multiblocked.client.renderer.IRenderer;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.data.IData;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.player.IPlayer;
import crafttweaker.api.world.IBlockPos;
import crafttweaker.api.world.IFacing;
import crafttweaker.api.world.IWorld;
import crafttweaker.mc1120.player.MCPlayer;
import crafttweaker.mc1120.world.MCBlockPos;
import crafttweaker.mc1120.world.MCFacing;
import crafttweaker.mc1120.world.MCWorld;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;
import stanhebben.zenscript.annotations.ZenSetter;

@ZenClass(value="mods.multiblocked.tile.Component")
@ZenRegister
public interface ICTComponent {
    public ComponentTileEntity<?> getInner();

    @ZenGetter(value="definition")
    default public ComponentDefinition getDefinition() {
        return this.getInner().getDefinition();
    }

    @ZenGetter
    default public IWorld world() {
        World world = this.getInner().func_145831_w();
        return world == null ? null : new MCWorld(world);
    }

    @ZenGetter
    default public IBlockPos pos() {
        BlockPos pos = this.getInner().func_174877_v();
        return pos == null ? null : new MCBlockPos(pos);
    }

    @ZenGetter
    default public IPlayer player() {
        EntityPlayer player = this.getInner().getOwner();
        return player == null ? null : new MCPlayer(player);
    }

    @ZenGetter
    default public String playerUUID() {
        UUID player = this.getInner().getOwnerUUID();
        return player == null ? "" : player.toString();
    }

    @ZenGetter
    default public boolean isRemote() {
        return this.getInner().isRemote();
    }

    @ZenMethod
    default public String getUnlocalizedName() {
        return this.getInner().getUnlocalizedName();
    }

    @SideOnly(value=Side.CLIENT)
    @ZenMethod
    default public String getLocalizedName() {
        return this.getInner().getLocalizedName();
    }

    @ZenMethod
    @ZenGetter
    default public boolean isFormed() {
        return this.getInner().isFormed();
    }

    @ZenMethod
    @ZenGetter(value="timer")
    default public int getTimer() {
        return this.getInner().getTimer();
    }

    @ZenMethod
    default public void update() {
        this.getInner().update();
    }

    @ZenGetter(value="status")
    default public String getStatus() {
        return this.getInner().getStatus();
    }

    @ZenSetter(value="status")
    default public void setStatus(String status) {
        this.getInner().setStatus(status);
    }

    @ZenGetter
    default public IFacing frontFacing() {
        return new MCFacing(this.getInner().getFrontFacing());
    }

    @ZenSetter
    default public void frontFacing(IFacing facing) {
        this.getInner().setFrontFacing(CraftTweakerMC.getFacing((IFacing)facing));
    }

    @ZenMethod
    @ZenGetter(value="renderer")
    default public IRenderer getRenderer() {
        return this.getInner().getRenderer();
    }

    @ZenMethod
    default public boolean isFrontFacingValid(IFacing facing) {
        return this.getInner().isValidFrontFacing(CraftTweakerMC.getFacing((IFacing)facing));
    }

    @ZenMethod
    default public void scheduleChunkForRenderUpdate() {
        this.getInner().scheduleChunkForRenderUpdate();
    }

    @ZenMethod
    default public void notifyBlockUpdate() {
        this.getInner().notifyBlockUpdate();
    }

    @ZenMethod
    default public void markAsDirty() {
        this.getInner().markAsDirty();
    }

    @ZenMethod
    @ZenSetter(value="extraData")
    default public void setExtraData(IData data) {
        this.getInner().persistentData = data;
    }

    @ZenMethod
    @ZenGetter(value="extraData")
    default public IData getExtraData() {
        return (IData)this.getInner().persistentData;
    }

    @ZenMethod
    default public void sendCustomData(int id, IData data) {
        this.getInner().writeCustomData(2, packetBuffer -> {
            packetBuffer.func_150787_b(id);
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74782_a("data", CraftTweakerMC.getNBT((IData)data));
            packetBuffer.func_150786_a(tag);
        });
    }
}

