/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.crafttweaker.expanders;

import com.cleanroommc.multiblocked.api.recipe.EntityIngredient;
import com.cleanroommc.multiblocked.api.recipe.ItemsIngredient;
import com.cleanroommc.multiblocked.api.recipe.RecipeBuilder;
import com.cleanroommc.multiblocked.common.recipe.content.AspectStack;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.data.IData;
import crafttweaker.api.entity.IEntityDefinition;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.Arrays;
import lach_01298.qmd.crafttweaker.QMDCTHelper;
import lach_01298.qmd.crafttweaker.particle.IParticleStack;
import lach_01298.qmd.particle.ParticleStack;
import mekanism.api.gas.GasStack;
import mekanism.common.integration.crafttweaker.gas.IGasStack;
import mekanism.common.integration.crafttweaker.helpers.GasHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.registry.EntityEntry;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenExpansion;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenExpansion(value="mods.multiblocked.recipe.RecipeBuilder")
public class ExpandRecipeBuilder {
    @ZenMethod
    public static RecipeBuilder inputItems(RecipeBuilder builder, IIngredient ... inputs) {
        return ExpandRecipeBuilder.inputItems(builder, 1.0f, inputs);
    }

    @ZenMethod
    public static RecipeBuilder outputItems(RecipeBuilder builder, IItemStack ... outputs) {
        return ExpandRecipeBuilder.outputItems(builder, 1.0f, outputs);
    }

    @ZenMethod
    public static RecipeBuilder inputItems(RecipeBuilder builder, float chance, IIngredient ... inputs) {
        return builder.inputItems(chance, (ItemsIngredient[])Arrays.stream(inputs).map(in -> new ItemsIngredient(in.getAmount(), CraftTweakerMC.getIngredient((IIngredient)in).func_193365_a())).toArray(ItemsIngredient[]::new));
    }

    @ZenMethod
    public static RecipeBuilder outputItems(RecipeBuilder builder, float chance, IItemStack ... outputs) {
        return builder.outputItems(chance, (ItemStack[])Arrays.stream(outputs).map(CraftTweakerMC::getItemStack).toArray(ItemStack[]::new));
    }

    @ZenMethod
    public static RecipeBuilder inputFluids(RecipeBuilder builder, ILiquidStack ... inputs) {
        return ExpandRecipeBuilder.inputFluids(builder, 1.0f, inputs);
    }

    @ZenMethod
    public static RecipeBuilder outputFluids(RecipeBuilder builder, ILiquidStack ... outputs) {
        return ExpandRecipeBuilder.outputFluids(builder, 1.0f, outputs);
    }

    @ZenMethod
    public static RecipeBuilder inputFluids(RecipeBuilder builder, float chance, ILiquidStack ... inputs) {
        return builder.inputFluids(chance, (FluidStack[])Arrays.stream(inputs).map(CraftTweakerMC::getLiquidStack).toArray(FluidStack[]::new));
    }

    @ZenMethod
    public static RecipeBuilder outputFluids(RecipeBuilder builder, float chance, ILiquidStack ... outputs) {
        return builder.outputFluids(chance, (FluidStack[])Arrays.stream(outputs).map(CraftTweakerMC::getLiquidStack).toArray(FluidStack[]::new));
    }

    @ZenMethod
    public static RecipeBuilder inputEntity(RecipeBuilder builder, float chance, IEntityDefinition entity, @Optional IData data) {
        NBTTagCompound nbt = (NBTTagCompound)CraftTweakerMC.getNBT((IData)data);
        return builder.inputEntities(chance, new EntityIngredient((EntityEntry)entity.getInternal(), nbt));
    }

    @ZenMethod
    public static RecipeBuilder inputEntity(RecipeBuilder builder, IEntityDefinition entity, @Optional IData data) {
        return ExpandRecipeBuilder.inputEntity(builder, 1.0f, entity, data);
    }

    @ZenMethod
    public static RecipeBuilder outputEntity(RecipeBuilder builder, float chance, IEntityDefinition entity, @Optional IData data) {
        NBTTagCompound nbt = (NBTTagCompound)CraftTweakerMC.getNBT((IData)data);
        return builder.outputEntities(chance, new EntityIngredient((EntityEntry)entity.getInternal(), nbt));
    }

    @ZenMethod
    public static RecipeBuilder outputEntity(RecipeBuilder builder, IEntityDefinition entity, @Optional IData data) {
        return ExpandRecipeBuilder.outputEntity(builder, 1.0f, entity, data);
    }

    @ZenMethod
    @Optional.Method(modid="thaumcraft")
    public static RecipeBuilder inputAspects(RecipeBuilder builder, AspectStack ... inputs) {
        return ExpandRecipeBuilder.inputAspects(builder, 1.0f, inputs);
    }

    @ZenMethod
    @Optional.Method(modid="thaumcraft")
    public static RecipeBuilder outputAspects(RecipeBuilder builder, AspectStack ... outputs) {
        return ExpandRecipeBuilder.outputAspects(builder, 1.0f, outputs);
    }

    @ZenMethod
    @Optional.Method(modid="thaumcraft")
    public static RecipeBuilder inputAspects(RecipeBuilder builder, float chance, AspectStack ... inputs) {
        return builder.inputAspects(chance, inputs);
    }

    @ZenMethod
    @Optional.Method(modid="thaumcraft")
    public static RecipeBuilder outputAspects(RecipeBuilder builder, float chance, AspectStack ... outputs) {
        return builder.outputAspects(chance, outputs);
    }

    @ModOnly(value="qmd")
    @ZenRegister
    @ZenExpansion(value="mods.multiblocked.recipe.RecipeBuilder")
    public static class Particle {
        @ZenMethod
        @Optional.Method(modid="qmd")
        public static RecipeBuilder inputParticles(RecipeBuilder builder, IParticleStack ... inputs) {
            return Particle.inputParticles(builder, 1.0f, inputs);
        }

        @ZenMethod
        @Optional.Method(modid="qmd")
        public static RecipeBuilder outputParticles(RecipeBuilder builder, IParticleStack ... outputs) {
            return Particle.outputParticles(builder, 1.0f, outputs);
        }

        @ZenMethod
        @Optional.Method(modid="qmd")
        public static RecipeBuilder inputParticles(RecipeBuilder builder, float chance, IParticleStack ... inputs) {
            return builder.inputParticles(chance, (ParticleStack[])Arrays.stream(inputs).map(QMDCTHelper::getParticleStack).toArray(ParticleStack[]::new));
        }

        @ZenMethod
        @Optional.Method(modid="qmd")
        public static RecipeBuilder outputParticles(RecipeBuilder builder, float chance, IParticleStack ... outputs) {
            return builder.outputParticles(chance, (ParticleStack[])Arrays.stream(outputs).map(QMDCTHelper::getParticleStack).toArray(ParticleStack[]::new));
        }
    }

    @ModOnly(value="mekanism")
    @ZenRegister
    @ZenExpansion(value="mods.multiblocked.recipe.RecipeBuilder")
    public static class Gas {
        @ZenMethod
        @Optional.Method(modid="mekanism")
        public static RecipeBuilder inputGas(RecipeBuilder builder, IGasStack ... inputs) {
            return Gas.inputGas(builder, 1.0f, inputs);
        }

        @ZenMethod
        @Optional.Method(modid="mekanism")
        public static RecipeBuilder outputGas(RecipeBuilder builder, IGasStack ... outputs) {
            return Gas.outputGas(builder, 1.0f, outputs);
        }

        @ZenMethod
        @Optional.Method(modid="mekanism")
        public static RecipeBuilder inputGas(RecipeBuilder builder, float chance, IGasStack ... inputs) {
            return builder.inputGas(chance, (GasStack[])Arrays.stream(inputs).map(GasHelper::toGas).toArray(GasStack[]::new));
        }

        @ZenMethod
        @Optional.Method(modid="mekanism")
        public static RecipeBuilder outputGas(RecipeBuilder builder, float chance, IGasStack ... outputs) {
            return builder.outputGas(chance, (GasStack[])Arrays.stream(outputs).map(GasHelper::toGas).toArray(GasStack[]::new));
        }
    }
}

