/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.crafttweaker.expanders;

import com.cleanroommc.multiblocked.api.pattern.Predicates;
import com.cleanroommc.multiblocked.api.pattern.TraceabilityPredicate;
import com.cleanroommc.multiblocked.api.pattern.util.BlockInfo;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.block.IBlock;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidDefinition;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import stanhebben.zenscript.annotations.ZenExpansion;
import stanhebben.zenscript.annotations.ZenMethodStatic;

@ZenExpansion(value="mods.multiblocked.pattern.CTPredicate")
@ZenRegister
public class ExpandPredicate {
    @ZenMethodStatic
    public static TraceabilityPredicate getAny() {
        return Predicates.any();
    }

    @ZenMethodStatic
    public static TraceabilityPredicate getAir() {
        return Predicates.air();
    }

    private static Supplier<BlockInfo[]> getCandidates(Set<IBlockState> allowedStates) {
        return () -> (BlockInfo[])allowedStates.stream().map(BlockInfo::fromBlockState).toArray(BlockInfo[]::new);
    }

    @ZenMethodStatic
    public static TraceabilityPredicate states(crafttweaker.api.block.IBlockState ... allowedStates) {
        return Predicates.states((IBlockState[])Arrays.stream(allowedStates).map(CraftTweakerMC::getBlockState).toArray(IBlockState[]::new));
    }

    @ZenMethodStatic
    public static TraceabilityPredicate blocks(IBlock ... blocks) {
        return Predicates.blocks((Block[])Arrays.stream(blocks).map(CraftTweakerMC::getBlock).toArray(Block[]::new));
    }

    @ZenMethodStatic
    public static TraceabilityPredicate items(IItemStack ... itemStacks) {
        return ExpandPredicate.blocks((IBlock[])Arrays.stream(itemStacks).map(IItemStack::asBlock).toArray(IBlock[]::new));
    }

    @ZenMethodStatic
    public static TraceabilityPredicate liquids(ILiquidStack ... liquidStacks) {
        return ExpandPredicate.blocks((IBlock[])Arrays.stream(liquidStacks).map(ILiquidStack::getDefinition).map(ILiquidDefinition::getBlock).toArray(IBlock[]::new));
    }
}

