/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.capability.trait;

import com.cleanroommc.multiblocked.api.capability.IO;
import com.cleanroommc.multiblocked.api.capability.MultiblockCapability;
import com.cleanroommc.multiblocked.api.capability.trait.CapabilityTrait;
import com.cleanroommc.multiblocked.api.gui.texture.ColorBorderTexture;
import com.cleanroommc.multiblocked.api.gui.texture.ColorRectTexture;
import com.cleanroommc.multiblocked.api.gui.texture.GuiTextureGroup;
import com.cleanroommc.multiblocked.api.gui.texture.ResourceBorderTexture;
import com.cleanroommc.multiblocked.api.gui.texture.ResourceTexture;
import com.cleanroommc.multiblocked.api.gui.widget.WidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.ButtonWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.DialogWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.DraggableScrollableWidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.DraggableWidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.ImageWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.SelectorWidget;
import com.cleanroommc.multiblocked.util.JsonUtil;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.util.JsonUtils;

public abstract class SingleCapabilityTrait
extends CapabilityTrait {
    protected IO capabilityIO;
    protected IO guiIO;
    protected int x;
    protected int y;

    public SingleCapabilityTrait(MultiblockCapability<?> capability) {
        super(capability);
    }

    @Override
    public void serialize(@Nullable JsonElement jsonElement) {
        if (jsonElement == null) {
            jsonElement = new JsonObject();
        }
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        this.capabilityIO = JsonUtil.getEnumOr(jsonObject, "cIO", IO.class, IO.BOTH);
        this.guiIO = JsonUtil.getEnumOr(jsonObject, "gIO", IO.class, IO.BOTH);
        this.x = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"x", (int)5);
        this.y = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"y", (int)5);
    }

    @Override
    public JsonElement deserialize() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("cIO", (Number)this.capabilityIO.ordinal());
        jsonObject.addProperty("gIO", (Number)this.guiIO.ordinal());
        jsonObject.addProperty("x", (Number)this.x);
        jsonObject.addProperty("y", (Number)this.y);
        return jsonObject;
    }

    protected int getColorByIO(IO io) {
        return io == IO.IN ? -1358889216 : (io == IO.OUT ? -1342242816 : -1358954241);
    }

    protected void refreshSlots(DraggableScrollableWidgetGroup dragGroup) {
        dragGroup.widgets.forEach(dragGroup::waitToRemoved);
        ButtonWidget setting = (ButtonWidget)new ButtonWidget(10, 0, 8, 8, new ResourceTexture("multiblocked:textures/gui/option.png"), null).setHoverBorderTexture(1, -1).setHoverTooltip("multiblocked.gui.tips.settings");
        ImageWidget imageWidget = new ImageWidget(1, 1, 16, 16, new GuiTextureGroup(new ColorRectTexture(this.getColorByIO(this.guiIO)), new ColorBorderTexture(1, this.getColorByIO(this.capabilityIO))));
        setting.setVisible(false);
        DraggableWidgetGroup slot = new DraggableWidgetGroup(this.x, this.y, 18, 18);
        slot.setOnSelected(w -> setting.setVisible(true));
        slot.setOnUnSelected(w -> setting.setVisible(false));
        slot.addWidget(imageWidget);
        slot.addWidget(setting);
        slot.setOnEndDrag(b -> {
            this.x = b.getSelfPosition().x;
            this.y = b.getSelfPosition().y;
        });
        dragGroup.addWidget(slot);
        setting.setOnPressCallback(cd2 -> {
            DialogWidget dialog = new DialogWidget(dragGroup, true);
            dialog.addWidget(new ImageWidget(0, 0, 176, 256, new ColorRectTexture(-1358954496)));
            this.initSettingDialog(dialog, slot);
        });
    }

    protected void initSettingDialog(DialogWidget dialog, DraggableWidgetGroup slot) {
        ImageWidget imageWidget = (ImageWidget)slot.widgets.get(0);
        dialog.addWidget(new SelectorWidget(5, 5, 40, 15, Arrays.stream(IO.VALUES).map(Enum::name).collect(Collectors.toList()), -1).setValue(this.capabilityIO.name()).setOnChanged(io -> {
            this.capabilityIO = IO.valueOf(io);
            imageWidget.setImage(new GuiTextureGroup(new ColorRectTexture(this.getColorByIO(this.guiIO)), new ColorBorderTexture(1, this.getColorByIO(this.capabilityIO))));
        }).setButtonBackground(ResourceBorderTexture.BUTTON_COMMON).setBackground(new ColorRectTexture(-5592406)).setHoverTooltip("multiblocked.gui.trait.capability_io"));
        dialog.addWidget(new SelectorWidget(50, 5, 40, 15, Arrays.stream(IO.VALUES).map(Enum::name).collect(Collectors.toList()), -1).setValue(this.guiIO.name()).setOnChanged(io -> {
            this.guiIO = IO.valueOf(io);
            imageWidget.setImage(new GuiTextureGroup(new ColorRectTexture(this.getColorByIO(this.guiIO)), new ColorBorderTexture(1, this.getColorByIO(this.capabilityIO))));
        }).setButtonBackground(ResourceBorderTexture.BUTTON_COMMON).setBackground(new ColorRectTexture(-5592406)).setHoverTooltip("multiblocked.gui.trait.gui_io"));
    }

    @Override
    public void openConfigurator(WidgetGroup parentDialog) {
        DraggableScrollableWidgetGroup dragGroup = new DraggableScrollableWidgetGroup(104, 0, 176, 256);
        parentDialog.addWidget(dragGroup);
        this.refreshSlots(dragGroup);
    }
}

