/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.capability.trait;

import com.cleanroommc.multiblocked.api.capability.IO;
import com.cleanroommc.multiblocked.api.capability.MultiblockCapability;
import com.cleanroommc.multiblocked.api.capability.trait.SingleCapabilityTrait;
import com.cleanroommc.multiblocked.api.gui.texture.ColorBorderTexture;
import com.cleanroommc.multiblocked.api.gui.texture.ColorRectTexture;
import com.cleanroommc.multiblocked.api.gui.texture.GuiTextureGroup;
import com.cleanroommc.multiblocked.api.gui.texture.ProgressTexture;
import com.cleanroommc.multiblocked.api.gui.texture.ResourceBorderTexture;
import com.cleanroommc.multiblocked.api.gui.texture.ResourceTexture;
import com.cleanroommc.multiblocked.api.gui.widget.WidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.ButtonWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.DialogWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.DraggableScrollableWidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.DraggableWidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.ImageWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.SelectorWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.TextFieldWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.blueprint_table.dialogs.ResourceTextureWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.recipe.ProgressWidget;
import com.cleanroommc.multiblocked.api.tile.ComponentTileEntity;
import com.cleanroommc.multiblocked.util.JsonUtil;
import com.cleanroommc.multiblocked.util.Position;
import com.cleanroommc.multiblocked.util.Size;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.JsonUtils;

public abstract class ProgressCapabilityTrait
extends SingleCapabilityTrait {
    protected int width;
    protected int height;
    protected String texture;
    protected ProgressTexture.FillDirection fillDirection;

    public ProgressCapabilityTrait(MultiblockCapability<?> capability) {
        super(capability);
    }

    @Override
    public void serialize(@Nullable JsonElement jsonElement) {
        super.serialize(jsonElement);
        if (jsonElement == null) {
            jsonElement = new JsonObject();
        }
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        this.width = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"width", (int)60);
        this.height = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"height", (int)18);
        this.texture = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"texture", (String)"multiblocked:textures/gui/energy_bar.png");
        this.fillDirection = JsonUtil.getEnumOr(jsonObject, "fillDirection", ProgressTexture.FillDirection.class, ProgressTexture.FillDirection.LEFT_TO_RIGHT);
    }

    @Override
    public JsonElement deserialize() {
        JsonObject jsonObject = super.deserialize().getAsJsonObject();
        jsonObject.addProperty("width", (Number)this.width);
        jsonObject.addProperty("height", (Number)this.height);
        jsonObject.addProperty("texture", this.texture);
        jsonObject.addProperty("fillDirection", (Number)this.fillDirection.ordinal());
        return jsonObject;
    }

    protected abstract String dynamicHoverTips(double var1);

    protected abstract double getProgress();

    @Override
    public void createUI(ComponentTileEntity<?> component, WidgetGroup group, EntityPlayer player) {
        super.createUI(component, group, player);
        group.addWidget(new ProgressWidget(this::getProgress, this.x, this.y, this.width, this.height, new ResourceTexture(this.texture)).setDynamicHoverTips(this::dynamicHoverTips).setFillDirection(this.fillDirection));
    }

    @Override
    protected void refreshSlots(DraggableScrollableWidgetGroup dragGroup) {
        dragGroup.widgets.forEach(dragGroup::waitToRemoved);
        ButtonWidget setting = (ButtonWidget)new ButtonWidget(this.width - 8, 0, 8, 8, new ResourceTexture("multiblocked:textures/gui/option.png"), null).setHoverBorderTexture(1, -1).setHoverTooltip("multiblocked.gui.tips.settings");
        ImageWidget imageWidget = new ImageWidget(0, 0, this.width, this.height, new GuiTextureGroup(this.createAutoProgressTexture(), new ColorBorderTexture(1, this.getColorByIO(this.capabilityIO))));
        setting.setVisible(false);
        DraggableWidgetGroup slot = new DraggableWidgetGroup(this.x, this.y, this.width, this.height);
        slot.setOnSelected(w -> setting.setVisible(true));
        slot.setOnUnSelected(w -> setting.setVisible(false));
        slot.addWidget(imageWidget);
        slot.addWidget(setting);
        slot.setOnEndDrag(b -> {
            this.x = b.getSelfPosition().x;
            this.y = b.getSelfPosition().y;
        });
        dragGroup.addWidget(slot);
        setting.setOnPressCallback(cd2 -> {
            DialogWidget dialog = new DialogWidget(dragGroup, true);
            dialog.addWidget(new ImageWidget(0, 0, 176, 256, new ColorRectTexture(-1358954496)));
            this.initSettingDialog(dialog, slot);
        });
    }

    @Override
    protected void initSettingDialog(DialogWidget dialog, DraggableWidgetGroup slot) {
        ImageWidget imageWidget = (ImageWidget)slot.widgets.get(0);
        ButtonWidget setting = (ButtonWidget)slot.widgets.get(1);
        ButtonWidget imageSelector = (ButtonWidget)new ButtonWidget(5, 85, this.width, this.height, new GuiTextureGroup(new ColorBorderTexture(1, -1), this.createAutoProgressTexture()), null).setHoverTooltip("multiblocked.gui.tips.select_image");
        dialog.addWidget(new TextFieldWidget(5, 25, 50, 15, true, null, s -> {
            this.width = Integer.parseInt(s);
            Size size = new Size(this.width, this.height);
            slot.setSize(size);
            imageWidget.setSize(size);
            imageSelector.setSize(size);
            setting.setSelfPosition(new Position(this.width - 8, 0));
        }).setCurrentString(this.width + "").setNumbersOnly(1, 180).setHoverTooltip("multiblocked.gui.trait.set_width"));
        dialog.addWidget(new TextFieldWidget(5, 45, 50, 15, true, null, s -> {
            this.height = Integer.parseInt(s);
            Size size = new Size(this.width, this.height);
            slot.setSize(size);
            imageWidget.setSize(size);
            imageSelector.setSize(size);
            setting.setSelfPosition(new Position(this.width - 8, 0));
        }).setCurrentString(this.height + "").setNumbersOnly(1, 180).setHoverTooltip("multiblocked.gui.trait.set_height"));
        dialog.addWidget(new SelectorWidget(5, 5, 50, 15, Arrays.stream(IO.VALUES).map(Enum::name).collect(Collectors.toList()), -1).setValue(this.capabilityIO.name()).setOnChanged(io -> {
            this.capabilityIO = IO.valueOf(io);
            imageWidget.setImage(new GuiTextureGroup(this.createAutoProgressTexture(), new ColorBorderTexture(1, this.getColorByIO(this.capabilityIO))));
        }).setButtonBackground(ResourceBorderTexture.BUTTON_COMMON).setBackground(new ColorRectTexture(-5592406)).setHoverTooltip("multiblocked.gui.trait.capability_io"));
        dialog.addWidget(imageSelector);
        dialog.addWidget(new SelectorWidget(5, 65, 60, 15, Arrays.stream(ProgressTexture.FillDirection.VALUES).map(Enum::name).collect(Collectors.toList()), -1).setValue(this.fillDirection.name()).setOnChanged(io -> {
            this.fillDirection = ProgressTexture.FillDirection.valueOf(io);
            ProgressTexture autoProgressTexture = this.createAutoProgressTexture();
            imageSelector.setButtonTexture(new GuiTextureGroup(new ColorBorderTexture(1, -1), autoProgressTexture));
            imageWidget.setImage(new GuiTextureGroup(autoProgressTexture, new ColorBorderTexture(1, this.getColorByIO(this.capabilityIO))));
        }).setButtonBackground(ResourceBorderTexture.BUTTON_COMMON).setBackground(new ColorRectTexture(-5592406)).setHoverTooltip("multiblocked.gui.trait.fill_direction"));
        imageSelector.setOnPressCallback(cd -> new ResourceTextureWidget((WidgetGroup)dialog.parent.getGui().guiWidgets.get((Object)0), texture1 -> {
            if (texture1 != null) {
                this.texture = texture1.imageLocation.toString();
                ProgressTexture autoProgressTexture = this.createAutoProgressTexture();
                imageSelector.setButtonTexture(new GuiTextureGroup(new ColorBorderTexture(1, -1), autoProgressTexture));
                imageWidget.setImage(new GuiTextureGroup(autoProgressTexture, new ColorBorderTexture(1, this.getColorByIO(this.capabilityIO))));
            }
        }));
    }

    private ProgressTexture createAutoProgressTexture() {
        ProgressTexture.Auto texture = new ProgressTexture.Auto(new ResourceTexture(this.texture).getSubTexture(0.0, 0.0, 1.0, 0.5), new ResourceTexture(this.texture).getSubTexture(0.0, 0.5, 1.0, 0.5));
        texture.setFillDirection(this.fillDirection);
        return texture;
    }
}

