/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.capability.trait;

import com.cleanroommc.multiblocked.api.capability.MultiblockCapability;
import com.cleanroommc.multiblocked.api.capability.trait.CapabilityTrait;
import com.cleanroommc.multiblocked.api.gui.texture.ColorRectTexture;
import com.cleanroommc.multiblocked.api.gui.texture.ResourceBorderTexture;
import com.cleanroommc.multiblocked.api.gui.texture.ResourceTexture;
import com.cleanroommc.multiblocked.api.gui.texture.TextTexture;
import com.cleanroommc.multiblocked.api.gui.widget.WidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.ButtonWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.DialogWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.DraggableScrollableWidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.DraggableWidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.ImageWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.SelectorWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.TextFieldWidget;
import com.cleanroommc.multiblocked.api.tile.ComponentTileEntity;
import com.cleanroommc.multiblocked.util.JsonUtil;
import com.cleanroommc.multiblocked.util.Position;
import com.cleanroommc.multiblocked.util.Size;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JsonUtils;

public abstract class PlayerCapabilityTrait
extends CapabilityTrait {
    protected String playerName = "";
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected TextTexture.TextType textType;

    public PlayerCapabilityTrait(MultiblockCapability<?> capability) {
        super(capability);
    }

    public String getPlayerName() {
        return this.playerName.isEmpty() ? (this.playerName = this.getPlayer() == null ? "" : this.getPlayer().func_70005_c_()) : this.playerName;
    }

    @Nullable
    public EntityPlayer getPlayer() {
        return this.component.getOwner();
    }

    @Override
    public void setComponent(ComponentTileEntity<?> component) {
        super.setComponent(component);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.playerName = compound.func_74779_i("player");
        this.getPlayerName();
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        compound.func_74778_a("player", this.getPlayerName());
    }

    @Override
    public void serialize(@Nullable JsonElement jsonElement) {
        if (jsonElement == null) {
            jsonElement = new JsonObject();
        }
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        this.x = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"x", (int)5);
        this.y = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"y", (int)5);
        this.width = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"width", (int)60);
        this.height = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"height", (int)18);
        this.textType = JsonUtil.getEnumOr(jsonObject, "textType", TextTexture.TextType.class, TextTexture.TextType.LEFT);
    }

    @Override
    public JsonElement deserialize() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("x", (Number)this.x);
        jsonObject.addProperty("y", (Number)this.y);
        jsonObject.addProperty("width", (Number)this.width);
        jsonObject.addProperty("height", (Number)this.height);
        jsonObject.addProperty("textType", (Number)this.textType.ordinal());
        return jsonObject;
    }

    @Override
    public void createUI(ComponentTileEntity<?> component, WidgetGroup group, EntityPlayer player) {
        super.createUI(component, group, player);
        group.addWidget(new ImageWidget(this.x, this.y, this.width, this.height, new TextTexture("").setSupplier(() -> this.playerName).setWidth(this.width).setType(this.textType)){

            @Override
            public void writeInitialData(PacketBuffer buffer) {
                super.writeInitialData(buffer);
                buffer.func_180714_a(PlayerCapabilityTrait.this.getPlayerName());
            }

            @Override
            public void readInitialData(PacketBuffer buffer) {
                super.readInitialData(buffer);
                PlayerCapabilityTrait.this.playerName = buffer.func_150789_c(Short.MAX_VALUE);
            }
        });
    }

    protected void refreshSlots(DraggableScrollableWidgetGroup dragGroup) {
        dragGroup.widgets.forEach(dragGroup::waitToRemoved);
        ButtonWidget setting = (ButtonWidget)new ButtonWidget(this.width - 8, 0, 8, 8, new ResourceTexture("multiblocked:textures/gui/option.png"), null).setHoverBorderTexture(1, -1).setHoverTooltip("settings");
        ImageWidget imageWidget = new ImageWidget(0, 0, this.width, this.height, new TextTexture("Player Name").setWidth(this.width).setType(this.textType).setBackgroundColor(-16777216));
        setting.setVisible(false);
        DraggableWidgetGroup slot = new DraggableWidgetGroup(this.x, this.y, this.width, this.height);
        slot.setOnSelected(w -> setting.setVisible(true));
        slot.setOnUnSelected(w -> setting.setVisible(false));
        slot.addWidget(imageWidget);
        slot.addWidget(setting);
        slot.setOnEndDrag(b -> {
            this.x = b.getSelfPosition().x;
            this.y = b.getSelfPosition().y;
        });
        dragGroup.addWidget(slot);
        setting.setOnPressCallback(cd2 -> {
            DialogWidget dialog = new DialogWidget(dragGroup, true);
            dialog.addWidget(new ImageWidget(0, 0, 176, 256, new ColorRectTexture(-1358954496)));
            this.initSettingDialog(dialog, slot);
        });
    }

    protected void initSettingDialog(DialogWidget dialog, DraggableWidgetGroup slot) {
        ImageWidget imageWidget = (ImageWidget)slot.widgets.get(0);
        ButtonWidget setting = (ButtonWidget)slot.widgets.get(1);
        dialog.addWidget(new TextFieldWidget(5, 25, 50, 15, true, null, s -> {
            this.width = Integer.parseInt(s);
            Size size = new Size(this.width, this.height);
            slot.setSize(size);
            imageWidget.setSize(size);
            ((TextTexture)imageWidget.getImage()).setWidth(this.width);
            setting.setSelfPosition(new Position(this.width - 8, 0));
        }).setCurrentString(this.width + "").setNumbersOnly(10, 180).setHoverTooltip("set width"));
        dialog.addWidget(new TextFieldWidget(5, 45, 50, 15, true, null, s -> {
            this.height = Integer.parseInt(s);
            Size size = new Size(this.width, this.height);
            slot.setSize(size);
            imageWidget.setSize(size);
            setting.setSelfPosition(new Position(this.width - 8, 0));
        }).setCurrentString(this.height + "").setNumbersOnly(10, 180).setHoverTooltip("set height"));
        dialog.addWidget(new SelectorWidget(5, 5, 50, 15, Arrays.stream(TextTexture.TextType.values()).map(Enum::name).collect(Collectors.toList()), -1).setValue(this.textType.name()).setOnChanged(io -> {
            this.textType = TextTexture.TextType.valueOf(io);
            ((TextTexture)imageWidget.getImage()).setType(this.textType);
        }).setButtonBackground(ResourceBorderTexture.BUTTON_COMMON).setBackground(new ColorRectTexture(-5592406)).setHoverTooltip("TextType"));
    }

    @Override
    public void openConfigurator(WidgetGroup parentDialog) {
        DraggableScrollableWidgetGroup dragGroup = new DraggableScrollableWidgetGroup(104, 0, 176, 256);
        parentDialog.addWidget(dragGroup);
        this.refreshSlots(dragGroup);
    }
}

