/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.capability.trait;

import com.cleanroommc.multiblocked.api.block.CustomProperties;
import com.cleanroommc.multiblocked.api.capability.IO;
import com.cleanroommc.multiblocked.api.capability.MultiblockCapability;
import com.cleanroommc.multiblocked.api.capability.trait.CapabilityTrait;
import com.cleanroommc.multiblocked.api.definition.ComponentDefinition;
import com.cleanroommc.multiblocked.api.gui.texture.ColorBorderTexture;
import com.cleanroommc.multiblocked.api.gui.texture.ColorRectTexture;
import com.cleanroommc.multiblocked.api.gui.texture.GuiTextureGroup;
import com.cleanroommc.multiblocked.api.gui.texture.ResourceBorderTexture;
import com.cleanroommc.multiblocked.api.gui.texture.ResourceTexture;
import com.cleanroommc.multiblocked.api.gui.texture.TextTexture;
import com.cleanroommc.multiblocked.api.gui.widget.WidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.ButtonWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.DialogWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.DraggableScrollableWidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.DraggableWidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.ImageWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.SelectorWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.TextFieldWidget;
import com.cleanroommc.multiblocked.util.JsonUtil;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.JsonUtils;
import org.apache.commons.lang3.ArrayUtils;

public abstract class MultiCapabilityTrait
extends CapabilityTrait {
    protected IO[] capabilityIO;
    protected IO[] guiIO;
    protected IO[] mbdIO;
    protected String[] slotName;
    protected int[] x;
    protected int[] y;
    protected boolean[] autoIO;

    public MultiCapabilityTrait(MultiblockCapability<?> capability) {
        super(capability);
    }

    @Override
    public void serialize(@Nullable JsonElement jsonElement) {
        if (jsonElement == null) {
            jsonElement = new JsonArray();
        }
        JsonArray jsonArray = jsonElement.getAsJsonArray();
        int size = jsonArray.size();
        this.capabilityIO = new IO[size];
        this.guiIO = new IO[size];
        this.mbdIO = new IO[size];
        this.slotName = new String[size];
        this.x = new int[size];
        this.y = new int[size];
        this.autoIO = new boolean[size];
        int i = 0;
        for (JsonElement element : jsonArray) {
            JsonObject jsonObject = element.getAsJsonObject();
            this.capabilityIO[i] = JsonUtil.getEnumOr(jsonObject, "cIO", IO.class, IO.BOTH);
            this.guiIO[i] = JsonUtil.getEnumOr(jsonObject, "gIO", IO.class, IO.BOTH);
            this.mbdIO[i] = JsonUtil.getEnumOr(jsonObject, "mIO", IO.class, IO.BOTH);
            this.slotName[i] = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"slotName", (String)"");
            this.x[i] = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"x", (int)5);
            this.y[i] = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"y", (int)5);
            this.autoIO[i] = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"autoIO", (boolean)false);
            ++i;
        }
    }

    @Override
    public JsonElement deserialize() {
        JsonArray jsonArray = new JsonArray();
        for (int i = 0; i < this.capabilityIO.length; ++i) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("cIO", (Number)this.capabilityIO[i].ordinal());
            jsonObject.addProperty("gIO", (Number)this.guiIO[i].ordinal());
            jsonObject.addProperty("mIO", (Number)this.mbdIO[i].ordinal());
            if (!this.slotName[i].isEmpty()) {
                jsonObject.addProperty("slotName", this.slotName[i]);
            }
            jsonObject.addProperty("x", (Number)this.x[i]);
            jsonObject.addProperty("y", (Number)this.y[i]);
            jsonObject.addProperty("autoIO", Boolean.valueOf(this.autoIO[i]));
            jsonArray.add((JsonElement)jsonObject);
        }
        return jsonArray;
    }

    @Override
    public Set<String> getSlotNames() {
        return Arrays.stream(this.slotName).filter(s -> !s.isEmpty()).collect(Collectors.toSet());
    }

    public EnumFacing[] getIOFacing() {
        if (((ComponentDefinition)this.component.getDefinition()).properties.rotationState != CustomProperties.RotationState.NONE) {
            return new EnumFacing[]{this.component.getFrontFacing()};
        }
        return EnumFacing.field_82609_l;
    }

    protected int getColorByIO(IO io) {
        return io == IO.IN ? -1358889216 : (io == IO.OUT ? -1342242816 : -1358954241);
    }

    protected void refreshSlots(DraggableScrollableWidgetGroup dragGroup) {
        dragGroup.widgets.forEach(dragGroup::waitToRemoved);
        int i = 0;
        while (i < this.guiIO.length) {
            int finalI = i++;
            ButtonWidget setting = (ButtonWidget)new ButtonWidget(10, 0, 8, 8, new ResourceTexture("multiblocked:textures/gui/option.png"), null).setHoverBorderTexture(1, -1).setHoverTooltip("multiblocked.gui.tips.settings");
            ImageWidget imageWidget = new ImageWidget(1, 1, 16, 16, new GuiTextureGroup(new ColorRectTexture(this.getColorByIO(this.guiIO[finalI])), new ColorBorderTexture(1, this.getColorByIO(this.capabilityIO[finalI]))));
            setting.setVisible(false);
            DraggableWidgetGroup slot = new DraggableWidgetGroup(this.x[finalI], this.y[finalI], 18, 18);
            slot.setOnSelected(w -> setting.setVisible(true));
            slot.setOnUnSelected(w -> setting.setVisible(false));
            slot.addWidget(imageWidget);
            slot.addWidget(setting);
            slot.setOnEndDrag(b -> {
                this.x[finalI] = b.getSelfPosition().x;
                this.y[finalI] = b.getSelfPosition().y;
            });
            dragGroup.addWidget(slot);
            setting.setOnPressCallback(cd2 -> {
                DialogWidget dialog = new DialogWidget(dragGroup, true);
                dialog.addWidget(new ImageWidget(0, 0, 176, 256, new ColorRectTexture(-1358954496)));
                dialog.addWidget(new ButtonWidget(5, 5, 85, 20, new GuiTextureGroup(ResourceBorderTexture.BUTTON_COMMON, new TextTexture("multiblocked.gui.trait.remove_slot")), cd3 -> {
                    this.removeSlot(finalI);
                    this.refreshSlots(dragGroup);
                    dialog.close();
                }).setHoverBorderTexture(1, -1));
                this.initSettingDialog(dialog, slot, finalI);
            });
        }
    }

    protected void initSettingDialog(DialogWidget dialog, DraggableWidgetGroup slot, int index) {
        ImageWidget imageWidget = (ImageWidget)slot.widgets.get(0);
        dialog.addWidget(new SelectorWidget(100, 50, 65, 15, Arrays.asList("multiblocked.gui.trait.auto_io", "multiblocked.gui.trait.passive_io"), -1).setValue(this.autoIO[index] ? "multiblocked.gui.trait.auto_io" : "multiblocked.gui.trait.passive_io").setOnChanged(auto -> {
            this.autoIO[index] = auto.equals("multiblocked.gui.trait.auto_io");
        }).setButtonBackground(ResourceBorderTexture.BUTTON_COMMON).setBackground(new ColorRectTexture(-5592406)).setHoverTooltip("multiblocked.gui.trait.auto"));
        dialog.addWidget(new SelectorWidget(5, 30, 40, 15, Arrays.stream(IO.VALUES).map(Enum::name).collect(Collectors.toList()), -1).setValue(this.capabilityIO[index].name()).setOnChanged(io -> {
            this.capabilityIO[index] = IO.valueOf(io);
            this.updateImageWidget(imageWidget, index);
        }).setButtonBackground(ResourceBorderTexture.BUTTON_COMMON).setBackground(new ColorRectTexture(-5592406)).setHoverTooltip("multiblocked.gui.trait.capability_io"));
        dialog.addWidget(new SelectorWidget(50, 30, 40, 15, Arrays.stream(IO.VALUES).map(Enum::name).collect(Collectors.toList()), -1).setValue(this.guiIO[index].name()).setOnChanged(io -> {
            this.guiIO[index] = IO.valueOf(io);
            this.updateImageWidget(imageWidget, index);
        }).setButtonBackground(ResourceBorderTexture.BUTTON_COMMON).setBackground(new ColorRectTexture(-5592406)).setHoverTooltip("multiblocked.gui.trait.gui_io"));
        dialog.addWidget(new SelectorWidget(95, 30, 40, 15, Arrays.stream(IO.VALUES).map(Enum::name).collect(Collectors.toList()), -1).setValue(this.mbdIO[index].name()).setOnChanged(io -> {
            this.mbdIO[index] = IO.valueOf(io);
        }).setButtonBackground(ResourceBorderTexture.BUTTON_COMMON).setBackground(new ColorRectTexture(-5592406)).setHoverTooltip("multiblocked.gui.trait.mbd_io"));
        dialog.addWidget(new TextFieldWidget(100, 10, 65, 15, true, null, s -> {
            this.slotName[index] = s;
        }).setCurrentString(this.slotName[index] + "").setHoverTooltip("multiblocked.gui.trait.slot_name"));
    }

    protected void updateImageWidget(ImageWidget imageWidget, int index) {
        imageWidget.setImage(new GuiTextureGroup(new ColorRectTexture(this.getColorByIO(this.guiIO[index])), new ColorBorderTexture(1, this.getColorByIO(this.capabilityIO[index]))));
    }

    protected void addSlot() {
        this.capabilityIO = (IO[])ArrayUtils.add((Object[])this.capabilityIO, (Object)((Object)IO.BOTH));
        this.guiIO = (IO[])ArrayUtils.add((Object[])this.guiIO, (Object)((Object)IO.BOTH));
        this.mbdIO = (IO[])ArrayUtils.add((Object[])this.mbdIO, (Object)((Object)IO.BOTH));
        this.slotName = (String[])ArrayUtils.add((Object[])this.slotName, (Object)"");
        this.autoIO = ArrayUtils.add((boolean[])this.autoIO, (boolean)false);
        this.x = ArrayUtils.add((int[])this.x, (int)5);
        this.y = ArrayUtils.add((int[])this.y, (int)5);
    }

    protected void removeSlot(int index) {
        this.capabilityIO = (IO[])ArrayUtils.remove((Object[])this.capabilityIO, (int)index);
        this.guiIO = (IO[])ArrayUtils.remove((Object[])this.guiIO, (int)index);
        this.mbdIO = (IO[])ArrayUtils.remove((Object[])this.mbdIO, (int)index);
        this.slotName = (String[])ArrayUtils.remove((Object[])this.slotName, (int)index);
        this.autoIO = ArrayUtils.remove((boolean[])this.autoIO, (int)index);
        this.x = ArrayUtils.remove((int[])this.x, (int)index);
        this.y = ArrayUtils.remove((int[])this.y, (int)index);
    }

    @Override
    public void openConfigurator(WidgetGroup parentDialog) {
        DraggableScrollableWidgetGroup dragGroup = new DraggableScrollableWidgetGroup(104, 0, 176, 256);
        parentDialog.addWidget(dragGroup);
        this.refreshSlots(dragGroup);
        parentDialog.addWidget(new ButtonWidget(84, 35, 20, 20, new ResourceTexture("multiblocked:textures/gui/add.png"), cd -> {
            this.addSlot();
            this.refreshSlots(dragGroup);
        }).setHoverTooltip("multiblocked.gui.trait.add_slot"));
    }

    protected IO[] getRealMbdIO() {
        IO[] realIO = new IO[this.mbdIO.length];
        for (int i = 0; i < this.mbdIO.length; ++i) {
            realIO[i] = this.mbdIO[i] == IO.IN ? IO.OUT : (this.mbdIO[i] == IO.OUT ? IO.IN : this.mbdIO[i]);
        }
        return realIO;
    }
}

