/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.capability.proxy;

import com.cleanroommc.multiblocked.api.capability.IInnerCapabilityProvider;
import com.cleanroommc.multiblocked.api.capability.IO;
import com.cleanroommc.multiblocked.api.capability.MultiblockCapability;
import com.cleanroommc.multiblocked.api.recipe.Recipe;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;

public abstract class CapabilityProxy<K> {
    public final MultiblockCapability<? super K> capability;
    public EnumFacing facing;
    public Set<String> slots;
    private long latestPeriodID;
    private TileEntity tileEntity;

    public CapabilityProxy(MultiblockCapability<? super K> capability, TileEntity tileEntity) {
        this.capability = capability;
        this.tileEntity = tileEntity;
        this.facing = EnumFacing.UP;
    }

    public TileEntity getTileEntity() {
        if (this.tileEntity != null && this.tileEntity.func_145837_r()) {
            this.tileEntity = this.tileEntity.func_145831_w().func_175625_s(this.tileEntity.func_174877_v());
        }
        return this.tileEntity;
    }

    public <C> C getCapability(Capability<C> capability, @Nullable String slotName) {
        TileEntity tileEntity = this.getTileEntity();
        return (C)(tileEntity == null ? null : (tileEntity instanceof IInnerCapabilityProvider ? ((IInnerCapabilityProvider)tileEntity).getInnerCapability(capability, this.facing, slotName) : tileEntity.getCapability(capability, this.facing)));
    }

    public long getLatestPeriodID() {
        return this.latestPeriodID;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CapabilityProxy)) {
            return false;
        }
        return Objects.equals(this.getTileEntity(), ((CapabilityProxy)obj).getTileEntity());
    }

    protected abstract List<K> handleRecipeInner(IO var1, Recipe var2, List<K> var3, @Nullable String var4, boolean var5);

    protected boolean hasInnerChanged() {
        return true;
    }

    public final K copyContent(Object content) {
        return (K)this.capability.copyInner(content);
    }

    public final List<K> searchingRecipe(IO io, Recipe recipe, List<?> left, @Nullable String slotName) {
        return this.handleRecipeInner(io, recipe, left.stream().map(this::copyContent).collect(Collectors.toList()), slotName, true);
    }

    public final List<K> handleRecipe(IO io, Recipe recipe, List<?> left, @Nullable String slotName) {
        return this.handleRecipeInner(io, recipe, left.stream().map(this::copyContent).collect(Collectors.toList()), slotName, false);
    }

    public final void updateChangedState(long periodID) {
        if (this.hasInnerChanged() || periodID < this.latestPeriodID) {
            this.latestPeriodID = periodID;
        }
    }
}

