/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.capability;

import com.cleanroommc.multiblocked.Multiblocked;
import com.cleanroommc.multiblocked.api.block.BlockComponent;
import com.cleanroommc.multiblocked.api.capability.IInnerCapabilityProvider;
import com.cleanroommc.multiblocked.api.capability.IO;
import com.cleanroommc.multiblocked.api.capability.proxy.CapabilityProxy;
import com.cleanroommc.multiblocked.api.capability.trait.CapabilityTrait;
import com.cleanroommc.multiblocked.api.gui.texture.ColorRectTexture;
import com.cleanroommc.multiblocked.api.gui.widget.WidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.LabelWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.recipe.ContentWidget;
import com.cleanroommc.multiblocked.api.pattern.util.BlockInfo;
import com.cleanroommc.multiblocked.api.recipe.ContentModifier;
import com.cleanroommc.multiblocked.api.registry.MbdComponents;
import com.cleanroommc.multiblocked.jei.IJeiIngredientAdapter;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonSerializer;
import crafttweaker.annotations.ZenRegister;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenProperty;

@ZenClass(value="mods.multiblocked.capability.Capability")
@ZenRegister
public abstract class MultiblockCapability<T>
implements JsonSerializer<T>,
JsonDeserializer<T> {
    @ZenProperty
    public final String name;
    @ZenProperty
    public final int color;
    @Nullable
    public final IJeiIngredientAdapter<T, ?> jeiIngredientAdapter;

    protected MultiblockCapability(String name, int color, IJeiIngredientAdapter<T, ?> jeiIngredientAdapter) {
        this.name = name;
        this.color = color;
        this.jeiIngredientAdapter = jeiIngredientAdapter;
    }

    protected MultiblockCapability(String name, int color) {
        this(name, color, null);
    }

    public String getUnlocalizedName() {
        return "multiblocked.capability." + this.name;
    }

    public abstract T defaultContent();

    public abstract boolean isBlockHasCapability(@Nonnull IO var1, @Nonnull TileEntity var2);

    public abstract T copyInner(T var1);

    public T copyInnerByModifier(T content, ContentModifier modifier) {
        return this.copyInner(content);
    }

    protected abstract CapabilityProxy<? extends T> createProxy(@Nonnull IO var1, @Nonnull TileEntity var2);

    public CapabilityProxy<? extends T> createProxy(@Nonnull IO io, @Nonnull TileEntity tileEntity, EnumFacing facing, @Nullable Map<Long, Set<String>> slotsMap) {
        CapabilityProxy<T> proxy = this.createProxy(io, tileEntity);
        proxy.facing = facing;
        Set<String> set = proxy.slots = slotsMap == null ? null : slotsMap.get(tileEntity.func_174877_v().func_177986_g());
        if (tileEntity instanceof IInnerCapabilityProvider) {
            IInnerCapabilityProvider slotNameProvider = (IInnerCapabilityProvider)tileEntity;
            if (proxy.slots == null) {
                proxy.slots = slotNameProvider.getSlotNames();
            } else {
                proxy.slots.addAll(slotNameProvider.getSlotNames());
            }
        }
        return proxy;
    }

    public ContentWidget<? super T> createContentWidget() {
        return new ContentWidget<T>(){

            @Override
            protected void onContentUpdate() {
                if (Multiblocked.isClient()) {
                    this.setHoverTooltip(I18n.func_135052_a((String)"multiblocked.content.miss", (Object[])new Object[]{this.io, I18n.func_135052_a((String)MultiblockCapability.this.getUnlocalizedName(), (Object[])new Object[0]), this.content.toString()}));
                }
            }

            @Override
            public void openConfigurator(WidgetGroup dialog) {
                super.openConfigurator(dialog);
                dialog.addWidget(new LabelWidget(5, 30, "multiblocked.gui.label.configurator"));
            }
        }.setBackground(new ColorRectTexture(this.color));
    }

    public boolean hasTrait() {
        return false;
    }

    public CapabilityTrait createTrait() {
        return null;
    }

    public final <C> Set<C> getCapability(Capability<C> capability, @Nonnull TileEntity tileEntity) {
        LinkedHashSet found = new LinkedHashSet();
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            Object cap = tileEntity.getCapability(capability, facing);
            if (cap == null) continue;
            return Collections.singleton(cap);
        }
        return found;
    }

    @Nonnull
    public final <C> EnumFacing getFrontFacing(Capability<C> capability, @Nonnull TileEntity tileEntity) {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            Object cap = tileEntity.getCapability(capability, facing);
            if (cap == null) continue;
            return facing;
        }
        return EnumFacing.UP;
    }

    public BlockInfo[] getCandidates() {
        if (this.hasTrait()) {
            return MbdComponents.getBlockInfoWithCapability(this);
        }
        throw new RuntimeException("Multiblocked Capability " + this.name + " doesn't give proper candidates.");
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public final BlockComponent getAnyBlock() {
        return (BlockComponent)MbdComponents.COMPONENT_BLOCKS_REGISTRY.get((Object)new ResourceLocation("multiblocked", this.name + ".any"));
    }

    public final JsonElement serialize(Object obj) {
        return this.serialize(obj, null, null);
    }

    public final T deserialize(JsonElement jsonElement) {
        return (T)this.deserialize(jsonElement, null, null);
    }
}

