/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.capability;

import com.cleanroommc.multiblocked.api.capability.CommonCapabilityProxyHolder;
import com.cleanroommc.multiblocked.api.capability.IO;
import com.cleanroommc.multiblocked.api.capability.MultiblockCapability;
import com.cleanroommc.multiblocked.api.capability.proxy.CapabilityProxy;
import com.google.common.collect.Table;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.world.IBlockPos;
import crafttweaker.api.world.IWorld;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import stanhebben.zenscript.annotations.OperatorType;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;
import stanhebben.zenscript.annotations.ZenOperator;

@ZenClass(value="mods.multiblocked.capability.CapabilityHolder")
@ZenRegister
public interface ICapabilityProxyHolder {
    @ZenGetter
    default public boolean hasProxies() {
        return this.getCapabilities() != null && !this.getCapabilities().isEmpty();
    }

    @ZenMethod
    default public boolean hasProxy(IO io, MultiblockCapability<?> capability) {
        return this.hasProxies() && this.getCapabilities().contains((Object)io, capability);
    }

    @ZenMethod
    @ZenOperator(value=OperatorType.ADD)
    default public ICapabilityProxyHolder mergeWith(ICapabilityProxyHolder otherHolder) {
        return new CommonCapabilityProxyHolder(this.getCapabilities()).mergeWith(otherHolder);
    }

    public Table<IO, MultiblockCapability<?>, Long2ObjectOpenHashMap<CapabilityProxy<?>>> getCapabilities();

    public static ICapabilityProxyHolder fromWorldPos(World world, BlockPos pos, MultiblockCapability<?> ... capabilities) {
        return new CommonCapabilityProxyHolder(world, pos, capabilities);
    }

    @ZenMethod
    @Optional.Method(modid="crafttweaker")
    public static ICapabilityProxyHolder fromWorldPos(IWorld world, IBlockPos pos, MultiblockCapability<?> ... capabilities) {
        return ICapabilityProxyHolder.fromWorldPos(CraftTweakerMC.getWorld((IWorld)world), CraftTweakerMC.getBlockPos((IBlockPos)pos), capabilities);
    }
}

