/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.capability;

import com.cleanroommc.multiblocked.api.capability.ICapabilityProxyHolder;
import com.cleanroommc.multiblocked.api.capability.IO;
import com.cleanroommc.multiblocked.api.capability.MultiblockCapability;
import com.cleanroommc.multiblocked.api.capability.proxy.CapabilityProxy;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.EnumMap;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CommonCapabilityProxyHolder
implements ICapabilityProxyHolder {
    protected Table<IO, MultiblockCapability<?>, Long2ObjectOpenHashMap<CapabilityProxy<?>>> capabilities;

    public CommonCapabilityProxyHolder(World world, BlockPos pos, MultiblockCapability<?> ... capability) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null) {
            this.capabilities = Tables.newCustomTable(new EnumMap(IO.class), Object2ObjectOpenHashMap::new);
            for (MultiblockCapability<?> cap : capability) {
                if (cap.isBlockHasCapability(IO.BOTH, te)) {
                    this.capabilities.put((Object)IO.BOTH, cap, (Object)new Long2ObjectOpenHashMap());
                    ((Long2ObjectOpenHashMap)this.capabilities.get((Object)IO.BOTH, cap)).put(te.func_174877_v().func_177986_g(), cap.createProxy(IO.BOTH, te));
                    continue;
                }
                if (cap.isBlockHasCapability(IO.IN, te)) {
                    this.capabilities.put((Object)IO.IN, cap, (Object)new Long2ObjectOpenHashMap());
                    ((Long2ObjectOpenHashMap)this.capabilities.get((Object)IO.IN, cap)).put(te.func_174877_v().func_177986_g(), cap.createProxy(IO.IN, te));
                    continue;
                }
                if (!cap.isBlockHasCapability(IO.OUT, te)) continue;
                this.capabilities.put((Object)IO.OUT, cap, (Object)new Long2ObjectOpenHashMap());
                ((Long2ObjectOpenHashMap)this.capabilities.get((Object)IO.OUT, cap)).put(te.func_174877_v().func_177986_g(), cap.createProxy(IO.OUT, te));
            }
        }
    }

    public CommonCapabilityProxyHolder(Table<IO, MultiblockCapability<?>, Long2ObjectOpenHashMap<CapabilityProxy<?>>> capabilities) {
        this.capabilities = capabilities;
    }

    @Override
    public ICapabilityProxyHolder mergeWith(ICapabilityProxyHolder capabilityProxyHolder) {
        if (this.hasProxies() && capabilityProxyHolder.hasProxies()) {
            Table capabilities = Tables.newCustomTable(new EnumMap(IO.class), Object2ObjectOpenHashMap::new);
            capabilities.putAll(capabilities);
            capabilities.putAll(capabilityProxyHolder.getCapabilities());
            return new CommonCapabilityProxyHolder(capabilities);
        }
        return this.hasProxies() ? this : capabilityProxyHolder;
    }

    @Override
    public Table<IO, MultiblockCapability<?>, Long2ObjectOpenHashMap<CapabilityProxy<?>>> getCapabilities() {
        return this.capabilities;
    }
}

