/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.block;

import com.cleanroommc.multiblocked.Multiblocked;
import com.cleanroommc.multiblocked.api.definition.ComponentDefinition;
import com.cleanroommc.multiblocked.api.registry.MbdComponents;
import com.cleanroommc.multiblocked.api.tile.ComponentTileEntity;
import com.cleanroommc.multiblocked.client.model.IModelSupplier;
import com.cleanroommc.multiblocked.client.model.SimpleStateMapper;
import com.cleanroommc.multiblocked.client.particle.MCParticleHandler;
import com.cleanroommc.multiblocked.client.renderer.ComponentRenderer;
import com.cleanroommc.multiblocked.client.renderer.IRenderer;
import com.cleanroommc.multiblocked.util.RayTraceUtils;
import com.cleanroommc.multiblocked.util.Vector3;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityWitherSkull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockComponent
extends Block
implements IModelSupplier,
ITileEntityProvider {
    public static final ModelResourceLocation MODEL_LOCATION = new ModelResourceLocation(new ResourceLocation("multiblocked", "component_block"), "normal");
    public final ComponentDefinition definition;
    protected final ThreadLocal<ComponentTileEntity<?>> componentBroken = new ThreadLocal();

    public BlockComponent(ComponentDefinition definition) {
        super(Material.field_151573_f);
        this.func_149711_c(1.5f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149752_b(10.0f);
        if (definition != null) {
            for (CreativeTabs tab : CreativeTabs.field_78032_a) {
                if (!tab.field_78034_o.equals(definition.properties.tabGroup)) continue;
                this.func_149647_a(tab);
                break;
            }
            this.setRegistryName(definition.location);
            this.func_149663_c(definition.location.func_110624_b() + "." + definition.location.func_110623_a());
            this.func_149711_c(definition.properties.destroyTime);
            this.setHarvestLevel("pickaxe", definition.properties.harvestLevel);
            this.func_149752_b(definition.properties.explosionResistance);
        }
        this.definition = definition;
    }

    public boolean func_149703_v() {
        return this.definition.properties.hasCollision;
    }

    public boolean func_176214_u(@Nonnull IBlockState state) {
        return this.definition.properties.isOpaque;
    }

    public boolean canCreatureSpawn(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EntityLiving.SpawnPlacementType type) {
        return false;
    }

    public ComponentTileEntity<?> getComponent(IBlockAccess blockAccess, BlockPos pos) {
        TileEntity instance = blockAccess.func_175625_s(pos);
        return instance instanceof ComponentTileEntity ? (ComponentTileEntity)instance : null;
    }

    public void func_180633_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityLivingBase placer, @Nonnull ItemStack stack) {
        ComponentTileEntity<?> componentTileEntity = this.getComponent((IBlockAccess)worldIn, pos);
        if (componentTileEntity != null) {
            if (componentTileEntity.isValidFrontFacing(EnumFacing.UP)) {
                componentTileEntity.setFrontFacing(EnumFacing.func_190914_a((BlockPos)pos, (EntityLivingBase)placer));
            } else {
                componentTileEntity.setFrontFacing(placer.func_174811_aO().func_176734_d());
            }
            if (placer instanceof EntityPlayer) {
                componentTileEntity.setOwner(placer.func_110124_au());
            }
        }
    }

    @Nonnull
    public ItemStack getPickBlock(@Nonnull IBlockState state, @Nonnull RayTraceResult target, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player) {
        return this.definition.getStackForm();
    }

    public void func_185477_a(@Nonnull IBlockState state, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull AxisAlignedBB entityBox, @Nonnull List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        ComponentTileEntity<?> instance = this.getComponent((IBlockAccess)worldIn, pos);
        if (instance != null) {
            for (AxisAlignedBB boundingBox : instance.getCollisionBoundingBox()) {
                AxisAlignedBB offset = boundingBox.func_186670_a(pos);
                if (!offset.func_72326_a(entityBox)) continue;
                collidingBoxes.add(offset);
            }
        }
    }

    @Nullable
    public RayTraceResult func_180636_a(@Nonnull IBlockState blockState, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull Vec3d start, @Nonnull Vec3d end) {
        ComponentTileEntity<?> instance = this.getComponent((IBlockAccess)worldIn, pos);
        if (instance != null) {
            return RayTraceUtils.rayTraceClosest(pos, new Vector3(start), new Vector3(end), instance.getCollisionBoundingBox());
        }
        return this.func_185503_a(pos, start, end, blockState.func_185900_c((IBlockAccess)worldIn, pos));
    }

    public boolean rotateBlock(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing axis) {
        ComponentTileEntity<?> instance = this.getComponent((IBlockAccess)world, pos);
        return instance != null && instance.setFrontFacing(axis);
    }

    @Nullable
    public EnumFacing[] getValidRotations(@Nonnull World world, @Nonnull BlockPos pos) {
        ComponentTileEntity<?> instance = this.getComponent((IBlockAccess)world, pos);
        return instance == null ? null : (EnumFacing[])Arrays.stream(EnumFacing.field_82609_l).filter(instance::isValidFrontFacing).toArray(EnumFacing[]::new);
    }

    public void func_180663_b(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        this.componentBroken.set(this.getComponent((IBlockAccess)worldIn, pos));
        super.func_180663_b(worldIn, pos, state);
    }

    public void func_180657_a(@Nonnull World worldIn, @Nonnull EntityPlayer player, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nullable TileEntity te, @Nonnull ItemStack stack) {
        this.componentBroken.set(te instanceof ComponentTileEntity ? (ComponentTileEntity<?>)te : this.componentBroken.get());
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        this.componentBroken.set(null);
    }

    public void getDrops(@Nonnull NonNullList<ItemStack> drops, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull IBlockState state, int fortune) {
        ComponentTileEntity<?> instance = this.componentBroken.get();
        if (instance == null) {
            return;
        }
        instance.onDrops(drops, (EntityPlayer)this.harvesters.get());
    }

    public boolean func_180639_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityPlayer playerIn, @Nonnull EnumHand hand, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ) {
        ComponentTileEntity<?> instance = this.getComponent((IBlockAccess)worldIn, pos);
        if (instance != null) {
            return instance.onRightClick(playerIn, hand, facing, hitX, hitY, hitZ);
        }
        return true;
    }

    public void func_180649_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull EntityPlayer playerIn) {
        ComponentTileEntity<?> instance = this.getComponent((IBlockAccess)worldIn, pos);
        if (instance != null) {
            instance.onLeftClick(playerIn);
        }
    }

    public boolean canConnectRedstone(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nullable EnumFacing side) {
        ComponentTileEntity<?> instance = this.getComponent(world, pos);
        return instance != null && instance.canConnectRedstone(side == null ? null : side.func_176734_d());
    }

    public boolean shouldCheckWeakPower(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
        return false;
    }

    public int func_180656_a(@Nonnull IBlockState blockState, @Nonnull IBlockAccess blockAccess, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
        ComponentTileEntity<?> instance = this.getComponent(blockAccess, pos);
        return instance == null ? 0 : instance.getOutputRedstoneSignal(side.func_176734_d());
    }

    public void func_189540_a(@Nonnull IBlockState state, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull Block blockIn, @Nonnull BlockPos fromPos) {
        ComponentTileEntity<?> instance = this.getComponent((IBlockAccess)worldIn, pos);
        if (instance != null) {
            instance.onNeighborChanged();
        }
    }

    public boolean canRenderInLayer(@Nonnull IBlockState state, @Nonnull BlockRenderLayer layer) {
        return true;
    }

    public boolean func_149662_c(@Nonnull IBlockState state) {
        return this.definition == null || this.definition.properties.isOpaque;
    }

    public boolean func_149686_d(@Nonnull IBlockState state) {
        return this.definition.properties.isOpaque;
    }

    public boolean func_149730_j(IBlockState state) {
        return this.func_149662_c(state);
    }

    public int func_185484_c(@Nonnull IBlockState state, @Nonnull IBlockAccess source, @Nonnull BlockPos pos) {
        if (this.func_149662_c(state)) {
            return super.func_185484_c(state, source, pos);
        }
        int i = source.func_175626_b(pos, 0);
        int j = source.func_175626_b(pos.func_177984_a(), 0);
        int k = i & 0xFF;
        int l = j & 0xFF;
        int i1 = i >> 16 & 0xFF;
        int j1 = j >> 16 & 0xFF;
        return Math.max(k, l) | Math.max(i1, j1) << 16;
    }

    public int getLightOpacity(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        return this.func_149662_c(state) ? 255 : 0;
    }

    public void func_149666_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> items) {
        items.add((Object)new ItemStack((Block)MbdComponents.COMPONENT_BLOCKS_REGISTRY.get((Object)this.definition.location), 1));
    }

    public boolean canEntityDestroy(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull Entity entity) {
        return !(entity instanceof EntityWither) && !(entity instanceof EntityWitherSkull);
    }

    @Nonnull
    public EnumBlockRenderType func_149645_b(@Nonnull IBlockState state) {
        if (Multiblocked.isClient()) {
            return ComponentRenderer.COMPONENT_RENDER_TYPE;
        }
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_176225_a(@Nonnull IBlockState blockState, @Nonnull IBlockAccess blockAccess, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
        return !this.func_149662_c(blockState) || super.func_176225_a(blockState, blockAccess, pos, side);
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getParticleTexture(World world, BlockPos blockPos) {
        IRenderer renderer;
        ComponentTileEntity<?> tileEntity = this.getComponent((IBlockAccess)world, blockPos);
        if (tileEntity != null && (renderer = tileEntity.getRenderer()) != null) {
            return renderer.getParticleTexture();
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(@Nonnull IBlockState state, @Nonnull World worldObj, RayTraceResult target, @Nonnull ParticleManager manager) {
        TextureAtlasSprite atlasSprite = this.getParticleTexture(worldObj, target.func_178782_a());
        if (atlasSprite == null) {
            return true;
        }
        MCParticleHandler.addHitEffects(state, worldObj, target, manager, atlasSprite);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull ParticleManager manager) {
        TextureAtlasSprite atlasSprite = this.getParticleTexture(world, pos);
        if (atlasSprite == null) {
            return true;
        }
        MCParticleHandler.addBlockDestroyEffects(world.func_180495_p(pos), world, pos, manager, atlasSprite);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addRunningEffects(@Nonnull IBlockState state, World world, @Nonnull BlockPos pos, @Nonnull Entity entity) {
        if (world.field_72995_K) {
            TextureAtlasSprite atlasSprite = this.getParticleTexture(world, pos);
            if (atlasSprite == null) {
                return true;
            }
            MCParticleHandler.addBlockRunningEffects(state, world, pos, entity, atlasSprite);
        }
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onModelRegister() {
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new SimpleStateMapper(MODEL_LOCATION));
        for (IBlockState state : this.func_176194_O().func_177619_a()) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)this.func_176201_c(state), (ModelResourceLocation)MODEL_LOCATION);
        }
    }

    public TileEntity func_149915_a(@Nonnull World worldIn, int meta) {
        return this.definition.createNewTileEntity(worldIn);
    }

    @ParametersAreNonnullByDefault
    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof ComponentTileEntity) {
            ComponentTileEntity component = (ComponentTileEntity)tileEntity;
            return ((ComponentDefinition)component.getDefinition()).getStatus(component.getStatus()).getLightEmissive();
        }
        return super.getLightValue(state, world, pos);
    }
}

