/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked;

import com.cleanroommc.multiblocked.Listeners;
import com.cleanroommc.multiblocked.MbdConfig;
import com.cleanroommc.multiblocked.Multiblocked;
import com.cleanroommc.multiblocked.api.capability.MultiblockCapability;
import com.cleanroommc.multiblocked.api.capability.trait.CapabilityTrait;
import com.cleanroommc.multiblocked.api.capability.trait.InterfaceUser;
import com.cleanroommc.multiblocked.api.definition.ComponentDefinition;
import com.cleanroommc.multiblocked.api.definition.ControllerDefinition;
import com.cleanroommc.multiblocked.api.definition.PartDefinition;
import com.cleanroommc.multiblocked.api.gui.factory.TileEntityUIFactory;
import com.cleanroommc.multiblocked.api.gui.factory.UIFactory;
import com.cleanroommc.multiblocked.api.gui.widget.imp.blueprint_table.dialogs.JsonBlockPatternWidget;
import com.cleanroommc.multiblocked.api.item.ItemMultiblockBuilder;
import com.cleanroommc.multiblocked.api.recipe.RecipeMap;
import com.cleanroommc.multiblocked.api.registry.MbdCapabilities;
import com.cleanroommc.multiblocked.api.registry.MbdComponents;
import com.cleanroommc.multiblocked.api.registry.MbdItems;
import com.cleanroommc.multiblocked.api.registry.MbdPredicates;
import com.cleanroommc.multiblocked.api.registry.MbdRecipeConditions;
import com.cleanroommc.multiblocked.api.registry.MbdRenderers;
import com.cleanroommc.multiblocked.api.tile.BlueprintTableTileEntity;
import com.cleanroommc.multiblocked.api.tile.ControllerTileTesterEntity;
import com.cleanroommc.multiblocked.api.tile.part.PartTileTesterEntity;
import com.cleanroommc.multiblocked.client.renderer.impl.CycleBlockStateRenderer;
import com.cleanroommc.multiblocked.core.asm.DynamicTileEntityGenerator;
import com.cleanroommc.multiblocked.network.MultiblockedNetworking;
import com.cleanroommc.multiblocked.util.FileUtility;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import crafttweaker.CraftTweakerAPI;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import software.bernie.geckolib3.GeckoLib;

@Mod.EventBusSubscriber(modid="multiblocked")
public class CommonProxy {
    public void preInit() {
        Multiblocked.LOGGER.info("pre init");
        if (Loader.isModLoaded((String)"geckolib3")) {
            GeckoLib.initialize();
        }
        MinecraftForge.EVENT_BUS.register(Listeners.class);
        MultiblockedNetworking.init();
        MbdCapabilities.registerCapabilities();
        MbdRenderers.registerRenderers();
        MbdPredicates.registerPredicates();
        MbdRecipeConditions.registerConditions();
    }

    public void init() {
        Multiblocked.LOGGER.info("init");
        RecipeMap.registerRecipeFromFile(Multiblocked.GSON, new File(Multiblocked.location, "recipe_map"));
        MbdComponents.executeInitHandler();
        UIFactory.register(TileEntityUIFactory.INSTANCE);
        if (Loader.isModLoaded((String)"crafttweaker")) {
            Multiblocked.LOGGER.info("ct loader multiblocked");
            CraftTweakerAPI.tweaker.loadScript(false, "multiblocked");
        }
    }

    public void postInit() {
        Multiblocked.LOGGER.info("post init");
        for (MultiblockCapability<?> capability : MbdCapabilities.CAPABILITY_REGISTRY.values()) {
            capability.getAnyBlock().definition.getBaseStatus().setRenderer(new CycleBlockStateRenderer(capability.getCandidates()));
        }
        RecipeMap.RECIPE_MAP_REGISTRY.values().forEach(RecipeMap::sort);
    }

    public static void registerComponents() {
        MbdCapabilities.registerAnyCapabilityBlocks();
        BlueprintTableTileEntity.registerBlueprintTable();
        ControllerTileTesterEntity.registerTestController();
        PartTileTesterEntity.registerTestPart();
        JsonBlockPatternWidget.registerBlock();
        if (MbdConfig.enableBuiltInComponents) {
            MbdComponents.registerComponentFromResource(Multiblocked.class, new ResourceLocation("multiblocked", "part/mbd_energy_input"), PartDefinition.class, CommonProxy::partPost);
            MbdComponents.registerComponentFromResource(Multiblocked.class, new ResourceLocation("multiblocked", "part/mbd_energy_output"), PartDefinition.class, CommonProxy::partPost);
            MbdComponents.registerComponentFromResource(Multiblocked.class, new ResourceLocation("multiblocked", "part/mbd_item_input"), PartDefinition.class, CommonProxy::partPost);
            MbdComponents.registerComponentFromResource(Multiblocked.class, new ResourceLocation("multiblocked", "part/mbd_item_output"), PartDefinition.class, CommonProxy::partPost);
            MbdComponents.registerComponentFromResource(Multiblocked.class, new ResourceLocation("multiblocked", "part/mbd_fluid_input"), PartDefinition.class, CommonProxy::partPost);
            MbdComponents.registerComponentFromResource(Multiblocked.class, new ResourceLocation("multiblocked", "part/mbd_fluid_output"), PartDefinition.class, CommonProxy::partPost);
            MbdComponents.registerComponentFromResource(Multiblocked.class, new ResourceLocation("multiblocked", "part/mbd_entity"), PartDefinition.class, CommonProxy::partPost);
        }
        MbdComponents.registerComponentFromFile(new File(Multiblocked.location, "definition/controller"), ControllerDefinition.class, CommonProxy::controllerPost);
        MbdComponents.registerComponentFromFile(new File(Multiblocked.location, "definition/part"), PartDefinition.class, CommonProxy::partPost);
    }

    @SubscribeEvent
    public static void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        JsonElement sounds;
        File file = new File(Multiblocked.location, "assets/multiblocked/sounds.json");
        if (file.exists() && file.isFile() && (sounds = FileUtility.loadJson(file)) instanceof JsonObject) {
            IForgeRegistry registry = event.getRegistry();
            for (Map.Entry sound : sounds.getAsJsonObject().entrySet()) {
                SoundEvent soundEvent = new SoundEvent(new ResourceLocation("multiblocked", (String)sound.getKey()));
                registry.register(soundEvent.setRegistryName(new ResourceLocation("multiblocked", (String)sound.getKey())));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        CommonProxy.registerComponents();
        IForgeRegistry registry = event.getRegistry();
        MbdComponents.registerBlocks((IForgeRegistry<Block>)registry);
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        MbdComponents.COMPONENT_ITEMS_REGISTRY.values().forEach(arg_0 -> ((IForgeRegistry)registry).register(arg_0));
        MbdItems.registerItems((IForgeRegistry<Item>)registry);
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        ForgeRegistries.RECIPES.register(new ItemMultiblockBuilder.BuilderRecipeLogic().setRegistryName("multiblocked", "builder"));
    }

    private static void componentPost(ComponentDefinition definition, JsonObject config) {
        ArrayList<CapabilityTrait> useInterfaceTraits = new ArrayList<CapabilityTrait>();
        for (Map.Entry entry : definition.traits.entrySet()) {
            CapabilityTrait trait;
            MultiblockCapability<?> capability = MbdCapabilities.get((String)entry.getKey());
            if (capability == null || !capability.hasTrait() || !(trait = capability.createTrait()).getClass().isAnnotationPresent(InterfaceUser.class)) continue;
            useInterfaceTraits.add(trait);
        }
        if (!useInterfaceTraits.isEmpty()) {
            Class<?> teClazz = new DynamicTileEntityGenerator(definition.location.func_110623_a(), useInterfaceTraits, definition.clazz).generateClass();
            definition.setTileEntityClass(teClazz);
            GameRegistry.registerTileEntity(teClazz, (ResourceLocation)definition.location);
        }
    }

    public static void controllerPost(ControllerDefinition definition, JsonObject config) {
        ItemStack catalyst;
        CommonProxy.componentPost(definition, config);
        if (definition.noNeedController && (catalyst = definition.getCatalyst()) != null && !catalyst.func_190926_b()) {
            MbdComponents.registerNoNeedController(catalyst, definition);
        }
    }

    public static void partPost(PartDefinition definition, JsonObject config) {
        CommonProxy.componentPost(definition, config);
    }
}

