/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.guilib.components;

import de.erdbeerbaerlp.guilib.components.Button;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.config.GuiUtils;

public class ToggleButton
extends Button {
    private boolean value = false;
    private DrawType drawType = DrawType.COLORED_LINE;
    private ResourceLocation offIcon = null;

    public ToggleButton(int xPos, int yPos, String displayString) {
        this(xPos, yPos, 100, displayString);
    }

    public ToggleButton(int xPos, int yPos, int width, String displayString) {
        this(xPos, yPos, width, 20, displayString);
    }

    public ToggleButton(int xPos, int yPos, int width, String displayString, ResourceLocation icon) {
        this(xPos, yPos, width, 20, displayString, icon);
    }

    public ToggleButton(int xPos, int yPos, int width, int height, String displayString) {
        this(xPos, yPos, width, height, displayString, (ResourceLocation)null);
    }

    public ToggleButton(int xPos, int yPos, int width, int height, String displayString, ResourceLocation icon) {
        super(xPos, yPos, width, height, displayString, icon);
    }

    public ToggleButton(int xPos, int yPos, String string, ResourceLocation icon) {
        this(xPos, yPos, 100, string, icon);
    }

    public ToggleButton(int xPos, int yPos, ResourceLocation onIcon, ResourceLocation offIcon) {
        this(xPos, yPos, 20, "", onIcon);
        this.offIcon = offIcon;
    }

    @Override
    public void draw(int mouseX, int mouseY, float partial) {
        if (this.visible) {
            this.hovered = mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.width && mouseY < this.getY() + this.height;
            int k = this.getHoverState(this.hovered);
            GuiUtils.drawContinuousTexturedBox((ResourceLocation)BUTTON_TEXTURES, (int)this.getX(), (int)this.getY(), (int)0, (int)(46 + k * 20), (int)this.width, (int)this.height, (int)200, (int)20, (int)2, (int)3, (int)2, (int)2, (float)this.field_73735_i);
            int color = 0xE0E0E0;
            if (this.packedFGColour != 0) {
                color = this.packedFGColour;
            } else if (!this.enabled) {
                color = 0xA0A0A0;
            } else if (this.hovered) {
                color = 0xFFFFA0;
            }
            int bx = this.getX();
            int mwidth = this.width;
            if (this.BUTTON_ICON != null) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(this.offIcon != null && (this.drawType == DrawType.STRING_OR_ICON || this.drawType == DrawType.BOTH) ? (this.value ? this.BUTTON_ICON : this.offIcon) : this.BUTTON_ICON);
                ToggleButton.func_146110_a((int)(bx + 2), (int)(this.getY() + 2), (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
                bx += 18;
                mwidth -= 16;
            }
            String buttonText = this.displayString;
            int strWidth = this.mc.field_71466_p.func_78256_a(buttonText);
            int ellipsisWidth = this.mc.field_71466_p.func_78256_a("...");
            if (strWidth > mwidth - 6 && strWidth > ellipsisWidth) {
                buttonText = this.mc.field_71466_p.func_78269_a(buttonText, mwidth - 6 - ellipsisWidth).trim() + "...";
            }
            this.func_73732_a(this.mc.field_71466_p, buttonText + ((this.drawType == DrawType.STRING_OR_ICON || this.drawType == DrawType.BOTH) && this.offIcon == null ? (this.value ? "ON" : "OFF") : ""), bx + mwidth / 2, this.getY() + (this.height - 8) / 2, color);
        }
        if (this.drawType == DrawType.COLORED_LINE || this.drawType == DrawType.BOTH) {
            ToggleButton.func_73734_a((int)(this.getX() + 6), (int)(this.getY() + this.height - 3), (int)(this.getX() + this.width - 6), (int)(this.getY() + this.height - 4), (int)(this.value ? Color.GREEN.getRGB() : Color.red.getRGB()));
        }
    }

    public void setDrawType(DrawType type) {
        this.drawType = type;
    }

    @Override
    public void mouseClick(int mouseX, int mouseY, int mouseButton) {
        if (this.mousePressed(this.mc, mouseX, mouseY)) {
            this.playPressSound();
            this.value = !this.value;
            this.onClick();
        }
    }

    public boolean getValue() {
        return this.value;
    }

    public void setValue(boolean value) {
        this.value = value;
    }

    public static enum DrawType {
        COLORED_LINE,
        STRING_OR_ICON,
        BOTH;


        public String getName() {
            switch (this) {
                case COLORED_LINE: {
                    return "Colored Line";
                }
                case STRING_OR_ICON: {
                    return "String or Icon";
                }
                case BOTH: {
                    return "All";
                }
            }
            return this.name();
        }
    }
}

