/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.guilib.components;

import de.erdbeerbaerlp.guilib.components.GuiComponent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.config.GuiUtils;

public class Slider
extends GuiComponent {
    protected Runnable action;
    protected double prevValue;
    protected double minValue;
    protected double maxValue;
    protected double sliderValue;
    protected String dispString;
    protected String suffix;
    protected boolean showDecimal;
    protected int precision;
    protected String displayString;
    protected boolean drawString;
    protected boolean dragging;

    public Slider(int xPos, int yPos, String prefix, double minVal, double maxVal, double currentVal, Runnable changeAction) {
        this(xPos, yPos, 150, 20, prefix, "", minVal, maxVal, currentVal, true, true, changeAction);
    }

    public Slider(int xPos, int yPos, int width, int height, String prefix, String suf, double minVal, double maxVal, double currentVal, boolean showDec, boolean drawStr) {
        this(xPos, yPos, width, height, prefix, suf, minVal, maxVal, currentVal, showDec, drawStr, null);
    }

    public Slider(int xPos, int yPos, int width, int height, String prefix, String suf, double minVal, double maxVal, double currentVal, boolean showDec, boolean drawStr, Runnable changeAction) {
        super(xPos, yPos, width, height);
        String val;
        this.action = changeAction;
        this.minValue = minVal;
        this.maxValue = maxVal;
        this.sliderValue = (currentVal - this.minValue) / (this.maxValue - this.minValue);
        this.dispString = prefix;
        this.suffix = suf;
        this.showDecimal = showDec;
        if (this.showDecimal) {
            val = Double.toString(this.sliderValue * (this.maxValue - this.minValue) + this.minValue);
            this.precision = Math.min(val.substring(val.indexOf(".") + 1).length(), 4);
        } else {
            val = Integer.toString((int)Math.round(this.sliderValue * (this.maxValue - this.minValue) + this.minValue));
            this.precision = 0;
        }
        this.displayString = this.dispString + val + this.suffix;
        this.drawString = drawStr;
        if (!this.drawString) {
            this.displayString = "";
        }
    }

    public void setAction(Runnable action) {
        this.action = action;
    }

    public void updateSlider() {
        String val;
        if (this.sliderValue < 0.0) {
            this.sliderValue = 0.0;
        }
        if (this.sliderValue > 1.0) {
            this.sliderValue = 1.0;
        }
        if (this.showDecimal) {
            val = Double.toString(this.sliderValue * (this.maxValue - this.minValue) + this.minValue);
            if (val.substring(val.indexOf(".") + 1).length() > this.precision) {
                if ((val = val.substring(0, val.indexOf(".") + this.precision + 1)).endsWith(".")) {
                    val = val.substring(0, val.indexOf(".") + this.precision);
                }
            } else {
                while (val.substring(val.indexOf(".") + 1).length() < this.precision) {
                    val = val + "0";
                }
            }
        } else {
            val = Integer.toString((int)Math.round(this.sliderValue * (this.maxValue - this.minValue) + this.minValue));
        }
        if (this.drawString) {
            this.displayString = this.dispString + val + this.suffix;
        }
        if (this.prevValue != this.getValue()) {
            this.onValueChanged();
        }
    }

    public void onValueChanged() {
        if (this.action != null) {
            this.action.run();
        }
    }

    @Override
    public void draw(int mouseX, int mouseY, float partial) {
        if (this.visible) {
            this.hovered = mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.width && mouseY < this.getY() + this.height;
            int k = this.getHoverState(this.hovered);
            GuiUtils.drawContinuousTexturedBox((ResourceLocation)BUTTON_TEXTURES, (int)this.getX(), (int)this.getY(), (int)0, (int)(46 + k * 20), (int)this.width, (int)this.height, (int)200, (int)20, (int)2, (int)3, (int)2, (int)2, (float)this.field_73735_i);
            this.mouseClickMove(mouseX, mouseY, 0, 0L);
            int color = 0xE0E0E0;
            if (this.packedFGColour != 0) {
                color = this.packedFGColour;
            } else if (!this.enabled) {
                color = 0xA0A0A0;
            } else if (this.hovered) {
                color = 0xFFFFA0;
            }
            String buttonText = this.displayString;
            int strWidth = this.mc.field_71466_p.func_78256_a(buttonText);
            int ellipsisWidth = this.mc.field_71466_p.func_78256_a("...");
            if (strWidth > this.width - 6 && strWidth > ellipsisWidth) {
                buttonText = this.mc.field_71466_p.func_78269_a(buttonText, this.width - 6 - ellipsisWidth).trim() + "...";
            }
            if (this.drawString) {
                this.func_73732_a(this.mc.field_71466_p, buttonText, this.getX() + this.width / 2, this.getY() + (this.height - 8) / 2, color);
            }
        }
    }

    private int getHoverState(boolean hovered) {
        return 0;
    }

    @Override
    public void mouseClick(int mouseX, int mouseY, int mouseButton) {
        this.prevValue = this.getValue();
        if (this.mousePressed(this.mc, mouseX, mouseY)) {
            this.playPressSound();
        }
    }

    public boolean mousePressed(Minecraft mc, int mouseX, int mouseY) {
        if (this.visible && mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.width && mouseY < this.getY() + this.height) {
            this.sliderValue = (float)(mouseX - (this.getX() + 4)) / (float)(this.width - 8);
            this.updateSlider();
            this.dragging = true;
            return true;
        }
        return false;
    }

    @Override
    public void mouseReleased(int mouseX, int mouseY, int state) {
        this.dragging = false;
    }

    @Override
    public void keyTyped(char typedChar, int keyCode) {
    }

    @Override
    public void mouseClickMove(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        this.prevValue = this.getValue();
        if (this.visible) {
            if (this.dragging) {
                this.sliderValue = (float)(mouseX - (this.getX() + 4)) / (float)(this.width - 8);
                this.updateSlider();
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.func_73729_b(this.getX() + (int)(this.sliderValue * (double)(this.width - 8)), this.getY(), 0, 66, 4, 20);
            this.func_73729_b(this.getX() + (int)(this.sliderValue * (double)(this.width - 8)) + 4, this.getY(), 196, 66, 4, 20);
        }
    }

    public int getValueInt() {
        return (int)Math.round(this.sliderValue * (this.maxValue - this.minValue) + this.minValue);
    }

    public double getValue() {
        return this.sliderValue * (this.maxValue - this.minValue) + this.minValue;
    }
}

