/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.guilib;

import de.erdbeerbaerlp.guilib.components.Button;
import de.erdbeerbaerlp.guilib.components.CheckBox;
import de.erdbeerbaerlp.guilib.components.EnumSlider;
import de.erdbeerbaerlp.guilib.components.Image;
import de.erdbeerbaerlp.guilib.components.Label;
import de.erdbeerbaerlp.guilib.components.Slider;
import de.erdbeerbaerlp.guilib.components.TextField;
import de.erdbeerbaerlp.guilib.components.ToggleButton;
import de.erdbeerbaerlp.guilib.gui.BetterGuiScreen;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;

public class ExampleGUI
extends BetterGuiScreen {
    private Button exampleButton;
    private CheckBox exampleCheckbox;
    private TextField exampleTextField;
    private Label exampleLabel1;
    private Button exitButton;
    private Slider exampleSlider1;
    private EnumSlider exampleSlider2;
    private ToggleButton exampleToggleButton;
    private EnumSlider drawTypeSlider;
    private Image googleImage;
    private Image apple;

    @Override
    public void buildGui() {
        this.exampleButton = new Button(50, 50, "Button", Button.DefaultButtonIcons.SAVE);
        this.exampleCheckbox = new CheckBox(50, 70, "Checkbox", false);
        this.exampleTextField = new TextField(50, 100, 150);
        this.exampleLabel1 = new Label("Example GUI", this.field_146294_l / 2, 10);
        this.exitButton = new Button(0, 0, Button.DefaultButtonIcons.DELETE);
        this.exampleSlider1 = new Slider(50, 130, "Slider: ", 0.0, 100.0, 50.0, () -> System.out.println(this.exampleSlider1.getValue()));
        this.exampleSlider2 = new EnumSlider(200, 130, "Enum Slider: ", ExampleEnum.class, ExampleEnum.EXAMPLE, () -> {
            System.out.println("Enum changed to \"" + ((ExampleEnum)this.exampleSlider2.getEnum()).getName() + "\"");
            System.out.println("Index: " + this.exampleSlider2.getValueInt());
            System.out.println("Other Value: " + ((ExampleEnum)this.exampleSlider2.getEnum()).getOtherValue());
        });
        this.exampleToggleButton = new ToggleButton(50, 170, "Toggle Button: ");
        this.drawTypeSlider = new EnumSlider(156, 170, "Draw type: ", ToggleButton.DrawType.class, ToggleButton.DrawType.COLORED_LINE, () -> this.exampleToggleButton.setDrawType((ToggleButton.DrawType)this.drawTypeSlider.getEnum()));
        this.googleImage = new Image(200, 40, 136, 46, "https://www.google.de/images/branding/googlelogo/1x/googlelogo_color_272x92dp.png");
        this.apple = new Image(0, 0, 16, 16, new ResourceLocation("minecraft", "textures/items/apple.png"));
        this.exampleButton.setClickListener(() -> System.out.println("I have been clicked!"));
        this.exampleCheckbox.setChangeListener(() -> System.out.println(this.exampleCheckbox.isChecked() ? "I just got Checked" : "I just have been unchecked :/"));
        this.exitButton.setClickListener(() -> this.openGui(null));
        this.exampleTextField.setReturnAction(() -> this.exampleButton.setText(this.exampleTextField.getText()));
        this.exampleToggleButton.setClickListener(() -> {
            System.out.println("New Value: " + this.exampleToggleButton.getValue());
            this.exampleButton.setEnabled(this.exampleToggleButton.getValue());
        });
        this.apple.setCallback(() -> {
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187739_dZ, (float)1.0f));
            this.apple.setVisible(false);
            this.apple.disable();
        });
        this.exampleButton.setTooltips("Example Tooltip", "This is a Button");
        this.exampleCheckbox.setTooltips("Another Tooltip", "This is a Checkbox", "");
        this.exampleTextField.setTooltips("A simple Textbox", "This one does support colors too!", "Simply use a \u00a7", "Press return to run a callback");
        this.exitButton.setTooltips("Closes this GUI");
        this.exampleSlider1.setTooltips("A simple double/integer slider");
        this.exampleSlider2.setTooltips("This slider works using Enums", "It will change through all enum values");
        this.exampleToggleButton.setTooltips("This button can be toggled");
        this.drawTypeSlider.setTooltips("Change how the toggle button will be rendered");
        this.googleImage.setTooltips("This is an example image", "It was loaded from an URL");
        this.apple.setTooltips("Oh, look at this apple!", "", "Click to eat");
        this.exampleTextField.setAcceptsColors(true);
        this.exampleTextField.setText("Text Field");
        this.exampleLabel1.setCentered();
        this.exampleToggleButton.setValue(true);
        this.addComponent(this.exampleLabel1);
        this.addComponent(this.exampleButton);
        this.addComponent(this.exitButton);
        this.addComponent(this.exampleCheckbox);
        this.addComponent(this.exampleTextField);
        this.addComponent(this.exampleSlider1);
        this.addComponent(this.exampleSlider2);
        this.addComponent(this.exampleToggleButton);
        this.addComponent(this.drawTypeSlider);
        this.addAllComponents(this.googleImage, this.apple);
    }

    @Override
    public void updateGui() {
        this.exampleLabel1.setX(this.field_146294_l / 2);
        this.exitButton.setX(this.field_146294_l - this.exitButton.getWidth() - 6);
        this.exitButton.setY(6);
        this.apple.setPosition(this.exitButton.getX() - 40, this.exitButton.getY() + 30);
    }

    @Override
    public boolean func_73868_f() {
        return false;
    }

    @Override
    public boolean doesEscCloseGui() {
        return false;
    }

    public static enum ExampleEnum {
        THIS("This", 1.0f),
        IS("is", 100.45f),
        AN("an", -90.0f),
        EXAMPLE("example", 1337.0f),
        SLIDER("slider", -2387.0f),
        WITH("with", 1.0E-9f),
        ENUM("enum", (float)Math.PI),
        VALUES("values.", 98234.5f),
        YAAAY("Yaay!", -0.0f);

        private String name;
        private float otherValue;

        private ExampleEnum(String name, float someOtherValue) {
            this.name = name;
            this.otherValue = someOtherValue;
        }

        public String getName() {
            return this.name;
        }

        public float getOtherValue() {
            return this.otherValue;
        }
    }
}

