/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.msmlegacy;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.darkhax.bookshelf.registry.RegistryHelper;
import net.darkhax.msmlegacy.ConfigurationHandler;
import net.darkhax.msmlegacy.CreativeTabMSMLegacy;
import net.darkhax.msmlegacy.item.ItemSwordRelic;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

@Mod(modid="msmlegacy", name="More Swords: Legacy", version="@VERSION@", dependencies="required-after:bookshelf@[2.3.577,)", certificateFingerprint="@FINGERPRINT@", acceptedMinecraftVersions="[1.12.2]")
public class MSMLegacy {
    private final CreativeTabs creativeTab = new CreativeTabMSMLegacy();
    public final RegistryHelper registry = new RegistryHelper("msmlegacy").setTab(this.creativeTab).enableAutoRegistration();
    public static final ConfigurationHandler config = new ConfigurationHandler(new File("config/msmlegacy.cfg"));
    private final String[] relicNames = new String[]{"aqueous", "candy", "infinity", "keyblade", "master", "molten", "pie"};
    public final List<Item> relics = new ArrayList<Item>();
    public Item dawnStar;
    public Enchantment ignite;
    public Enchantment sparks;
    public Item vampiricBlade;
    public Enchantment feast;
    public Enchantment vitality;
    public Item gladiolus;
    public Enchantment venomousAspect;
    public Enchantment absorb;
    public Item draconicBlade;
    public Enchantment keenEdge;
    public Enchantment scorn;
    public Item eyeEndBlade;
    public Enchantment enderPulse;
    public Enchantment enderAura;
    public Item crystalineBlade;
    public Enchantment greed;
    public Enchantment wisdom;
    public Item glacialBlade;
    public Enchantment frozenAspect;
    public Enchantment frostWave;
    public Item aeithersGuard;
    public Enchantment ascension;
    public Enchantment descension;
    public Item withersBane;
    public Enchantment consumingShadows;
    public Enchantment decay;
    public Item adminiumArk;
    public Enchantment stealth;
    public Enchantment extinction;

    @Mod.EventHandler
    public void onPreInit(FMLPreInitializationEvent event) {
        this.dawnStar = this.registry.registerItem((Item)new ItemSword(config.getMaterial("dawn_star", 3, 1286, 8, 6, 22)), "dawn_star");
        this.ignite = this.registry.registerEnchantment(config.getSwordEnchantment("ignite", this.dawnStar, Enchantment.Rarity.COMMON, 1, 3), "ignite");
        this.sparks = this.registry.registerEnchantment(config.getSwordEnchantment("sparks", this.dawnStar, Enchantment.Rarity.RARE, 1, 1), "sparks");
        this.registry.addShapedRecipe("dawn_star", new ItemStack(this.dawnStar), new Object[]{"bcm", "cmc", "rcb", Character.valueOf('b'), Items.field_151065_br, Character.valueOf('c'), Items.field_151059_bz, Character.valueOf('m'), Items.field_151064_bs, Character.valueOf('r'), Items.field_151072_bj});
        this.vampiricBlade = this.registry.registerItem((Item)new ItemSword(config.getMaterial("vampiric_blade", 3, 812, 8, 7, 12)), "vampiric_blade");
        this.feast = this.registry.registerEnchantment(config.getSwordEnchantment("feast", this.vampiricBlade, Enchantment.Rarity.COMMON, 1, 3), "feast");
        this.vitality = this.registry.registerEnchantment(config.getSwordEnchantment("vitality", this.vampiricBlade, Enchantment.Rarity.RARE, 1, 1), "vitality");
        this.registry.addShapedRecipe("vampiric_blade", new ItemStack(this.vampiricBlade), new Object[]{" ir", "ori", "so ", Character.valueOf('i'), "ingotIron", Character.valueOf('r'), "dustRedstone", Character.valueOf('o'), "obsidian", Character.valueOf('s'), "stickWood"});
        this.gladiolus = this.registry.registerItem((Item)new ItemSword(config.getMaterial("gladiolus", 3, 645, 8, 6, 10)), "gladiolus");
        this.venomousAspect = this.registry.registerEnchantment(config.getSwordEnchantment("venomous_aspect", this.gladiolus, Enchantment.Rarity.COMMON, 1, 3), "venomous_aspect");
        this.absorb = this.registry.registerEnchantment(config.getSwordEnchantment("absorb", this.gladiolus, Enchantment.Rarity.RARE, 1, 1), "absorb");
        this.registry.addShapedRecipe("gladiolus", new ItemStack(this.gladiolus), new Object[]{" lv", "sfl", "ts ", Character.valueOf('l'), "treeLeaves", Character.valueOf('v'), "vine", Character.valueOf('s'), "treeSapling", Character.valueOf('f'), new ItemStack((Block)Blocks.field_150328_O, 1, 1), Character.valueOf('t'), "stickWood"});
        this.draconicBlade = this.registry.registerItem((Item)new ItemSword(config.getMaterial("draconic_blade", 3, 1089, 8, 7, 16)), "draconic_blade");
        this.keenEdge = this.registry.registerEnchantment(config.getKeenEdge("keen_edge", this.draconicBlade, Enchantment.Rarity.COMMON, 1, 3), "keen_edge");
        this.scorn = this.registry.registerEnchantment(config.getSwordEnchantment("scorn", this.draconicBlade, Enchantment.Rarity.RARE, 1, 1), "scorn");
        this.registry.addShapedRecipe("draconic_blade", new ItemStack(this.draconicBlade), new Object[]{" ir", "ldi", "sl ", Character.valueOf('i'), "ingotIron", Character.valueOf('r'), "dustRedstone", Character.valueOf('l'), "gemLapis", Character.valueOf('d'), "gemDiamond", Character.valueOf('s'), "stickWood"});
        this.eyeEndBlade = this.registry.registerItem((Item)new ItemSword(config.getMaterial("eye_end_blade", 3, 1580, 8, 8, 22)), "eye_end_blade");
        this.enderPulse = this.registry.registerEnchantment(config.getSwordEnchantment("ender_pulse", this.eyeEndBlade, Enchantment.Rarity.COMMON, 1, 3), "ender_pulse");
        this.enderAura = this.registry.registerEnchantment(config.getSwordEnchantment("ender_aura", this.eyeEndBlade, Enchantment.Rarity.RARE, 1, 1), "ender_aura");
        this.registry.addShapedRecipe("eye_end_blade", new ItemStack(this.eyeEndBlade), new Object[]{" po", "dep", "sd ", Character.valueOf('p'), "enderpearl", Character.valueOf('o'), "obsidian", Character.valueOf('d'), "gemDiamond", Character.valueOf('e'), Items.field_151061_bv, Character.valueOf('s'), "stickWood"});
        this.crystalineBlade = this.registry.registerItem((Item)new ItemSword(config.getMaterial("crystaline_blade", 3, 570, 8, 5, 28)), "crystaline_blade");
        this.greed = this.registry.registerEnchantment(config.getSwordEnchantment("greed", this.crystalineBlade, Enchantment.Rarity.COMMON, 1, 3), "greed");
        this.wisdom = this.registry.registerEnchantment(config.getSwordEnchantment("wisdom", this.crystalineBlade, Enchantment.Rarity.RARE, 1, 1), "wisdom");
        this.registry.addShapedRecipe("crystaline", new ItemStack(this.crystalineBlade), new Object[]{" gg", "qpg", "sq ", Character.valueOf('g'), "blockGlass", Character.valueOf('p'), "paneGlass", Character.valueOf('q'), "gemQuartz", Character.valueOf('s'), "stickWood"});
        this.glacialBlade = this.registry.registerItem((Item)new ItemSword(config.getMaterial("glacial_blade", 3, 680, 8, 6, 15)), "glacial_blade");
        this.frozenAspect = this.registry.registerEnchantment(config.getSwordEnchantment("frozen_aspect", this.glacialBlade, Enchantment.Rarity.COMMON, 1, 3), "frozen_aspect");
        this.frostWave = this.registry.registerEnchantment(config.getSwordEnchantment("frost_wave", this.glacialBlade, Enchantment.Rarity.RARE, 1, 1), "frost_wave");
        this.registry.addShapedRecipe("glacial", new ItemStack(this.glacialBlade), new Object[]{" ip", "ipi", "si ", Character.valueOf('i'), Blocks.field_150432_aD, Character.valueOf('p'), Blocks.field_150403_cj, Character.valueOf('s'), "stickWood"});
        this.aeithersGuard = this.registry.registerItem((Item)new ItemSword(config.getMaterial("aethers_guard", 3, 1796, 8, 8, 22)), "aethers_guard");
        this.ascension = this.registry.registerEnchantment(config.getSwordEnchantment("ascension", this.aeithersGuard, Enchantment.Rarity.COMMON, 1, 3), "ascension");
        this.descension = this.registry.registerEnchantment(config.getSwordEnchantment("descension", this.aeithersGuard, Enchantment.Rarity.RARE, 1, 1), "descension");
        this.registry.addShapedRecipe("aethers_guard", new ItemStack(this.aeithersGuard), new Object[]{"fdg", "dgi", "sif", Character.valueOf('f'), "feather", Character.valueOf('d'), "gemDiamond", Character.valueOf('g'), "glowstone", Character.valueOf('i'), "ingotIron", Character.valueOf('s'), "stickWood"});
        this.withersBane = this.registry.registerItem((Item)new ItemSword(config.getMaterial("wither_bane", 3, 1869, 8, 6, 16)), "wither_bane");
        this.decay = this.registry.registerEnchantment(config.getSwordEnchantment("decay", this.withersBane, Enchantment.Rarity.COMMON, 1, 3), "decay");
        this.consumingShadows = this.registry.registerEnchantment(config.getSwordEnchantment("consuming_shadows", this.withersBane, Enchantment.Rarity.RARE, 1, 1), "consuming_shadows");
        this.registry.addShapedRecipe("wither_bane", new ItemStack(this.withersBane), new Object[]{" ss", "qns", "kq ", Character.valueOf('s'), Blocks.field_150425_aM, Character.valueOf('q'), "gemQuartz", Character.valueOf('n'), "netherStar", Character.valueOf('k'), "stickWood"});
        this.adminiumArk = this.registry.registerItem((Item)new ItemSword(config.getMaterial("adminium_ark", 3, 9999999, 8, 99999, 999)), "adminium_ark");
        this.stealth = this.registry.registerEnchantment(config.getSwordEnchantment("stealth", this.adminiumArk, Enchantment.Rarity.COMMON, 1, 1, false), "stealth");
        this.extinction = this.registry.registerEnchantment(config.getSwordEnchantment("extinction", this.adminiumArk, Enchantment.Rarity.RARE, 1, 1, false), "extinction");
        this.registry.addShapedRecipe("adminium_ark", new ItemStack(this.adminiumArk), new Object[]{" bb", "fcb", "sf ", Character.valueOf('b'), Blocks.field_150357_h, Character.valueOf('f'), Blocks.field_150378_br, Character.valueOf('c'), Blocks.field_150483_bI, Character.valueOf('s'), "stickWood"});
        for (String relicName : this.relicNames) {
            this.relics.add(this.registry.registerItem((Item)new ItemSwordRelic(), "relic_" + relicName));
        }
        config.syncConfigData();
    }
}

