/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.msmlegacy;

import java.util.List;
import net.darkhax.bookshelf.util.EntityUtils;
import net.darkhax.bookshelf.util.MathsUtils;
import net.darkhax.msmlegacy.MSMLegacy;
import net.darkhax.msmlegacy.item.ItemSwordRelic;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber(modid="msmlegacy")
public class EnchantmentEffectHandler {
    @Mod.Instance(value="msmlegacy")
    public static MSMLegacy msm;

    @SubscribeEvent
    public static void onDamageMob(LivingHurtEvent event) {
        EntityLivingBase user;
        ItemStack userItem;
        if (event.getSource().func_76346_g() instanceof EntityLivingBase) {
            EntityLivingBase target = event.getEntityLiving();
            EntityLivingBase attacker = (EntityLivingBase)event.getSource().func_76346_g();
            ItemStack heldItem = attacker.func_184614_ca();
            if (!heldItem.func_190926_b()) {
                EnchantmentEffectHandler.checkAndApplyEffect(EnchantmentEffectHandler.msm.ignite, target, attacker, heldItem, EnchantmentEffectHandler::handleIgniteEffect, event);
                EnchantmentEffectHandler.checkAndApplyEffect(EnchantmentEffectHandler.msm.sparks, target, attacker, heldItem, EnchantmentEffectHandler::handleSparksEffect, event);
                EnchantmentEffectHandler.checkAndApplyEffect(EnchantmentEffectHandler.msm.feast, target, attacker, heldItem, EnchantmentEffectHandler::handleFeastEffect, event);
                EnchantmentEffectHandler.checkAndApplyEffect(EnchantmentEffectHandler.msm.venomousAspect, target, attacker, heldItem, EnchantmentEffectHandler::handleVenomousAspect, event);
                EnchantmentEffectHandler.checkAndApplyEffect(EnchantmentEffectHandler.msm.absorb, target, attacker, heldItem, EnchantmentEffectHandler::handleAbsorbEffect, event);
                EnchantmentEffectHandler.checkAndApplyEffect(EnchantmentEffectHandler.msm.scorn, target, attacker, heldItem, EnchantmentEffectHandler::handleScornEffect, event);
                EnchantmentEffectHandler.checkAndApplyEffect(EnchantmentEffectHandler.msm.greed, target, attacker, heldItem, EnchantmentEffectHandler::handleGreedEffect, event);
                EnchantmentEffectHandler.checkAndApplyEffect(EnchantmentEffectHandler.msm.wisdom, target, attacker, heldItem, EnchantmentEffectHandler::handleWisdomEffect, event);
                EnchantmentEffectHandler.checkAndApplyEffect(EnchantmentEffectHandler.msm.frozenAspect, target, attacker, heldItem, EnchantmentEffectHandler::handleFrozenAspectEffect, event);
                EnchantmentEffectHandler.checkAndApplyEffect(EnchantmentEffectHandler.msm.frostWave, target, attacker, heldItem, EnchantmentEffectHandler::handleFrostWaveEffect, event);
                EnchantmentEffectHandler.checkAndApplyEffect(EnchantmentEffectHandler.msm.ascension, target, attacker, heldItem, EnchantmentEffectHandler::handleAscensionEffect, event);
                EnchantmentEffectHandler.checkAndApplyEffect(EnchantmentEffectHandler.msm.decay, target, attacker, heldItem, EnchantmentEffectHandler::handleDecayEffect, event);
                EnchantmentEffectHandler.checkAndApplyEffect(EnchantmentEffectHandler.msm.consumingShadows, target, attacker, heldItem, EnchantmentEffectHandler::handleConsumingShadowEffect, event);
                EnchantmentEffectHandler.checkAndApplyEffect(EnchantmentEffectHandler.msm.extinction, target, attacker, heldItem, EnchantmentEffectHandler::handleExtinctionEffect, event);
            }
        }
        if (!(userItem = (user = event.getEntityLiving()).func_184614_ca()).func_190926_b()) {
            EnchantmentEffectHandler.checkAndApplyEffect(EnchantmentEffectHandler.msm.enderAura, user, userItem, EnchantmentEffectHandler::handleEnderAura, event);
        }
    }

    @SubscribeEvent
    public static void onItemUsedEvent(PlayerInteractEvent.RightClickItem event) {
        if (!event.getItemStack().func_190926_b() && event.getHand() == EnumHand.MAIN_HAND) {
            EnchantmentEffectHandler.checkAndApplyEffect(EnchantmentEffectHandler.msm.vitality, (EntityLivingBase)event.getEntityPlayer(), event.getItemStack(), EnchantmentEffectHandler::handleVitalityEffect, event);
            EnchantmentEffectHandler.checkAndApplyEffect(EnchantmentEffectHandler.msm.enderPulse, (EntityLivingBase)event.getEntityPlayer(), event.getItemStack(), EnchantmentEffectHandler::handleEnderPulseEffect, event);
            EnchantmentEffectHandler.checkAndApplyEffect(EnchantmentEffectHandler.msm.stealth, (EntityLivingBase)event.getEntityPlayer(), event.getItemStack(), EnchantmentEffectHandler::handleStealthEffect, event);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        ItemStack heldItem = player.func_184614_ca();
        if (!heldItem.func_190926_b()) {
            EnchantmentEffectHandler.checkAndApplyEffect(EnchantmentEffectHandler.msm.descension, (EntityLivingBase)player, heldItem, EnchantmentEffectHandler::handleDescensionEffect);
        }
    }

    @SubscribeEvent
    public static void onSpecialSpawn(LivingSpawnEvent.SpecialSpawn event) {
        Item item;
        if ((event.getEntity() instanceof EntitySkeleton || event.getEntity() instanceof EntityZombie) && MathsUtils.tryPercentage((double)MSMLegacy.config.getSpawnChance()) && (item = (Item)EnchantmentEffectHandler.msm.registry.getItems().get(event.getWorld().field_73012_v.nextInt(EnchantmentEffectHandler.msm.registry.getItems().size()))) != EnchantmentEffectHandler.msm.adminiumArk && (MSMLegacy.config.isAllowRelics() || !(item instanceof ItemSwordRelic))) {
            event.getEntityLiving().func_184611_a(EnumHand.MAIN_HAND, new ItemStack(item));
        }
    }

    private static void handleExtinctionEffect(EntityLivingBase attacker, EntityLivingBase target, ItemStack item, int level, LivingHurtEvent event) {
        for (Entity entity : target.field_70170_p.field_72996_f) {
            if (!(entity instanceof EntityLiving) || entity == attacker || entity.getClass() != target.getClass()) continue;
            entity.func_70106_y();
        }
    }

    private static void handleConsumingShadowEffect(EntityLivingBase attacker, EntityLivingBase target, ItemStack item, int level, LivingHurtEvent event) {
        for (EntityLivingBase entity : EntityUtils.getEntitiesInArea(EntityLivingBase.class, (World)target.func_130014_f_(), (BlockPos)target.func_180425_c(), (int)level)) {
            if (entity == attacker) continue;
            entity.func_70690_d(new PotionEffect(MobEffects.field_82731_v, 60 * level, level));
            target.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 60 * level, level));
        }
    }

    private static void handleDecayEffect(EntityLivingBase attacker, EntityLivingBase target, ItemStack item, int level, LivingHurtEvent event) {
        target.func_70690_d(new PotionEffect(MobEffects.field_82731_v, 60 * level));
        target.func_70690_d(new PotionEffect(MobEffects.field_76438_s, 60 * level, level));
    }

    private static void handleDescensionEffect(EntityLivingBase user, ItemStack item, int level) {
        if (user.func_70093_af()) {
            user.field_70181_x *= 0.6;
            user.field_70143_R = 0.0f;
        }
    }

    private static void handleFrostWaveEffect(EntityLivingBase attacker, EntityLivingBase target, ItemStack item, int level, LivingHurtEvent event) {
        for (EntityLivingBase entity : EntityUtils.getEntitiesInArea(EntityLivingBase.class, (World)target.func_130014_f_(), (BlockPos)target.func_180425_c(), (int)level)) {
            if (entity == attacker) continue;
            entity.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 100 * level, level));
        }
    }

    private static void handleFrozenAspectEffect(EntityLivingBase attacker, EntityLivingBase target, ItemStack item, int level, LivingHurtEvent event) {
        target.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 200 * level, level));
    }

    private static void handleAscensionEffect(EntityLivingBase attacker, EntityLivingBase target, ItemStack item, int level, LivingHurtEvent event) {
        target.func_70690_d(new PotionEffect(MobEffects.field_188424_y, 30, 4 * level));
    }

    private static void handleEnderAura(EntityLivingBase user, ItemStack item, int level, LivingHurtEvent event) {
        for (int i = 0; i < 3; ++i) {
            Entity randomEntity;
            AxisAlignedBB bounds;
            List entities;
            if (!MathsUtils.tryPercentage((double)0.3) || (entities = user.field_70170_p.func_175674_a((Entity)user, bounds = user.func_174813_aQ().func_186662_g(30.0), entity -> entity instanceof EntityLivingBase)).isEmpty() || !((randomEntity = (Entity)entities.get(user.field_70170_p.field_73012_v.nextInt(entities.size()))) instanceof EntityLivingBase)) continue;
            EntityLivingBase living = (EntityLivingBase)randomEntity;
            user.func_70634_a(living.field_70165_t, living.field_70163_u, living.field_70161_v);
        }
    }

    private static void handleEnderPulseEffect(EntityLivingBase user, ItemStack item, int level, PlayerInteractEvent.RightClickItem event) {
        RayTraceResult results = MathsUtils.rayTrace((EntityLivingBase)user, (double)(16.0 * (double)level));
        if (results != null && results.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos tpPos = results.func_178782_a().func_177972_a(results.field_178784_b);
            user.func_70634_a((double)tpPos.func_177958_n() + 0.5, (double)tpPos.func_177956_o(), (double)((float)tpPos.func_177952_p() + 0.5f));
            item.func_77972_a(50, user);
            user.func_70097_a(DamageSource.field_76379_h, 1.0f);
        }
    }

    private static void handleGreedEffect(EntityLivingBase attacker, EntityLivingBase target, ItemStack item, int level, LivingHurtEvent event) {
        if (target.func_184222_aU() && MathsUtils.tryPercentage((double)(0.07 * (double)level)) && attacker instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)attacker;
            int exp = EntityUtils.getExperiencePoints((EntityLivingBase)target, (EntityPlayer)player);
            exp = ForgeEventFactory.getExperienceDrop((EntityLivingBase)target, (EntityPlayer)player, (int)exp);
            attacker.field_70170_p.func_72838_d((Entity)new EntityXPOrb(target.field_70170_p, target.field_70165_t, target.field_70163_u, target.field_70161_v, exp));
        }
    }

    private static void handleWisdomEffect(EntityLivingBase attacker, EntityLivingBase target, ItemStack item, int level, LivingHurtEvent event) {
        if (attacker instanceof EntityPlayer) {
            event.setAmount(event.getAmount() + Math.min(0.625f * (float)level * ((float)((EntityPlayer)attacker).field_71068_ca / 25.0f), 5.0f * (float)level));
        }
    }

    private static void handleScornEffect(EntityLivingBase attacker, EntityLivingBase target, ItemStack item, int level, LivingHurtEvent event) {
        if (target.field_71093_bK != 0) {
            event.setAmount(event.getAmount() * (float)(level + 1));
        }
    }

    private static void handleAbsorbEffect(EntityLivingBase attacker, EntityLivingBase target, ItemStack item, int level, LivingHurtEvent event) {
        if (attacker instanceof EntityPlayer && MathsUtils.tryPercentage((double)(0.05 * (double)level))) {
            EntityPlayer player = (EntityPlayer)attacker;
            int foodAmount = MathsUtils.nextIntInclusive((int)0, (int)2);
            player.func_71024_bL().func_75122_a(foodAmount, (float)foodAmount);
        }
    }

    private static void handleVenomousAspect(EntityLivingBase attacker, EntityLivingBase target, ItemStack item, int level, LivingHurtEvent event) {
        target.func_70690_d(new PotionEffect(MobEffects.field_76436_u, 120 * level, level));
    }

    private static void handleStealthEffect(EntityLivingBase user, ItemStack item, int level, PlayerInteractEvent.RightClickItem event) {
        user.func_82142_c(!user.func_82150_aj());
    }

    private static void handleVitalityEffect(EntityLivingBase attacker, ItemStack item, int level, PlayerInteractEvent.RightClickItem event) {
        item.func_77972_a(128, attacker);
        attacker.func_70690_d(new PotionEffect(MobEffects.field_76444_x, 600, level - 1));
        attacker.func_70690_d(new PotionEffect(MobEffects.field_76432_h, 10, level - 1));
        attacker.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 500, level - 1));
    }

    private static void handleFeastEffect(EntityLivingBase attacker, EntityLivingBase target, ItemStack item, int level, LivingHurtEvent event) {
        if (item.func_77952_i() > 0 && MathsUtils.tryPercentage((double)(0.1 * (double)level))) {
            item.func_77964_b(Math.max(0, item.func_77952_i() - MathsUtils.nextIntInclusive((int)(1 * level), (int)(3 * level))));
        }
    }

    private static void handleSparksEffect(EntityLivingBase attacker, EntityLivingBase target, ItemStack item, int level, LivingHurtEvent event) {
        for (EntityLivingBase entity : EntityUtils.getEntitiesInArea(EntityLivingBase.class, (World)target.func_130014_f_(), (BlockPos)target.func_180425_c(), (int)level)) {
            if (entity == attacker || entity == target || entity.func_70045_F() || entity.func_70644_a(MobEffects.field_76426_n)) continue;
            entity.func_70015_d(4 + level);
            target.func_70097_a(DamageSource.field_76370_b, (float)level);
        }
    }

    private static void handleIgniteEffect(EntityLivingBase attacker, EntityLivingBase target, ItemStack item, int level, LivingHurtEvent event) {
        if (!target.func_70045_F() && !target.func_70644_a(MobEffects.field_76426_n)) {
            target.func_70097_a(DamageSource.field_76370_b, (float)level * 2.0f);
            target.func_70015_d(1);
        }
    }

    private static void checkAndApplyEffect(Enchantment enchant, EntityLivingBase target, EntityLivingBase attacker, ItemStack heldItem, EnchantmentEffectAttack effect, LivingHurtEvent event) {
        int level = EnchantmentHelper.func_77506_a((Enchantment)enchant, (ItemStack)heldItem);
        if (level > 0) {
            effect.apply(attacker, target, heldItem, level, event);
        }
    }

    private static void checkAndApplyEffect(Enchantment enchant, EntityLivingBase attacker, ItemStack heldItem, EnchantmentEffectItemUse effect, PlayerInteractEvent.RightClickItem event) {
        int level = EnchantmentHelper.func_77506_a((Enchantment)enchant, (ItemStack)heldItem);
        if (level > 0) {
            effect.apply(attacker, heldItem, level, event);
        }
    }

    private static void checkAndApplyEffect(Enchantment enchant, EntityLivingBase user, ItemStack heldItem, EnchantmentEffectAttacked effect, LivingHurtEvent event) {
        int level = EnchantmentHelper.func_77506_a((Enchantment)enchant, (ItemStack)heldItem);
        if (level > 0) {
            effect.apply(user, heldItem, level, event);
        }
    }

    private static void checkAndApplyEffect(Enchantment enchantment, EntityLivingBase user, ItemStack heldItem, EnchantmentEffectTick effect) {
        int level = EnchantmentHelper.func_77506_a((Enchantment)enchantment, (ItemStack)heldItem);
        if (level > 0) {
            effect.apply(user, heldItem, level);
        }
    }

    private static interface EnchantmentEffectTick {
        public void apply(EntityLivingBase var1, ItemStack var2, int var3);
    }

    private static interface EnchantmentEffectAttacked {
        public void apply(EntityLivingBase var1, ItemStack var2, int var3, LivingHurtEvent var4);
    }

    private static interface EnchantmentEffectItemUse {
        public void apply(EntityLivingBase var1, ItemStack var2, int var3, PlayerInteractEvent.RightClickItem var4);
    }

    private static interface EnchantmentEffectAttack {
        public void apply(EntityLivingBase var1, EntityLivingBase var2, ItemStack var3, int var4, LivingHurtEvent var5);
    }
}

