/*
 * Decompiled with CFR 0.152.
 */
package kais.outfox.fox;

import com.google.common.collect.Iterables;
import com.google.common.collect.ObjectArrays;
import javax.annotation.Nullable;
import kais.outfox.OutfoxConfig;
import kais.outfox.OutfoxResources;
import kais.outfox.fox.EntityFox;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;

public class EntityAIStealFromOwnersAttacker
extends EntityAIBase {
    private final EntityFox fox;
    private final double speedApproach;
    private final double speedRetreat;
    private boolean running;
    private int minDamage;
    private int maxDamage;
    private int pathCooldown;
    private int attentionTimer;
    private int aggroOdds;
    private boolean approachPhase;
    private boolean retreatPhase;
    @Nullable
    private EntityLivingBase revengeTarget;
    @Nullable
    private String revengeSlot;

    public EntityAIStealFromOwnersAttacker(EntityFox foxIn, double speedAIn, double speedRIn) {
        this.fox = foxIn;
        this.speedApproach = speedAIn;
        this.speedRetreat = speedRIn;
        this.revengeTarget = null;
        this.approachPhase = false;
        this.retreatPhase = false;
        this.updateStats();
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        return OutfoxConfig.stealing.stealing_enabled && this.fox.func_70909_n() && this.fox.func_70902_q() != null && !this.fox.func_70631_g_() && !this.fox.func_70906_o() && this.fox.func_110143_aJ() >= (float)OutfoxConfig.stealing.stealing_minhealth && this.fox.stealCooldown == 0 && !this.fox.hasStolenItem() && this.getRevengeTarget() && this.getTargetSlot();
    }

    public boolean func_75253_b() {
        if (OutfoxConfig.stealing.stealing_enabled && this.fox.func_70902_q() != null && !this.fox.func_70902_q().field_70128_L && !this.fox.func_70906_o() && this.revengeTarget != null && !this.revengeTarget.field_70128_L && this.shouldTargetWithConfig(this.revengeTarget)) {
            if (this.fox.hasStolenItem()) {
                return true;
            }
            if (this.revengeSlot == null || !this.targetSlotHasItem(this.revengeSlot)) {
                for (int i = 0; i < 3; ++i) {
                    if (!this.getTargetSlot()) continue;
                    return true;
                }
                return this.resetToNoTarget();
            }
            return true;
        }
        return this.resetToNoTarget();
    }

    public void func_75249_e() {
        this.running = true;
        this.pathCooldown = 10;
        if (this.fox.hasStolenItem()) {
            this.retreatPhase = true;
        } else {
            this.approachPhase = true;
        }
    }

    public void func_75246_d() {
        if (this.approachPhase) {
            if (this.fox.func_70032_d((Entity)this.revengeTarget) >= 1.25f) {
                this.tryPathWithCooldown(this.revengeTarget, this.speedApproach);
            } else if (this.tryStealItem()) {
                this.revengeSlot = null;
                this.approachPhase = false;
                this.retreatPhase = true;
            }
        }
        if (this.retreatPhase) {
            if (this.attentionTimer > 0) {
                this.targetLookAtMe();
                --this.attentionTimer;
            }
            if (this.fox.func_70032_d((Entity)this.fox.func_70902_q()) >= 1.25f) {
                this.tryPathWithCooldown(this.fox.func_70902_q(), this.speedRetreat);
            } else if (this.fox.dropStolenItem()) {
                this.fleeFromTarget();
                this.resetToNoTarget();
                this.fox.stealCooldown = 100;
            }
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    private void updateStats() {
        this.minDamage = OutfoxConfig.stealing.stealing_mindamage;
        this.maxDamage = OutfoxConfig.stealing.stealing_maxdamage;
        this.aggroOdds = OutfoxConfig.stealing.stealing_aggrochance;
    }

    private boolean getRevengeTarget() {
        EntityLivingBase target = this.fox.func_70902_q().func_70643_av();
        if (target != null && !target.field_70128_L && this.shouldTargetWithConfig(target)) {
            Iterable items;
            Iterable iterable = items = OutfoxConfig.stealing.stealing_armor ? target.func_184209_aF() : target.func_184214_aD();
            if (!Iterables.isEmpty((Iterable)items)) {
                this.revengeTarget = target;
                return true;
            }
        }
        return this.resetToNoTarget();
    }

    private boolean getTargetSlot() {
        Iterable items;
        if (this.revengeTarget == null) {
            return false;
        }
        Iterable iterable = items = OutfoxConfig.stealing.stealing_armor ? this.revengeTarget.func_184209_aF() : this.revengeTarget.func_184214_aD();
        if (!Iterables.isEmpty((Iterable)items)) {
            int i;
            String[] slotsAll = this.getPossibleTargetSlots();
            for (i = 0; i < slotsAll.length; ++i) {
                ItemStack item = this.revengeTarget.func_184582_a(this.getSlotFromName(slotsAll[i]));
                if (!item.func_190926_b() && OutfoxResources.checkItemIdIsBlacklisted(item.func_77973_b().getRegistryName().toString())) continue;
                slotsAll[i] = null;
            }
            for (i = 0; i < 8; ++i) {
                String slot = slotsAll[this.fox.func_70681_au().nextInt(slotsAll.length)];
                if (slot == null || !this.targetSlotHasItem(slot)) continue;
                this.revengeSlot = slot;
                return true;
            }
            return this.resetToNoTarget();
        }
        return false;
    }

    private boolean tryStealItem() {
        if (this.fox.hasStolenItem()) {
            return this.resetToNoTarget();
        }
        ItemStack item = this.revengeTarget.func_184582_a(this.getSlotFromName(this.revengeSlot)).func_77946_l();
        if (!item.func_190926_b() && OutfoxResources.checkItemIdIsBlacklisted(item.func_77973_b().getRegistryName().toString())) {
            if (this.maxDamage != 0) {
                int damage = this.maxDamage <= this.minDamage ? Math.round((float)item.func_77958_k() * (1.0f - (float)this.maxDamage * 0.01f)) : Math.round((float)item.func_77958_k() * (1.0f - (float)(this.fox.func_70681_au().nextInt(this.maxDamage - this.minDamage) + this.minDamage) * 0.01f));
                item.func_77972_a(damage, (EntityLivingBase)this.fox);
            }
            this.fox.setStolenItem(item);
            this.revengeTarget.func_184201_a(this.getSlotFromName(this.revengeSlot), ItemStack.field_190927_a);
            this.fox.playStealSound();
            this.startleTarget();
            return true;
        }
        return false;
    }

    private void startleTarget() {
        if (!this.revengeTarget.func_184218_aH() && (this.revengeTarget.field_70122_E || this.revengeTarget.func_70090_H())) {
            this.revengeTarget.func_70024_g(0.0, 0.5, 0.0);
        }
        if (this.aggroOdds > 0 && (this.aggroOdds == 100 || this.fox.func_70681_au().nextInt(100) < this.aggroOdds)) {
            if (this.revengeTarget instanceof EntityLiving) {
                ((EntityLiving)this.revengeTarget).func_70624_b((EntityLivingBase)this.fox);
            }
            this.revengeTarget.func_70604_c((EntityLivingBase)this.fox);
        }
        this.attentionTimer = this.fox.func_70681_au().nextInt(16) + 25;
    }

    private void targetLookAtMe() {
        if (this.revengeTarget != null && !this.revengeTarget.field_70128_L && this.revengeTarget instanceof EntityLiving) {
            ((EntityLiving)this.revengeTarget).func_70671_ap().func_75651_a((Entity)this.fox, (float)((EntityLiving)this.revengeTarget).func_184649_cE(), (float)((EntityLiving)this.revengeTarget).func_70646_bf());
        } else {
            this.attentionTimer = 0;
        }
    }

    private void fleeFromTarget() {
        if (this.aggroOdds == 0) {
            return;
        }
        BlockPos ownerPos = this.fox.func_70902_q().func_180425_c();
        BlockPos targetPos = this.revengeTarget.func_180425_c();
        int targetX = ownerPos.func_177958_n() + (int)Math.signum(ownerPos.func_177958_n() - targetPos.func_177958_n()) * 7;
        int targetZ = ownerPos.func_177952_p() + (int)Math.signum(ownerPos.func_177952_p() - targetPos.func_177952_p()) * 7;
        this.fox.func_70661_as().func_75492_a((double)targetX, (double)ownerPos.func_177956_o(), (double)targetZ, this.speedRetreat);
    }

    private boolean shouldTargetWithConfig(EntityLivingBase target) {
        return target instanceof EntityPlayer ? OutfoxConfig.stealing.stealing_players : OutfoxResources.checkEntityIdIsBlacklisted(EntityList.func_191301_a((Entity)target).toString());
    }

    private String[] getPossibleTargetSlots() {
        Object[] slotsArmor = new String[]{"head", "chest", "legs", "feet"};
        Object[] slotsHands = new String[]{"mainhand", "offhand"};
        return OutfoxConfig.stealing.stealing_armor ? (String[])ObjectArrays.concat((Object[])slotsArmor, (Object[])slotsHands, String.class) : slotsHands;
    }

    private EntityEquipmentSlot getSlotFromName(String name) {
        return EntityEquipmentSlot.func_188451_a((String)name);
    }

    private boolean targetSlotHasItem(String slot) {
        return this.revengeTarget.func_190630_a(this.getSlotFromName(slot));
    }

    private boolean resetToNoTarget() {
        this.revengeTarget = null;
        this.revengeSlot = null;
        this.approachPhase = false;
        this.retreatPhase = false;
        this.updateStats();
        return false;
    }

    private void tryPathWithCooldown(EntityLivingBase entity, double speed) {
        if (--this.pathCooldown <= 0) {
            this.pathCooldown = 10;
            this.fox.func_70661_as().func_75497_a((Entity)entity, speed);
        }
    }
}

