/*
 * Decompiled with CFR 0.152.
 */
package kais.outfox.fox;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import kais.outfox.OutfoxConfig;
import kais.outfox.OutfoxResources;
import kais.outfox.fox.EntityFox;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class EntityAISearchForBlock
extends EntityAIBase {
    private final EntityFox fox;
    private final double speed;
    @Nullable
    private Path path;
    private boolean running;
    private int frequency;
    private int range;
    private int odds;
    private int searchesSinceBlockFound;
    private int obstructionDepth;
    private int[] target;

    public EntityAISearchForBlock(EntityFox foxIn, double speedIn) {
        this.fox = foxIn;
        this.speed = speedIn;
        this.searchesSinceBlockFound = -1;
        this.target = new int[3];
        this.updateStats();
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        return OutfoxConfig.search.search_enabled && this.fox.func_70909_n() && this.fox.func_70902_q() != null && !this.fox.func_70631_g_() && !this.fox.func_70906_o() && this.fox.searchedBlock != null && this.fox.func_70068_e((Entity)this.fox.func_70902_q()) <= 160.0 && OutfoxResources.checkBlockIdIsBlacklisted(this.fox.searchedBlock.getRegistryName().toString()) && (!this.isBlockFound() && this.fox.field_70173_aa % this.frequency == 0 && this.doBlockSearch() || this.isBlockFound()) && this.isPathOk(true);
    }

    public boolean func_75253_b() {
        return OutfoxConfig.search.search_enabled && this.fox.func_70902_q() != null && !this.fox.func_70906_o() && this.fox.searchedBlock != null && this.fox.func_70068_e((Entity)this.fox.func_70902_q()) <= 160.0 && OutfoxResources.checkBlockIdIsBlacklisted(this.fox.searchedBlock.getRegistryName().toString()) && this.isBlockFound() && this.isPathOk(false);
    }

    public void func_75249_e() {
        this.running = true;
        this.doPath();
    }

    public void func_75246_d() {
        if (this.fox.field_70173_aa % this.frequency == 0) {
            boolean b = this.isBlockFound();
            this.updateStats();
            if (this.searchesSinceBlockFound < 8) {
                ++this.searchesSinceBlockFound;
            } else {
                this.reset();
            }
            if (this.fox.field_70170_p.func_180495_p(new BlockPos(this.target[0], this.target[1], this.target[2])).func_177230_c() == this.fox.searchedBlock) {
                b = true;
                this.reset();
                this.searchesSinceBlockFound = 0;
            } else {
                this.reset();
            }
            boolean bl = b = b || this.doBlockSearch();
            if (b && this.fox.field_70122_E) {
                this.doPath();
            }
        }
    }

    public boolean isBlockFound() {
        return this.searchesSinceBlockFound != -1;
    }

    @Nullable
    public int[] getTargetBlock() {
        return this.isBlockFound() ? this.target : null;
    }

    public boolean isRunning() {
        return this.running;
    }

    protected void reset() {
        this.running = false;
        this.searchesSinceBlockFound = -1;
        this.fox.searchNavigator.func_75499_g();
        this.fox.func_70661_as().func_75499_g();
    }

    protected void updateStats() {
        this.frequency = Math.max(1, OutfoxConfig.search.search_frequency);
        this.range = Math.max(1, OutfoxConfig.search.search_range);
        this.odds = Math.max(0, Math.min(100, OutfoxConfig.search.search_odds));
        this.obstructionDepth = Math.max(0, OutfoxConfig.search.obstruction_depth);
        this.fox.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(Math.max(56.0, (double)this.range));
    }

    private void doPath() {
        if (this.fox.searchNavigator.func_75484_a(this.path, this.speed)) {
            this.running = true;
            this.fox.field_70170_p.func_72960_a((Entity)this.fox, (byte)9);
        }
    }

    private boolean doBlockSearch() {
        if (this.odds > 0 && this.fox.func_70681_au().nextInt(100) < this.odds) {
            return false;
        }
        double d = Double.MAX_VALUE;
        BlockPos p = this.fox.func_180425_c();
        for (BlockPos.MutableBlockPos i : BlockPos.func_177975_b((BlockPos)new BlockPos(p.func_177958_n() - this.range, p.func_177956_o() - this.range, p.func_177952_p() - this.range), (BlockPos)new BlockPos(p.func_177958_n() + this.range, p.func_177956_o() + this.range, p.func_177952_p() + this.range))) {
            double d1;
            IBlockState state = this.fox.field_70170_p.func_180495_p((BlockPos)i);
            if (state.func_177230_c() != this.fox.searchedBlock || !this.checkTagMatches(state) || !this.checkBlockIsUnobstructed((BlockPos)i, (BlockPos)i, 0) || !((d1 = this.fox.func_174818_b((BlockPos)i)) < d)) continue;
            this.searchesSinceBlockFound = 0;
            this.target[0] = i.func_177958_n();
            this.target[1] = i.func_177956_o();
            this.target[2] = i.func_177952_p();
            d = d1;
        }
        return d < Double.MAX_VALUE;
    }

    private boolean isPathOk(boolean beginning) {
        Path p = this.fox.searchNavigator.func_75488_a((double)this.target[0] + 0.5, (double)this.target[1] + 1.0, (double)this.target[2] + 0.5);
        if (p != null) {
            this.path = p;
            return beginning != p.func_75879_b();
        }
        return false;
    }

    private boolean checkTagMatches(IBlockState state) {
        if (this.fox.stateTags == null) {
            return false;
        }
        Iterator<Map.Entry<String, String>> i = this.fox.stateTags.entrySet().iterator();
        HashMap<String, String> properties = OutfoxResources.blockStateToHashMap(state);
        while (i.hasNext()) {
            Map.Entry<String, String> e = i.next();
            if (e.getKey() == null || e.getValue() == null || !properties.containsKey(e.getKey()) || properties.get(e.getKey()).equals(e.getValue())) continue;
            return false;
        }
        return true;
    }

    private boolean checkBlockIsUnobstructed(BlockPos pos, BlockPos prevPos, int level) {
        if (level >= this.obstructionDepth) {
            return true;
        }
        int obstructedSides = 0;
        IBlockState s = this.fox.field_70170_p.func_180495_p(pos);
        for (EnumFacing f : EnumFacing.values()) {
            BlockPos neighbor = pos.func_177972_a(f);
            if (!neighbor.equals((Object)prevPos) && s.func_185887_b(this.fox.field_70170_p, neighbor) != -1.0f && this.checkBlockIsUnobstructed(neighbor, pos, level + 1)) continue;
            ++obstructedSides;
        }
        return obstructedSides < Math.max(1, 6 - level);
    }
}

