/*
 * Decompiled with CFR 0.152.
 */
package kais.outfox;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import kais.outfox.OutfoxConfig;
import net.minecraft.block.Block;
import net.minecraft.block.state.BlockStateBase;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OutfoxResources {
    public static final String MODID = "outfox";
    public static final String NAME = "Outfox";
    public static final String VERSION = "0.1.5";
    private static final Logger LOGGER = LogManager.getLogger((String)"outfox");
    private static final ResourceLocation FOX_IDLE_RL = new ResourceLocation("outfox", "fox.idle");
    private static final ResourceLocation FOX_SNIFF_RL = new ResourceLocation("outfox", "fox.sniff");
    private static final ResourceLocation FOX_STEAL_RL = new ResourceLocation("outfox", "fox.steal");
    private static final ResourceLocation FOX_HURT_RL = new ResourceLocation("outfox", "fox.hurt");
    private static final ResourceLocation FOX_DEATH_RL = new ResourceLocation("outfox", "fox.death");
    public static final SoundEvent FOX_IDLE_SND = (SoundEvent)new SoundEvent(FOX_IDLE_RL).setRegistryName(FOX_IDLE_RL);
    public static final SoundEvent FOX_SNIFF_SND = (SoundEvent)new SoundEvent(FOX_SNIFF_RL).setRegistryName(FOX_SNIFF_RL);
    public static final SoundEvent FOX_STEAL_SND = (SoundEvent)new SoundEvent(FOX_STEAL_RL).setRegistryName(FOX_STEAL_RL);
    public static final SoundEvent FOX_HURT_SND = (SoundEvent)new SoundEvent(FOX_HURT_RL).setRegistryName(FOX_HURT_RL);
    public static final SoundEvent FOX_DEATH_SND = (SoundEvent)new SoundEvent(FOX_DEATH_RL).setRegistryName(FOX_DEATH_RL);
    public static final SoundEvent[] FOX_SND_SET = new SoundEvent[]{FOX_IDLE_SND, FOX_SNIFF_SND, FOX_STEAL_SND, FOX_HURT_SND, FOX_DEATH_SND};
    public static final String[] DEFAULT_COMMON_BIOMES = new String[]{"minecraft:roofed_forest", "minecraft:mutated_roofed_forest"};
    public static final String[] DEFAULT_RARE_BIOMES = new String[]{"minecraft:forest", "minecraft:forest_hills", "minecraft:birch_forest", "minecraft:birch_forest_hills", "minecraft:mutated_forest", "minecraft:mutated_birch_forest", "minecraft:mutated_birch_forest_hills"};
    public static final String[] DEFAULT_IMMUNE_TOOLS = new String[]{"pick", "shovel", "hammer", "excavator", "mattock", "paxel", "drill", "disassembler", "destructionwand"};
    public static final String[] DEFAULT_SEARCH_BLACKLIST = new String[0];
    public static final String[] DEFAULT_STATE_MATCHES = new String[]{"color", "colour", "type", "variant", "compression_level_", "decorstates", "foliage", "shade"};
    public static final String[] DEFAULT_ITEM_ALIASES = new String[0];
    public static final String[] DEFAULT_UNSTEALABLE_ITEMS = new String[]{"minecraft:skull"};
    public static final String[] DEFAULT_UNSTEALABLE_ENTITIES = new String[]{"minecraft:witch"};

    public static void logInfo(String message) {
        if (OutfoxConfig.general.logging_enabled) {
            LOGGER.info(message);
        }
    }

    public static void logWarn(String message) {
        if (OutfoxConfig.general.logging_enabled) {
            LOGGER.warn(message);
        }
    }

    public static void logError(String message) {
        if (OutfoxConfig.general.logging_enabled) {
            LOGGER.error(message);
        }
    }

    private static ArrayList<Biome> stringsToBiomes(String[] input) {
        ArrayList<Biome> biomes = new ArrayList<Biome>();
        for (String i : input) {
            String[] j = i.split(":", 2);
            if (j.length != 2) {
                OutfoxResources.logWarn("Invalid biome ID '" + i + "' in biome config, skipped");
                continue;
            }
            Biome b = (Biome)Biome.field_185377_q.func_82594_a((Object)new ResourceLocation(j[0], j[1]));
            if (b != null) {
                biomes.add(b);
                continue;
            }
            OutfoxResources.logWarn("Invalid biome ID '" + i + "' in biome config, skipped");
        }
        return biomes;
    }

    private static ArrayList<Biome> stringTypesToBiomes(String[] input) {
        ArrayList<Biome> biomes = new ArrayList<Biome>();
        Collection allBiomes = BiomeDictionary.Type.getAll();
        Map biomesByType = allBiomes.stream().collect(Collectors.toMap(BiomeDictionary.Type::getName, Function.identity()));
        for (String biome : input) {
            String b = biome.toUpperCase();
            if (allBiomes.contains(biomesByType.get(b))) {
                biomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.getType((String)biome, (BiomeDictionary.Type[])new BiomeDictionary.Type[0])));
                continue;
            }
            OutfoxResources.logWarn("Invalid biome type '" + biome + "' in biome config, skipped");
        }
        return biomes;
    }

    public static ArrayList<Biome> mergeBiomes(String[] inputBiomes, String[] inputTypes) {
        ArrayList<Biome> biomes = OutfoxResources.stringsToBiomes(inputBiomes);
        biomes.addAll(OutfoxResources.stringTypesToBiomes(inputTypes));
        return biomes;
    }

    public static HashMap<String, String> blockStateToHashMap(IBlockState state) {
        return OutfoxResources.stateStringToHashMap(((BlockStateBase)state).toString(), state.func_177230_c().getRegistryName().toString());
    }

    public static HashMap<String, String> stateStringToHashMap(String statestring, @Nullable String block) {
        HashMap<String, String> map = new HashMap<String, String>(OutfoxConfig.search.state_matches.length);
        if (!statestring.contains("[")) {
            return map;
        }
        for (String s : OutfoxConfig.search.state_matches) {
            Pattern pattern = Pattern.compile("(?:[\\[,]" + s + ".*?=)(.*?(?=[\\],]))");
            Matcher matcher = pattern.matcher(statestring);
            if (!matcher.find()) continue;
            String g = matcher.group(1);
            if (s != null && !s.equals("")) {
                if (g != null && !g.equals("")) {
                    map.put(s, g);
                    continue;
                }
                OutfoxResources.logWarn("The blockstate '" + s + "' was found on block '" + (block == null ? "(unknown)" : block) + "' but had null or blank value, ignoring");
                continue;
            }
            OutfoxResources.logError("A null or blank blockstate was found on block '" + (block == null ? "(unknown)" : block) + "', this is probably caused by bad configs, it will be ignored");
        }
        return map;
    }

    @Nullable
    public static String[] getAliasedItem(ItemStack itemIn) {
        ResourceLocation rl = itemIn.func_77973_b().getRegistryName();
        for (String alias : OutfoxConfig.search.search_aliases) {
            if (!alias.startsWith(rl.toString())) continue;
            String[] s0 = alias.split("/");
            if (s0.length != 2) {
                OutfoxResources.logError("The item alias entry '" + alias + "' is malformed (must be split by exactly one '/'), it will be ignored");
                break;
            }
            String[] s1 = s0[0].split(":");
            if (s1.length > 3) {
                OutfoxResources.logError("The item alias entry '" + alias + "' is malformed (item ID must be formatted as item:id OR item:id:meta), it will be ignored");
                break;
            }
            if (s1.length != 2 && (s1.length != 3 || Integer.valueOf(s1[2]).intValue() != itemIn.func_77960_j())) continue;
            String[] s2 = s0[1].split("\\[");
            if (Block.func_149684_b((String)s2[0]) != null) {
                return new String[]{s2[0], "[" + s2[1]};
            }
            OutfoxResources.logError("The item alias entry '" + alias + "' is malformed (block ID '" + s2[0] + "' could not be resolved), it will be ignored");
            break;
        }
        return null;
    }

    public static boolean checkBlockIdIsBlacklisted(String blockname) {
        return OutfoxConfig.search.search_listmode == Arrays.asList(OutfoxConfig.search.search_list).contains(blockname);
    }

    public static boolean checkItemIdIsBlacklisted(String itemname) {
        return OutfoxConfig.stealing.stealing_itemsmode == Arrays.asList(OutfoxConfig.stealing.stealing_items).contains(itemname);
    }

    public static boolean checkEntityIdIsBlacklisted(String itemname) {
        return OutfoxConfig.stealing.stealing_entitymode == Arrays.asList(OutfoxConfig.stealing.stealing_entities).contains(itemname);
    }
}

