/*
 * Decompiled with CFR 0.152.
 */
package bounceable.mixin.vanilla;

import bounceable.Bounceable;
import bounceable.handlers.ForgeConfigHandler;
import bounceable.mixin.vanilla.IEntityLivingBaseMixin;
import bounceable.util.BounceBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockWall;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Block.class})
public abstract class BlockMixin {
    @Inject(method={"onFallenUpon"}, at={@At(value="HEAD")}, cancellable=true)
    public void bounceable_vanillaBlock_onFallenUpon(World worldIn, BlockPos pos, Entity entityIn, float fallDistance, CallbackInfo ci) {
        if (entityIn.func_70093_af()) {
            return;
        }
        BounceBlock bb = (BounceBlock)ForgeConfigHandler.getBounceMap().get((Object)((Block)this));
        if (bb != null) {
            boolean valid = false;
            if (bb.getMeta() == null) {
                valid = true;
            } else {
                IBlockState state = worldIn.func_180495_p(pos);
                if (bb.getMeta().contains(((Block)this).func_176201_c(state))) {
                    valid = true;
                }
            }
            if (valid) {
                entityIn.func_180430_e(fallDistance, 0.0f);
                ci.cancel();
            }
        }
    }

    @Inject(method={"onLanded"}, at={@At(value="HEAD")}, cancellable=true)
    public void bounceable_vanillaBlock_onLanded(World worldIn, Entity entityIn, CallbackInfo ci) {
        BounceBlock bb;
        if (entityIn.func_70093_af()) {
            return;
        }
        if (entityIn.field_70181_x < -0.15 && (bb = (BounceBlock)ForgeConfigHandler.getBounceMap().get((Object)((Block)this))) != null) {
            boolean valid = false;
            if (bb.getMeta() == null) {
                valid = true;
            } else {
                BlockPos blockpos1;
                IBlockState iblockstate1;
                Block block1;
                int z1;
                int y1;
                int x1 = MathHelper.func_76128_c((double)entityIn.field_70165_t);
                BlockPos blockpos = new BlockPos(x1, y1 = MathHelper.func_76128_c((double)(entityIn.field_70163_u - (double)0.2f)), z1 = MathHelper.func_76128_c((double)entityIn.field_70161_v));
                IBlockState iblockstate = worldIn.func_180495_p(blockpos);
                if (iblockstate.func_185904_a() == Material.field_151579_a && ((block1 = (iblockstate1 = worldIn.func_180495_p(blockpos1 = blockpos.func_177977_b())).func_177230_c()) instanceof BlockFence || block1 instanceof BlockWall || block1 instanceof BlockFenceGate)) {
                    iblockstate = iblockstate1;
                }
                if (bb.getMeta().contains(((Block)this).func_176201_c(iblockstate))) {
                    valid = true;
                }
            }
            if (valid) {
                double x = entityIn.field_70181_x = -entityIn.field_70181_x;
                if (entityIn instanceof EntityPlayer) {
                    if (((IEntityLivingBaseMixin)entityIn).getIsJumping()) {
                        double limitFactor = bb.getLimitFactor();
                        double gainFactor = bb.getGainFactor();
                        entityIn.field_70181_x = x + x * gainFactor * (limitFactor - x) / (limitFactor + x);
                        if (ForgeConfigHandler.debugInfo) {
                            Bounceable.LOGGER.log(Level.INFO, "JumpBounce, motionIn: " + x + " motionOut: " + entityIn.field_70181_x);
                        }
                    } else {
                        entityIn.field_70181_x *= 0.9;
                    }
                } else if (!(entityIn instanceof EntityLivingBase)) {
                    entityIn.field_70181_x *= 0.8;
                }
                ci.cancel();
            }
        }
    }
}

