/*
 * Decompiled with CFR 0.152.
 */
package bounceable.handlers;

import bounceable.Bounceable;
import bounceable.util.BounceBlock;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.logging.log4j.Level;

@Config(modid="bounceable")
public class ForgeConfigHandler {
    private static Object2ObjectArrayMap<Block, BounceBlock> bounceMap = null;
    @Config.Comment(value={"Entries of blocks that should be made bounceable, with metadata restrictions and bouncing factors \nFormat: String blockId, Int metadata... (Optional), Double limitFactor, Double gainFactor \n\nBlockId: The ResourceLocation id of the block to be made bounceable, ex. minecraft:dirt \nMetadata: Limits bouncing to only blockstates with the matching metadata, such as mushroom block types \nLimitFactor: Limiting factor used in the motion formula, higher values equal the maximum motion being higher \nGainFactor: Gain factor used in the motion formula, higher values equal the maximum motion being reached faster \n\nNote: The gain and limit factors will not be linear partly due to momentum being lost due to other MC calculations \nYou should test the values to see what feels right for you \n\nExample: minecraft:red_mushroom_block, 1, 2, 3, 4, 5, 6, 7, 8, 9, 14, 1.8, 0.6 \nExample: minecraft:soul_sand, 1.0, 0.4 \n"})
    @Config.Name(value="Bounceable Block Entries")
    public static String[] bounceArray = new String[]{"minecraft:red_mushroom_block, 1, 2, 3, 4, 5, 6, 7, 8, 9, 14, 1.8, 0.6", "minecraft:brown_mushroom_block, 1, 2, 3, 4, 5, 6, 7, 8, 9, 14, 1.8, 0.6"};
    @Config.Comment(value={"Prints debug motion information to console while bouncing"})
    @Config.Name(value="Debug Info")
    public static boolean debugInfo = false;

    public static Object2ObjectArrayMap<Block, BounceBlock> getBounceMap() {
        if (bounceMap == null) {
            ForgeConfigHandler.parseBounceMap();
        }
        return bounceMap;
    }

    private static void parseBounceMap() {
        bounceMap = new Object2ObjectArrayMap();
        for (String string : bounceArray) {
            try {
                String[] arr = string.split(",");
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(arr[0].trim()));
                if (block == null) {
                    Bounceable.LOGGER.log(Level.WARN, "Bounceable invalid block in entry: " + string + ", ignoring");
                    continue;
                }
                BounceBlock entry = new BounceBlock();
                if (arr.length > 3) {
                    ArrayList<Integer> metaList = new ArrayList<Integer>();
                    for (int x = 1; x < arr.length - 2; ++x) {
                        metaList.add(Integer.parseInt(arr[x].trim()));
                    }
                    entry.setMeta(metaList);
                }
                entry.setLimitFactor(Double.parseDouble(arr[arr.length - 2].trim()));
                entry.setGainFactor(Double.parseDouble(arr[arr.length - 1].trim()));
                bounceMap.put((Object)block, (Object)entry);
            }
            catch (Exception ex) {
                Bounceable.LOGGER.log(Level.WARN, "Bounceable failed to parse block entry: " + string + ", ignoring");
            }
        }
    }

    @Mod.EventBusSubscriber(modid="bounceable")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("bounceable")) {
                bounceMap = null;
                ConfigManager.sync((String)"bounceable", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }
}

