/*
 * Decompiled with CFR 0.152.
 */
package exterminatorjeff.undergroundbiomes.common.block;

import exterminatorjeff.undergroundbiomes.api.API;
import exterminatorjeff.undergroundbiomes.api.enums.SedimentaryVariant;
import exterminatorjeff.undergroundbiomes.api.enums.UBStoneStyle;
import exterminatorjeff.undergroundbiomes.api.enums.UBStoneType;
import exterminatorjeff.undergroundbiomes.common.block.UBStone;
import exterminatorjeff.undergroundbiomes.intermod.DropsRegistry;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class SedimentaryStone
extends UBStone {
    public static final String internal_name = "sedimentary_stone";

    public SedimentaryStone() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(SedimentaryVariant.SEDIMENTARY_VARIANT_PROPERTY, (Comparable)SedimentaryVariant.LIMESTONE));
    }

    @Override
    public String getInternalName() {
        return internal_name;
    }

    @Override
    public UBStoneType getStoneType() {
        return UBStoneType.SEDIMENTARY;
    }

    @Override
    public UBStoneStyle getStoneStyle() {
        return UBStoneStyle.STONE;
    }

    @Override
    public int getNbVariants() {
        return SedimentaryVariant.NB_VARIANTS;
    }

    @Override
    public String getVariantName(int meta) {
        return SedimentaryVariant.SEDIMENTARY_VARIANTS[meta & 7].toString();
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{SedimentaryVariant.SEDIMENTARY_VARIANT_PROPERTY});
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(SedimentaryVariant.SEDIMENTARY_VARIANT_PROPERTY, (Comparable)SedimentaryVariant.SEDIMENTARY_VARIANTS[meta & 7]);
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return ((SedimentaryVariant)state.func_177229_b(SedimentaryVariant.SEDIMENTARY_VARIANT_PROPERTY)).getMetadata();
    }

    @Override
    public void getDrops(NonNullList<ItemStack> stacks, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ItemStack itemStack;
        Item stoneBlock = this.func_180660_a(state, new Random(), fortune);
        if (stoneBlock == this.itemBlock) {
            int meta = state.func_177230_c().func_176201_c(state);
            itemStack = new ItemStack(stoneBlock, 1, meta);
        } else {
            itemStack = new ItemStack(stoneBlock, 1);
        }
        stacks.add((Object)itemStack);
        DropsRegistry.INSTANCE.addDrops((List<ItemStack>)stacks, this, world, pos, state, fortune);
    }

    @Override
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        if (state.func_177229_b(SedimentaryVariant.SEDIMENTARY_VARIANT_PROPERTY) == SedimentaryVariant.LIGNITE) {
            return API.LIGNITE_COAL.getItem();
        }
        return super.func_180660_a(state, rand, fortune);
    }

    @Override
    public int func_180651_a(IBlockState state) {
        if (state.func_177229_b(SedimentaryVariant.SEDIMENTARY_VARIANT_PROPERTY) == SedimentaryVariant.LIGNITE) {
            return 0;
        }
        return super.func_180651_a(state);
    }

    @Override
    public boolean isFortuneAffected(IBlockState state) {
        return state.func_177229_b(SedimentaryVariant.SEDIMENTARY_VARIANT_PROPERTY) == SedimentaryVariant.LIGNITE;
    }

    @Override
    public float func_176195_g(IBlockState state, World worldIn, BlockPos pos) {
        return this.getBaseHardness() * ((SedimentaryVariant)state.func_177229_b(SedimentaryVariant.SEDIMENTARY_VARIANT_PROPERTY)).getHardness();
    }

    @Override
    public float getExplosionResistance(World world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        return this.getBaseResistance() * ((SedimentaryVariant)world.func_180495_p(pos).func_177229_b(SedimentaryVariant.SEDIMENTARY_VARIANT_PROPERTY)).getResistance();
    }

    @Override
    public UBStone baseStone() {
        return this;
    }
}

