/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.util;

import net.minecraft.util.math.Vec3d;

public class Quaternion {
    private float x;
    private float y;
    private float z;
    private float w;

    public Quaternion(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public Quaternion(Quaternion quat) {
        this.x = quat.x;
        this.y = quat.y;
        this.z = quat.z;
        this.w = quat.w;
    }

    public Quaternion(Vec3d vector, float angle, boolean degrees) {
        if (degrees) {
            angle = (float)((double)angle * (Math.PI / 180));
        }
        float mag = (float)Math.sin((double)angle / 2.0);
        this.x = (float)vector.field_72450_a * mag;
        this.y = (float)vector.field_72448_b * mag;
        this.z = (float)vector.field_72449_c * mag;
        this.w = (float)Math.cos((double)angle / 2.0);
    }

    public void multiply(Quaternion quat) {
        float xr = this.w * quat.x + this.x * quat.w + this.y * quat.z - this.z * quat.y;
        float yr = this.w * quat.y - this.x * quat.z + this.y * quat.w + this.z * quat.x;
        float zr = this.w * quat.z + this.x * quat.y - this.y * quat.x + this.z * quat.w;
        float wr = this.w * quat.w - this.x * quat.x - this.y * quat.y - this.z * quat.z;
        this.x = xr;
        this.y = yr;
        this.z = zr;
        this.w = wr;
    }

    public void conjugate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
    }

    public Vec3d transformVector(Vec3d vector) {
        Quaternion resultQuat = new Quaternion(this);
        Quaternion quatVec = new Quaternion((float)vector.field_72450_a, (float)vector.field_72448_b, (float)vector.field_72449_c, 0.0f);
        resultQuat.multiply(quatVec);
        Quaternion conjQuat = new Quaternion(this);
        conjQuat.conjugate();
        resultQuat.multiply(conjQuat);
        return new Vec3d((double)resultQuat.x, (double)resultQuat.y, (double)resultQuat.z);
    }
}

